/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.List;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.CurvedGeometries;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.JTS;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.gml2.bindings.GML2ParsingUtils;
import org.geotools.gml3.ArcParameters;
import org.geotools.gml3.Circle;
import org.geotools.xsd.BindingWalkerFactory;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;

public class GML3ParsingUtils {
    public static SimpleFeature parseFeature(ElementInstance instance, Node node, Object value, FeatureTypeCache ftCache, BindingWalkerFactory bwFactory) throws Exception {
        return GML2ParsingUtils.parseFeature(instance, node, value, ftCache, bwFactory);
    }

    public static SimpleFeatureType featureType(XSDElementDeclaration element, BindingWalkerFactory bwFactory) throws Exception {
        return GML2ParsingUtils.featureType(element, bwFactory);
    }

    static SimpleFeature feature(SimpleFeatureType fType, String fid, Node node) throws Exception {
        return GML2ParsingUtils.feature(fType, fid, node);
    }

    static CoordinateReferenceSystem crs(Node node) {
        return GML2ParsingUtils.crs(node);
    }

    public static int dimensions(Node node) {
        Node current;
        for (current = node; current != null; current = current.getParent()) {
            Node dimensions = current.getAttribute("srsDimension");
            if (dimensions == null) continue;
            return ((Number)dimensions.getValue()).intValue();
        }
        for (current = node; current != null; current = current.getParent()) {
            CoordinateReferenceSystem crs = GML3ParsingUtils.crs(current);
            if (crs == null) continue;
            return crs.getCoordinateSystem().getDimension();
        }
        return 2;
    }

    static LineString lineString(Node node, GeometryFactory gf, CoordinateSequenceFactory csf) {
        return GML3ParsingUtils.line(node, gf, csf, false);
    }

    static LinearRing linearRing(Node node, GeometryFactory gf, CoordinateSequenceFactory csf) {
        return (LinearRing)GML3ParsingUtils.line(node, gf, csf, true);
    }

    static LineString line(Node node, GeometryFactory gf, CoordinateSequenceFactory csf, boolean ring) {
        if (node.hasChild(Position.class)) {
            List<Position> dps = node.getChildValues(Position.class);
            Position dp = dps.get(0);
            CoordinateSequence seq = JTS.createCS(csf, dps.size(), dp.getDimension());
            for (int i = 0; i < dps.size(); ++i) {
                dp = dps.get(i);
                for (int j = 0; j < dp.getDimension(); ++j) {
                    seq.setOrdinate(i, j, dp.getOrdinate(j));
                }
            }
            return ring ? gf.createLinearRing(seq) : gf.createLineString(seq);
        }
        if (node.hasChild(Point.class)) {
            List<Point> points = node.getChildValues(Point.class);
            Coordinate[] coordinates = new Coordinate[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                coordinates[i] = points.get(0).getCoordinate();
            }
            return ring ? gf.createLinearRing(coordinates) : gf.createLineString(coordinates);
        }
        if (node.hasChild(Coordinate.class)) {
            List<Coordinate> list = node.getChildValues(Coordinate.class);
            Coordinate[] coordinates = list.toArray(new Coordinate[list.size()]);
            return ring ? gf.createLinearRing(coordinates) : gf.createLineString(coordinates);
        }
        if (node.hasChild(Position[].class)) {
            Position[] dps = node.getChildValue(Position[].class);
            CoordinateSequence seq = null;
            if (dps.length == 0) {
                seq = JTS.createCS(csf, 0, 0);
            } else {
                seq = JTS.createCS(csf, dps.length, dps[0].getDimension());
                for (int i = 0; i < dps.length; ++i) {
                    Position dp = dps[i];
                    for (int j = 0; j < dp.getDimension(); ++j) {
                        seq.setOrdinate(i, j, dp.getOrdinate(j));
                    }
                }
            }
            return ring ? gf.createLinearRing(seq) : gf.createLineString(seq);
        }
        if (node.hasChild(CoordinateSequence.class)) {
            CoordinateSequence seq = node.getChildValue(CoordinateSequence.class);
            return ring ? gf.createLinearRing(seq) : gf.createLineString(seq);
        }
        return null;
    }

    public static CurvedGeometryFactory getCurvedGeometryFactory(ArcParameters arcParameters, GeometryFactory gFactory, CoordinateSequence cs) {
        CurvedGeometryFactory factory;
        if (gFactory instanceof CurvedGeometryFactory) {
            factory = (CurvedGeometryFactory)gFactory;
        } else if (arcParameters != null && arcParameters.getLinearizationTolerance() != null) {
            double tolerance = Double.MAX_VALUE;
            if (cs != null) {
                CircularArc arc = CurvedGeometries.getArc(cs, 0);
                Circle c = new Circle(arc.getCenter(), arc.getRadius());
                tolerance = arcParameters.getLinearizationTolerance().getTolerance(c);
            }
            factory = new CurvedGeometryFactory(gFactory, tolerance);
        } else {
            factory = new CurvedGeometryFactory(gFactory, Double.MAX_VALUE);
        }
        return factory;
    }
}

