/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageio.maskband.DatasetLayout;
import it.geosolutions.imageio.pam.PAMDataset;
import it.geosolutions.imageio.plugins.tiff.TIFFImageReadParam;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.imageioimpl.plugins.cog.CogImageInputStreamSpi;
import it.geosolutions.imageioimpl.plugins.cog.CogSourceSPIProvider;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import it.geosolutions.imageioimpl.plugins.tiff.TiffDatasetLayoutImpl;
import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import org.geotools.api.coverage.ColorInterpretation;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.FileGroupProvider;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.GroundControlPoints;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.imageio.MaskOverviewProvider;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffMetadata2CRSAdapter;
import org.geotools.coverage.grid.io.imageio.geotiff.TiePoint;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.MapInfoFileReader;
import org.geotools.data.PrjFileReader;
import org.geotools.data.WorldFileReader;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.geometry.GeneralBounds;
import org.geotools.image.ImageWorker;
import org.geotools.image.io.ImageIOExt;
import org.geotools.image.util.ImageUtilities;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.NumberRange;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class GeoTiffReader
extends AbstractGridCoverage2DReader
implements GridCoverage2DReader {
    private static final String DEFAULT_COVERAGE_NAME = "geotiff_coverage";
    private Logger LOGGER = Logging.getLogger(GeoTiffReader.class);
    public static final String OVERRIDE_CRS_SWITCH = "org.geotools.gce.geotiff.override.crs";
    static boolean OVERRIDE_INNER_CRS = Boolean.valueOf(System.getProperty("org.geotools.gce.geotiff.override.crs", "True"));
    static final TIFFImageReaderSpi TIFF_READER_SPI = new TIFFImageReaderSpi();
    private ImageReaderSpi readerSpi;
    private GeoTiffMetadata2CRSAdapter gtcs;
    private double noData = Double.NaN;
    private File ovrSource;
    private ImageInputStreamSpi ovrInStreamSPI = null;
    private int extOvrImgChoice = -1;
    private MaskOverviewProvider maskOvrProvider;
    private boolean hasMaskOvrProvider;
    private GroundControlPoints gcps;
    private PAMDataset pamDataset;

    public GeoTiffReader(Object input) throws DataSourceException {
        this(input, new Hints(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE));
    }

    public GeoTiffReader(Object input, Hints uHints) throws DataSourceException {
        super(input, uHints);
        try {
            this.readerSpi = TIFF_READER_SPI;
            if (input instanceof URL) {
                URL sourceURL = (URL)input;
                this.source = URLs.urlToFile(sourceURL);
            }
            this.closeMe = true;
            if (this.source instanceof InputStream || this.source instanceof ImageInputStream) {
                this.closeMe = false;
            }
            if (this.source instanceof CogSourceSPIProvider) {
                CogSourceSPIProvider readerInputObject = (CogSourceSPIProvider)input;
                this.readerSpi = readerInputObject.getReaderSpi();
                this.inStreamSPI = readerInputObject.getStreamSpi();
                this.inStream = readerInputObject.getStream();
            } else if (this.source instanceof ImageInputStream) {
                this.inStream = (ImageInputStream)this.source;
            } else {
                this.inStreamSPI = ImageIOExt.getImageInputStreamSPI(this.source);
                if (this.inStreamSPI == null) {
                    throw new IllegalArgumentException("No input stream for the provided source");
                }
                this.inStream = this.inStreamSPI.createInputStreamInstance(this.source, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            }
            if (this.inStream == null) {
                if (this.source instanceof File) {
                    File f = (File)this.source;
                    if (!f.exists()) {
                        throw new FileNotFoundException("File " + f.getAbsolutePath() + " does not exist.");
                    }
                    if (f.isDirectory()) {
                        throw new IOException("File " + f.getAbsolutePath() + " is a directory.");
                    }
                    if (!f.canRead()) {
                        throw new IOException("File " + f.getAbsolutePath() + " can not be read.");
                    }
                }
                throw new IllegalArgumentException("No input stream for the provided source");
            }
            this.getHRInfo(this.hints);
            this.coverageName = this.extractCoverageName();
            int dotIndex = this.coverageName.lastIndexOf(46);
            if (dotIndex != -1 && dotIndex != this.coverageName.length()) {
                this.coverageName = this.coverageName.substring(0, dotIndex);
            }
        }
        catch (IOException e) {
            throw new DataSourceException(e);
        }
        finally {
            if (this.closeMe && this.inStream != null) {
                try {
                    this.inStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private String extractCoverageName() {
        if (this.source instanceof File) {
            return ((File)this.source).getName();
        }
        if (this.source instanceof CogSourceSPIProvider) {
            BasicAuthURI uri = ((CogSourceSPIProvider)this.source).getCogUri();
            String path = uri.getUri().getPath();
            int indexOf = path.lastIndexOf("/");
            int extensionIndex = (path = path.substring(indexOf + 1)).lastIndexOf(".");
            String name = extensionIndex > 0 ? path.substring(0, extensionIndex) : path;
            return name;
        }
        return DEFAULT_COVERAGE_NAME;
    }

    private void getHRInfo(Hints hints) throws DataSourceException {
        ImageReader reader = null;
        ImageReader ovrReader = null;
        ImageInputStream ovrStream = null;
        try {
            reader = this.readerSpi.createReaderInstance();
            this.inStream.mark();
            reader.setInput(this.inStream);
            IIOMetadata iioMetadata = reader.getImageMetadata(0);
            GeoTiffIIOMetadataDecoder metadata = new GeoTiffIIOMetadataDecoder(iioMetadata);
            this.gtcs = new GeoTiffMetadata2CRSAdapter(hints);
            Object tempCRS = this.hints.get(Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
            if (tempCRS != null) {
                this.crs = (CoordinateReferenceSystem)tempCRS;
                if (this.LOGGER.isLoggable(Level.FINE)) {
                    this.LOGGER.log(Level.FINE, "Using forced coordinate reference system");
                }
            } else {
                if (!ImageIOUtilities.isSkipExternalFilesLookup()) {
                    this.crs = this.getCRS(this.source);
                }
                if ((!OVERRIDE_INNER_CRS || this.crs == null) && metadata.hasGeoKey() && this.gtcs != null) {
                    this.crs = this.gtcs.createCoordinateSystem(metadata);
                }
            }
            if (metadata.hasNoData()) {
                this.noData = metadata.getNoData();
                SampleModel sampleModel = reader.getImageTypes(0).next().getSampleModel();
                if (sampleModel.getDataType() == 4) {
                    this.noData = (float)this.noData;
                }
            }
            this.collectScaleOffset(iioMetadata);
            this.pamDataset = GeoTiffReader.getPamDataset(this.getSourceAsFile(), iioMetadata);
            this.setLayout(reader);
            this.dtLayout = TiffDatasetLayoutImpl.parseLayout(reader.getStreamMetadata());
            boolean skipOverviews = hints.getOrDefault(Hints.SKIP_EXTERNAL_OVERVIEWS, ImageIOUtilities.isSkipExternalFilesLookup());
            if (skipOverviews) {
                this.LOGGER.log(Level.FINE, "Skipping GeoTiff overview sidecar files for {0}", this.source);
                ((TiffDatasetLayoutImpl)this.dtLayout).setNumExternalOverviews(0);
            }
            File inputFile = null;
            if (this.source instanceof File) {
                inputFile = (File)this.source;
            } else if (this.source instanceof URL && ((URL)this.source).getProtocol() == "file") {
                inputFile = URLs.urlToFile((URL)this.source);
            }
            if (inputFile != null) {
                URL url = URLs.fileToUrl(inputFile);
                this.maskOvrProvider = new MaskOverviewProvider(this.dtLayout, url, new MaskOverviewProvider.SpiHelper(url, TIFF_READER_SPI), skipOverviews);
                this.hasMaskOvrProvider = true;
            } else if (this.dtLayout != null && this.dtLayout.getExternalMasks() != null) {
                String path = this.dtLayout.getExternalMasks().getAbsolutePath();
                File file = new File(path.substring(0, path.length() - 4));
                URL url = URLs.fileToUrl(file);
                this.maskOvrProvider = new MaskOverviewProvider(this.dtLayout, url, new MaskOverviewProvider.SpiHelper(url, TIFF_READER_SPI), skipOverviews);
                this.hasMaskOvrProvider = true;
            } else if (this.source instanceof CogSourceSPIProvider) {
                CogSourceSPIProvider cogSourceProvider = (CogSourceSPIProvider)this.source;
                this.maskOvrProvider = new MaskOverviewProvider(null, cogSourceProvider.getSourceUrl(), new MaskOverviewProvider.SpiHelper(cogSourceProvider), skipOverviews);
                this.hasMaskOvrProvider = true;
            }
            this.numOverviews = this.hasMaskOvrProvider ? this.maskOvrProvider.getNumOverviews() : this.dtLayout.getNumInternalOverviews();
            int hrWidth = reader.getWidth(0);
            int hrHeight = reader.getHeight(0);
            Rectangle actualDim = new Rectangle(0, 0, hrWidth, hrHeight);
            this.originalGridRange = new GridEnvelope2D(actualDim);
            if (this.gtcs != null && metadata != null && (metadata.hasModelTrasformation() || metadata.hasPixelScales() && metadata.hasTiePoints())) {
                this.raster2Model = GeoTiffMetadata2CRSAdapter.getRasterToModel(metadata);
            } else {
                MapInfoFileReader mifReader;
                this.raster2Model = GeoTiffReader.parseWorldFile(this.source);
                if (this.raster2Model == null && (mifReader = GeoTiffReader.parseMapInfoFile(this.source)) != null) {
                    this.raster2Model = mifReader.getTransform();
                    this.crs = mifReader.getCRS();
                }
            }
            if (this.crs == null) {
                if (this.LOGGER.isLoggable(Level.WARNING)) {
                    this.LOGGER.warning("Coordinate Reference System is not available");
                }
                this.crs = AbstractGridFormat.getDefaultCRS();
            }
            if (this.raster2Model == null) {
                TiePoint[] modelTiePoints = metadata.getModelTiePoints();
                if (modelTiePoints != null && modelTiePoints.length > 1) {
                    this.gcps = new GroundControlPoints(Arrays.asList(modelTiePoints), this.crs);
                    this.raster2Model = ProjectiveTransform.create(new AffineTransform());
                    this.crs = AbstractGridFormat.getDefaultCRS();
                } else {
                    throw new DataSourceException("Raster to Model Transformation is not available for: " + this.getSourceAsFile());
                }
            }
            AffineTransform tempTransform = new AffineTransform((AffineTransform)((Object)this.raster2Model));
            tempTransform.concatenate(CoverageUtilities.CENTER_TO_CORNER);
            this.originalEnvelope = CRS.transform(ProjectiveTransform.create(tempTransform), (Bounds)new GeneralBounds(actualDim));
            this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
            this.highestRes = new double[2];
            this.highestRes[0] = XAffineTransform.getScaleX0(tempTransform);
            this.highestRes[1] = XAffineTransform.getScaleY0(tempTransform);
            if (this.maskOvrProvider != null) {
                this.extOvrImgChoice = this.maskOvrProvider.getNumExternalOverviews() > 0 ? this.maskOvrProvider.getNumInternalOverviews() + 1 : -1;
            } else {
                File extOvrFile = this.dtLayout.getExternalOverviews();
                if (extOvrFile != null && extOvrFile.exists()) {
                    this.ovrSource = extOvrFile;
                    this.ovrInStreamSPI = ImageIOExt.getImageInputStreamSPI(extOvrFile);
                    ovrReader = TIFF_READER_SPI.createReaderInstance();
                    ovrStream = this.ovrInStreamSPI.createInputStreamInstance(extOvrFile, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
                    ovrReader.setInput(ovrStream);
                    this.extOvrImgChoice = this.numOverviews + 1;
                    this.numOverviews += this.dtLayout.getNumExternalOverviews();
                    if (this.numOverviews < this.extOvrImgChoice) {
                        this.extOvrImgChoice = -1;
                    }
                }
            }
            if (this.numOverviews >= 1) {
                this.overViewResolutions = new double[this.numOverviews][2];
                int firstExternalOverview = this.extOvrImgChoice == -1 ? this.numOverviews : this.extOvrImgChoice - 1;
                double spanRes0 = this.highestRes[0] * (double)this.originalGridRange.getSpan(0);
                double spanRes1 = this.highestRes[1] * (double)this.originalGridRange.getSpan(1);
                if (this.maskOvrProvider != null) {
                    this.overViewResolutions = this.maskOvrProvider.getOverviewResolutions(spanRes0, spanRes1);
                } else {
                    int i;
                    for (i = 0; i < firstExternalOverview; ++i) {
                        int overviewImageIndex = this.dtLayout.getInternalOverviewImageIndex(i + 1);
                        int index = overviewImageIndex >= 0 ? overviewImageIndex : 0;
                        this.overViewResolutions[i][0] = spanRes0 / (double)reader.getWidth(index);
                        this.overViewResolutions[i][1] = spanRes1 / (double)reader.getHeight(index);
                    }
                    for (i = firstExternalOverview; i < this.numOverviews; ++i) {
                        this.overViewResolutions[i][0] = spanRes0 / (double)ovrReader.getWidth(i - firstExternalOverview);
                        this.overViewResolutions[i][1] = spanRes1 / (double)ovrReader.getHeight(i - firstExternalOverview);
                    }
                }
            } else {
                this.overViewResolutions = null;
            }
        }
        catch (Throwable e) {
            throw new DataSourceException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Throwable iioMetadata) {}
            }
            if (ovrReader != null) {
                try {
                    ovrReader.dispose();
                }
                catch (Throwable iioMetadata) {}
            }
            if (ovrStream != null) {
                try {
                    ovrStream.close();
                }
                catch (Throwable iioMetadata) {}
            }
            if (this.inStream != null) {
                try {
                    this.inStream.reset();
                }
                catch (Throwable iioMetadata) {}
            }
        }
    }

    @Override
    public Format getFormat() {
        return new GeoTiffFormat();
    }

    @Override
    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        GeneralBounds requestedEnvelope = null;
        Rectangle dim = null;
        Color inputTransparentColor = null;
        OverviewPolicy overviewPolicy = null;
        int[] suggestedTileSize = null;
        int[] bands = null;
        boolean rescalePixels = AbstractGridFormat.RESCALE_PIXELS.getDefaultValue();
        if (params != null) {
            for (GeneralParameterValue generalParameterValue : params) {
                ParameterValue param = (ParameterValue)generalParameterValue;
                ReferenceIdentifier name = param.getDescriptor().getName();
                if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    requestedEnvelope = new GeneralBounds(gg.getEnvelope2D());
                    dim = gg.getGridRange2D().getBounds();
                    continue;
                }
                if (name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName())) {
                    overviewPolicy = (OverviewPolicy)((Object)param.getValue());
                    continue;
                }
                if (name.equals(AbstractGridFormat.INPUT_TRANSPARENT_COLOR.getName())) {
                    inputTransparentColor = (Color)param.getValue();
                    continue;
                }
                if (name.equals(AbstractGridFormat.SUGGESTED_TILE_SIZE.getName())) {
                    String suggestedTileSize_ = (String)param.getValue();
                    if (suggestedTileSize_ == null || suggestedTileSize_.length() <= 0) continue;
                    int commaPosition = (suggestedTileSize_ = suggestedTileSize_.trim()).indexOf(",");
                    if (commaPosition < 0) {
                        int tileDim = Integer.parseInt(suggestedTileSize_);
                        suggestedTileSize = new int[]{tileDim, tileDim};
                        continue;
                    }
                    int tileW = Integer.parseInt(suggestedTileSize_.substring(0, commaPosition));
                    int tileH = Integer.parseInt(suggestedTileSize_.substring(commaPosition + 1));
                    suggestedTileSize = new int[]{tileW, tileH};
                    continue;
                }
                if (name.equals(AbstractGridFormat.RESCALE_PIXELS.getName())) {
                    rescalePixels = Boolean.TRUE.equals(param.getValue());
                }
                if (!name.equals(AbstractGridFormat.BANDS.getName())) continue;
                bands = (int[])param.getValue();
            }
        }
        Integer imageChoice = 0;
        TIFFImageReadParam readP = new TIFFImageReadParam();
        try {
            imageChoice = this.setReadParams(overviewPolicy, readP, requestedEnvelope, dim);
        }
        catch (TransformException e) {
            throw new DataSourceException(e);
        }
        if (bands != null) {
            readP.setBands(bands);
            readP.setDestinationType(ImageIOUtilities.getBandSelectedType(bands.length, this.getImageLayout().getSampleModel(null)));
        }
        Hints newHints = null;
        if (suggestedTileSize != null) {
            newHints = this.hints.clone();
            ImageLayout layout = new ImageLayout();
            layout.setTileGridXOffset(0);
            layout.setTileGridYOffset(0);
            layout.setTileHeight((int)suggestedTileSize[1]);
            layout.setTileWidth((int)suggestedTileSize[0]);
            newHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        }
        ParameterBlock pbjRead = new ParameterBlock();
        if (this.maskOvrProvider != null) {
            if (this.maskOvrProvider.isExternalOverview(imageChoice)) {
                pbjRead.add(this.maskOvrProvider.getSourceSpiProvider().getCompatibleSourceProvider(this.maskOvrProvider.getOvrURL()).getStream());
            } else {
                pbjRead.add(this.maskOvrProvider.getSourceSpiProvider().getStream());
            }
            pbjRead.add(this.maskOvrProvider.getOverviewIndex(imageChoice));
        } else if (this.extOvrImgChoice >= 0 && imageChoice >= this.extOvrImgChoice) {
            pbjRead.add(this.ovrInStreamSPI.createInputStreamInstance(this.ovrSource, ImageIO.getUseCache(), ImageIO.getCacheDirectory()));
            pbjRead.add(imageChoice - this.extOvrImgChoice);
        } else {
            pbjRead.add(this.getImageInputStream());
            int overviewImageIndex = this.dtLayout.getInternalOverviewImageIndex(imageChoice);
            int index = overviewImageIndex >= 0 ? overviewImageIndex : 0;
            pbjRead.add(index);
        }
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(null);
        pbjRead.add(null);
        pbjRead.add(readP);
        pbjRead.add(this.readerSpi.createReaderInstance());
        PlanarImage coverageRaster = JAI.create("ImageRead", pbjRead, newHints != null ? newHints : null);
        if (rescalePixels) {
            if (!Double.isNaN(this.noData)) {
                PlanarImage t = PlanarImage.wrapRenderedImage(coverageRaster);
                t.setProperty("GC_NODATA", new NoDataContainer(this.noData));
                coverageRaster = t;
            }
            Double[] scales = this.selectElements(this.scales, bands);
            Double[] offsets = this.selectElements(this.offsets, bands);
            coverageRaster = PlanarImage.wrapRenderedImage(ImageUtilities.applyRescaling(scales, offsets, coverageRaster, newHints));
        }
        if (inputTransparentColor != null) {
            coverageRaster = new ImageWorker(coverageRaster).setRenderingHints(newHints).makeColorTransparent(inputTransparentColor).getRenderedOperation();
        }
        ROI roi = null;
        if (this.hasMaskOvrProvider) {
            GridEnvelope ogr = this.getOriginalGridRange();
            Rectangle sourceRegion = readP.getSourceRegion() != null ? readP.getSourceRegion() : new Rectangle(ogr.getSpan(0), ogr.getSpan(1));
            MaskOverviewProvider.MaskInfo info = this.maskOvrProvider.getMaskInfo(imageChoice, sourceRegion, readP);
            if (info != null) {
                RenderedOp roiRaster = this.readROIRaster(info.streamSpi, URLs.fileToUrl(info.file), info.index, newHints, info.readParameters);
                roi = MaskOverviewProvider.scaleROI(roiRaster, coverageRaster.getBounds());
            }
        }
        AffineTransform rasterToModel = this.getRescaledRasterToModel(coverageRaster);
        try {
            return this.createCoverage(coverageRaster, ProjectiveTransform.create(rasterToModel), roi);
        }
        catch (Exception e) {
            ImageUtilities.disposePlanarImageChain(coverageRaster);
            if (e instanceof DataSourceException) {
                throw (DataSourceException)e;
            }
            throw new DataSourceException(e);
        }
    }

    private Double[] selectElements(Double[] source, int[] bands) {
        if (bands == null || source == null) {
            return source;
        }
        Double[] result = new Double[bands.length];
        for (int b = 0; b < bands.length; ++b) {
            result[b] = source[bands[b]];
        }
        return result;
    }

    private ImageInputStream getImageInputStream() throws IOException {
        if (this.inStream instanceof ImageInputStream && !this.closeMe) {
            return this.inStream;
        }
        if (this.inStreamSPI == null) {
            return ImageIO.createImageInputStream(this.source);
        }
        if (this.inStreamSPI instanceof CogImageInputStreamSpi) {
            return ((CogSourceSPIProvider)this.source).getStream();
        }
        return this.inStreamSPI.createInputStreamInstance(this.source, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
    }

    private RenderedOp readROIRaster(ImageInputStreamSpi spi, URL inFile, int index, RenderingHints newHints, ImageReadParam readP) {
        RenderedOp raster = null;
        try {
            ParameterBlock pb = new ParameterBlock();
            pb.add(spi.createInputStreamInstance(inFile, ImageIO.getUseCache(), ImageIO.getCacheDirectory()));
            pb.add(index);
            pb.add(Boolean.FALSE);
            pb.add(Boolean.FALSE);
            pb.add(Boolean.FALSE);
            pb.add(null);
            pb.add(null);
            pb.add(readP);
            pb.add(this.readerSpi.createReaderInstance());
            raster = JAI.create("ImageRead", pb, newHints != null ? newHints : null);
        }
        catch (Exception e) {
            this.LOGGER.severe("Unable to read input Mask Band for coverage: " + this.coverageName);
        }
        return raster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoTiffIIOMetadataDecoder getMetadata() {
        GeoTiffIIOMetadataDecoder metadata = null;
        ImageReader reader = null;
        boolean closeMe = true;
        ImageInputStream stream = null;
        try {
            if (this.source instanceof InputStream || this.source instanceof ImageInputStream) {
                closeMe = false;
            }
            if (this.source instanceof ImageInputStream) {
                stream = (ImageInputStream)this.source;
            } else {
                this.inStreamSPI = ImageIOExt.getImageInputStreamSPI(this.source);
                if (this.inStreamSPI == null) {
                    throw new IllegalArgumentException("No input stream for the provided source");
                }
                stream = this.inStreamSPI.createInputStreamInstance(this.source, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            }
            if (stream == null) {
                throw new IllegalArgumentException("No input stream for the provided source");
            }
            stream.mark();
            reader = this.readerSpi.createReaderInstance();
            reader.setInput(stream);
            IIOMetadata iioMetadata = reader.getImageMetadata(0);
            metadata = new GeoTiffIIOMetadataDecoder(iioMetadata);
        }
        catch (IOException e) {
            if (this.LOGGER.isLoggable(Level.SEVERE)) {
                this.LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Throwable throwable) {}
            }
            if (stream != null) {
                try {
                    stream.reset();
                }
                catch (Throwable throwable) {}
                if (closeMe) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return metadata;
    }

    protected final GridCoverage2D createCoverage(PlanarImage image, MathTransform raster2Model, ROI roi) throws IOException {
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int numBands = sm.getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        Category noDataCategory = null;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (Double.isFinite(this.noData)) {
            noDataCategory = new Category((CharSequence)Vocabulary.formatInternational(147), new Color[]{new Color(0, 0, 0, 0)}, NumberRange.create(this.noData, this.noData));
            CoverageUtilities.setNoDataProperty(properties, this.noData);
            image.setProperty("GC_NODATA", new NoDataContainer(this.noData));
        }
        if (roi != null) {
            image.setProperty("ROI", roi);
            CoverageUtilities.setROIProperty(properties, roi);
        }
        HashSet<Object> bandNames = new HashSet<Object>();
        for (int i = 0; i < numBands; ++i) {
            ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation(cm, i);
            if (colorInterpretation == null) {
                throw new IOException("Unrecognized sample dimension type");
            }
            Category[] categories = null;
            if (noDataCategory != null) {
                categories = new Category[]{noDataCategory};
            }
            Object bandName = colorInterpretation.name();
            if (colorInterpretation == ColorInterpretation.UNDEFINED || bandNames.contains(bandName)) {
                bandName = "Band" + (i + 1);
            }
            bandNames.add(bandName);
            bands[i] = new GridSampleDimension((CharSequence)bandName, categories, null);
        }
        if (this.pamDataset != null) {
            properties.put("PamDataset", this.pamDataset);
        }
        if (raster2Model != null) {
            return this.coverageFactory.create(this.coverageName, image, this.crs, raster2Model, bands, null, properties);
        }
        return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)image, new GeneralBounds(this.originalEnvelope), bands, null, properties);
    }

    private CoordinateReferenceSystem getCRS(Object source) {
        CoordinateReferenceSystem crs = null;
        if (source instanceof File || source instanceof URL && ((URL)source).getProtocol() == "file") {
            Object sourceAsString;
            if (source instanceof File) {
                sourceAsString = ((File)source).getAbsolutePath();
            } else {
                String auth = ((URL)source).getAuthority();
                String path = ((URL)source).getPath();
                sourceAsString = auth != null && !auth.equals("") ? "//" + auth + path : path;
            }
            int index = ((String)sourceAsString).lastIndexOf(".");
            String base = index > 0 ? ((String)sourceAsString).substring(0, index) + ".prj" : (String)sourceAsString + ".prj";
            File prjFile = new File(base.toString());
            if (prjFile.exists()) {
                try (FileInputStream instream = new FileInputStream(prjFile);
                     FileChannel channel = instream.getChannel();
                     PrjFileReader projReader = new PrjFileReader(channel);){
                    crs = projReader.getCoordinateReferenceSystem();
                }
                catch (IOException | FactoryException e) {
                    this.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                }
            }
        }
        return crs;
    }

    static MathTransform parseWorldFile(Object source) throws IOException {
        MathTransform raster2Model = null;
        if (source instanceof File) {
            File sourceFile = (File)source;
            String parentPath = sourceFile.getParent();
            String filename = sourceFile.getName();
            int i = filename.lastIndexOf(46);
            filename = i == -1 ? filename : filename.substring(0, i);
            String base = parentPath != null ? parentPath + File.separator + filename : filename;
            File file2Parse = new File(base + ".wld");
            if (file2Parse.exists()) {
                WorldFileReader reader = new WorldFileReader(file2Parse);
                raster2Model = reader.getTransform();
            } else {
                file2Parse = new File(base + ".tfw");
                if (file2Parse.exists()) {
                    WorldFileReader reader = new WorldFileReader(file2Parse);
                    raster2Model = reader.getTransform();
                }
            }
        }
        return raster2Model;
    }

    static MapInfoFileReader parseMapInfoFile(Object source) throws IOException {
        File sourceFile;
        File file2Parse;
        if (source instanceof File && (file2Parse = GeoTiffReader.getSibling(sourceFile = (File)source, ".tab")) != null && file2Parse.exists()) {
            MapInfoFileReader reader = new MapInfoFileReader(file2Parse);
            return reader;
        }
        return null;
    }

    @Override
    protected boolean checkName(String coverageName) {
        if (DEFAULT_COVERAGE_NAME.equalsIgnoreCase(coverageName)) {
            return true;
        }
        Utilities.ensureNonNull("coverageName", coverageName);
        return coverageName.equalsIgnoreCase(this.coverageName);
    }

    @Override
    public int getGridCoverageCount() {
        return 1;
    }

    @Override
    public GroundControlPoints getGroundControlPoints() {
        return this.gcps;
    }

    @Override
    protected List<FileGroupProvider.FileGroup> getFiles() {
        File file = this.getSourceAsFile();
        if (file == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        this.addAllSiblings(file, files, ".prj", ".tab", ".wld", ".tfw");
        if (this.hasMaskOvrProvider) {
            DatasetLayout layout = this.maskOvrProvider.getLayout();
            this.addSiblings(files, layout.getExternalMaskOverviews(), layout.getExternalOverviews(), layout.getExternalMasks());
        }
        return Collections.singletonList(new FileGroupProvider.FileGroup(file, files, null));
    }

    public MaskOverviewProvider getMaskOverviewProvider() {
        return this.maskOvrProvider;
    }
}

