/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.BinaryExpression;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.filter.function.FilterFunction_if_then_else;

public class ExpressionTypeVisitor
implements ExpressionVisitor {
    static final Map<Class<?>, List<Class<?>>> PROMOTIONS = Map.ofEntries(Map.entry(Byte.class, List.of(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class)), Map.entry(Short.class, List.of(Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class)), Map.entry(Integer.class, List.of(Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class)), Map.entry(Long.class, List.of(Long.class, Double.class, BigInteger.class, BigDecimal.class)), Map.entry(Float.class, List.of(Float.class, Double.class, BigDecimal.class)), Map.entry(Double.class, List.of(Double.class, BigDecimal.class)), Map.entry(BigInteger.class, List.of(BigInteger.class, BigDecimal.class)));
    FeatureType featureType;

    public ExpressionTypeVisitor(FeatureType featureType) {
        this.featureType = featureType;
    }

    @Override
    public Object visit(NilExpression expression, Object extraData) {
        return Object.class;
    }

    @Override
    public Object visit(Add expression, Object extraData) {
        return this.visitBinaryExpression(expression);
    }

    @Override
    public Object visit(Divide expression, Object extraData) {
        return this.visitBinaryExpression(expression);
    }

    @Override
    public Object visit(Multiply expression, Object extraData) {
        return this.visitBinaryExpression(expression);
    }

    @Override
    public Object visit(Subtract expression, Object extraData) {
        return this.visitBinaryExpression(expression);
    }

    protected Class<?> visitBinaryExpression(BinaryExpression expression) {
        Class type1 = (Class)expression.getExpression1().accept(this, null);
        Class type2 = (Class)expression.getExpression2().accept(this, null);
        return this.largestType(type1, type2);
    }

    Class<?> largestType(Class<?> type1, Class<?> type2) {
        if (type1.isAssignableFrom(type2)) {
            return type1;
        }
        if (type2.isAssignableFrom(type1)) {
            return type2;
        }
        if (Number.class.isAssignableFrom(type1) && Number.class.isAssignableFrom(type2)) {
            List<Class<?>> c1 = PROMOTIONS.get(type1);
            List<Class<?>> c2 = PROMOTIONS.get(type2);
            if (c1 == null || c2 == null) {
                return Object.class;
            }
            ArrayList intersection = new ArrayList(c1);
            intersection.retainAll(c2);
            if (intersection.isEmpty()) {
                return Object.class;
            }
            return (Class)intersection.get(0);
        }
        return this.getCommonSuperclass(type1, type2);
    }

    Class<?> getCommonSuperclass(Class<?> c1, Class<?> c2) {
        Class<?> curr = c1;
        while (!curr.isAssignableFrom(c2)) {
            curr = curr.getSuperclass();
        }
        return curr;
    }

    @Override
    public Object visit(Function expression, Object extraData) {
        FunctionName name = expression.getFunctionName();
        if (name != null && name.getReturn() != null) {
            if (FilterFunction_if_then_else.NAME.equals(name)) {
                return this.visitIfThenElse((FilterFunction_if_then_else)expression);
            }
            return name.getReturn().getType();
        }
        return Object.class;
    }

    protected Object visitIfThenElse(FilterFunction_if_then_else expression) {
        List<Expression> parameters = expression.getParameters();
        if (parameters.size() > 2) {
            Class type1 = (Class)parameters.get(1).accept(this, null);
            Class type2 = (Class)parameters.get(2).accept(this, null);
            return this.largestType(type1, type2);
        }
        return Object.class;
    }

    @Override
    public Object visit(Literal expression, Object extraData) {
        if (expression.getValue() != null) {
            return expression.getValue().getClass();
        }
        return Object.class;
    }

    @Override
    public Object visit(PropertyName expression, Object extraData) {
        AttributeDescriptor ad = expression.evaluate(this.featureType, AttributeDescriptor.class);
        if (ad != null) {
            return ad.getType().getBinding();
        }
        return Object.class;
    }
}

