/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import java.util.Collections;
import javax.xml.namespace.QName;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.filter.v1_1.OGC;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;

public class OGCNotBinding
extends AbstractComplexBinding {
    FilterFactory filterfactory;

    public OGCNotBinding(FilterFactory filterfactory) {
        this.filterfactory = filterfactory;
    }

    @Override
    public QName getTarget() {
        return OGC.Not;
    }

    public Class getType() {
        return Not.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Identifier id;
        Filter filter = node.getChildValue(Filter.class);
        if (filter == null && (id = node.getChildValue(Identifier.class)) != null) {
            filter = this.filterfactory.id(Collections.singleton(id));
        }
        return this.filterfactory.not(filter);
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        Not not = (Not)object;
        if (OGC.spatialOps.equals(name) && not.getFilter() instanceof BinarySpatialOperator) {
            return not.getFilter();
        }
        if (OGC.logicOps.equals(name) && not.getFilter() instanceof BinaryLogicOperator) {
            return not.getFilter();
        }
        if (OGC.comparisonOps.equals(name) && not.getFilter() instanceof BinaryComparisonOperator) {
            return not.getFilter();
        }
        if (OGC.comparisonOps.equals(name) && not.getFilter() instanceof PropertyIsNull) {
            return not.getFilter();
        }
        return null;
    }
}

