/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.Converters;

public class StringTemplateFunction
implements Function {
    private final List<Expression> parameters;
    private Pattern staticPattern;
    private final Literal fallback;
    volatile Object[] convertedValues;
    public static final FunctionName NAME = new FunctionNameImpl("stringTemplate", "input", "pattern", "template", "defaultValue");

    public StringTemplateFunction() {
        this.parameters = new ArrayList<Expression>();
        this.fallback = null;
    }

    public StringTemplateFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
        if (parameters.size() < 3) {
            throw new IllegalArgumentException("We need at least 3 input values, the input string, the regular expression, and the template");
        }
        if (parameters.size() > 4) {
            throw new IllegalArgumentException("We need at least 3 or 4 input values, " + parameters.size() + " were given instead");
        }
    }

    @Override
    public String getName() {
        return NAME.getName();
    }

    @Override
    public FunctionName getFunctionName() {
        return NAME;
    }

    @Override
    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }

    @Override
    public Object evaluate(Object object) {
        return this.evaluate(object, Object.class);
    }

    @Override
    public <T> T evaluate(Object object, Class<T> context) {
        Matcher matcher;
        String defaultValue = this.parameters.size() == 4 ? this.parameters.get(3).evaluate(object, String.class) : null;
        String input = this.parameters.get(0).evaluate(object, String.class);
        Pattern pattern = this.getPattern(object);
        String template = this.parameters.get(2).evaluate(object, String.class);
        String result = defaultValue;
        if (input != null && template != null && pattern != null && (matcher = pattern.matcher(input)).matches()) {
            result = this.applyTemplate(template, matcher);
        }
        if (context != null) {
            return Converters.convert(result, context);
        }
        String converted = result;
        return (T)converted;
    }

    private String applyTemplate(String template, Matcher matcher) {
        String result = template.replace("${0}", matcher.group());
        for (int i = 0; i < matcher.groupCount(); ++i) {
            int groupIdx = i + 1;
            result = result.replace("${" + groupIdx + "}", matcher.group(groupIdx));
        }
        return result;
    }

    private Pattern getPattern(Object object) {
        if (this.staticPattern != null) {
            return this.staticPattern;
        }
        Expression pe = this.parameters.get(1);
        if (pe instanceof Literal) {
            String ps = pe.evaluate(null, String.class);
            this.staticPattern = ps == null ? null : Pattern.compile(ps);
            return this.staticPattern;
        }
        String ps = pe.evaluate(object, String.class);
        if (ps == null) {
            return null;
        }
        return Pattern.compile(ps);
    }

    @Override
    public Literal getFallbackValue() {
        return this.fallback;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        List<Expression> params = this.getParameters();
        if (params != null) {
            Iterator<Expression> it = params.iterator();
            while (it.hasNext()) {
                Expression exp = it.next();
                sb.append("[");
                sb.append(exp);
                sb.append("]");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

