/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.JsonFunctionUtils;

public class JsonPointerFunction
extends FunctionExpressionImpl {
    private final JsonFactory factory = new JsonFactory();
    public static FunctionName NAME = new FunctionNameImpl("jsonPointer", FunctionNameImpl.parameter("result", Object.class), FunctionNameImpl.parameter("json", String.class), FunctionNameImpl.parameter("pointer", String.class));

    public JsonPointerFunction() {
        super(NAME);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object evaluate(Object object) {
        String json = this.getExpression(0).evaluate(object, String.class);
        String pointerSpec = this.getExpression(1).evaluate(object, String.class);
        JsonPointer expectedPointer = JsonPointer.compile((String)pointerSpec);
        if (json == null) {
            return null;
        }
        try (JsonParser parser = this.factory.createParser(json);){
            JsonPointer pointer;
            do {
                if (parser.nextToken() == JsonFunctionUtils.END_OF_STREAM) return null;
            } while (!(pointer = parser.getParsingContext().pathAsPointer()).equals((Object)expectedPointer) || parser.currentTokenId() == 5);
            switch (parser.currentTokenId()) {
                case 6: {
                    String string = parser.getText();
                    return string;
                }
                case 8: {
                    Float f = Float.valueOf(parser.getFloatValue());
                    return f;
                }
                case 7: {
                    Integer n = parser.getIntValue();
                    return n;
                }
                case 9: 
                case 10: {
                    Boolean bl = parser.getBooleanValue();
                    return bl;
                }
            }
            StringWriter writer = new StringWriter();
            try (JsonGenerator generator = this.factory.createGenerator((Writer)writer);){
                JsonFunctionUtils.serializeContents(parser, generator);
            }
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

