/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.api.filter.expression.BinaryExpression;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.Converters;

public abstract class MathExpressionImpl
extends DefaultExpression
implements BinaryExpression {
    private Expression leftValue = null;
    private Expression rightValue = null;

    protected MathExpressionImpl() {
    }

    protected MathExpressionImpl(Expression e1, Expression e2) {
        this.leftValue = e1;
        this.rightValue = e2;
    }

    @Override
    public Expression getExpression1() {
        return this.leftValue;
    }

    public void setExpression1(Expression expression) {
        if (MathExpressionImpl.isGeometryExpression(Filters.getExpressionType(expression))) {
            throw new IllegalFilterException("Attempted to add Geometry expression to math expression.");
        }
        this.leftValue = expression;
    }

    @Override
    public Expression getExpression2() {
        return this.rightValue;
    }

    public void setExpression2(Expression expression) {
        if (MathExpressionImpl.isGeometryExpression(Filters.getExpressionType(expression))) {
            throw new IllegalFilterException("Attempted to add Geometry expression to math expression.");
        }
        this.rightValue = expression;
    }

    protected void ensureOperandsSet() throws IllegalArgumentException {
        if (this.leftValue == null || this.rightValue == null) {
            throw new IllegalArgumentException("Attempted read math expression with missing sub expressions.");
        }
    }

    protected Object number(double number) {
        return number;
    }

    protected Object handleCollection(Object value1, Object value2) {
        Double scalar;
        List numericList;
        if (value1 instanceof Collection && value2 instanceof Collection) {
            throw new RuntimeException("Both Maths expressions cannot be Collections");
        }
        if (value1 instanceof Collection) {
            Collection c1 = (Collection)value1;
            numericList = c1.stream().map(v -> Converters.convert(v, Number.class)).collect(Collectors.toList());
            scalar = Filters.number(value2);
        } else {
            Collection unc = (Collection)value2;
            numericList = unc.stream().map(v -> Converters.convert(v, Number.class)).collect(Collectors.toList());
            scalar = Filters.number(value1);
        }
        return numericList.stream().map(n -> this.doArithmeticOperation(n.doubleValue(), scalar)).collect(Collectors.toList());
    }

    protected abstract Object doArithmeticOperation(Double var1, Double var2);
}

