/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.memory.MemoryState;
import org.geotools.data.store.ContentEntry;

public class MemoryEntry
extends ContentEntry {
    final SimpleFeatureType schema;
    private final Map<String, SimpleFeature> memory;

    MemoryEntry(MemoryDataStore store, SimpleFeatureType schema) {
        super(store, schema.getName());
        this.schema = schema;
        this.memory = Collections.synchronizedMap(new LinkedHashMap());
    }

    protected MemoryState createContentState(ContentEntry entry) {
        return new MemoryState((MemoryEntry)entry);
    }

    public Map<String, SimpleFeature> getMemory() {
        return this.memory;
    }

    @Override
    public String toString() {
        return "MemoryEntry '" + this.getTypeName() + "': " + this.getMemory().size() + " features";
    }

    void addFeature(SimpleFeature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Provided Feature is empty");
        }
        if (!feature.getFeatureType().equals(this.schema)) {
            throw new IllegalArgumentException("addFeatures expected " + this.schema.getTypeName() + "(but was " + feature.getFeatureType().getTypeName() + ")");
        }
        this.getMemory().put(feature.getID(), feature);
    }
}

