/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.data.DataUtilities;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.crs.ReprojectFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;

public class DefaultFeatureResults
extends DataFeatureCollection {
    private static final Logger LOGGER = Logging.getLogger(DefaultFeatureResults.class);
    protected Query query;
    protected SimpleFeatureSource featureSource;
    protected MathTransform transform;

    public DefaultFeatureResults(SimpleFeatureSource source, Query query) throws IOException {
        super(null, DefaultFeatureResults.getSchemaInternal(source, query));
        this.featureSource = source;
        SimpleFeatureType originalType = (SimpleFeatureType)source.getSchema();
        String typeName = originalType.getTypeName();
        if (typeName.equals(query.getTypeName())) {
            this.query = query;
        } else {
            this.query = new Query(query);
            this.query.setTypeName(typeName);
        }
        if (originalType.getGeometryDescriptor() == null) {
            return;
        }
        CoordinateReferenceSystem cs = null;
        if (query.getCoordinateSystemReproject() != null) {
            cs = query.getCoordinateSystemReproject();
        } else if (query.getCoordinateSystem() != null) {
            cs = query.getCoordinateSystem();
        }
        CoordinateReferenceSystem originalCRS = originalType.getGeometryDescriptor().getCoordinateReferenceSystem();
        if (query.getCoordinateSystem() != null) {
            originalCRS = query.getCoordinateSystem();
        }
        if (cs != null && cs != originalCRS) {
            try {
                this.transform = CRS.findMathTransform(originalCRS, cs, true);
            }
            catch (FactoryException noTransform) {
                throw (IOException)new IOException("Could not reproject data to " + cs).initCause(noTransform);
            }
        }
    }

    static SimpleFeatureType getSchemaInternal(SimpleFeatureSource featureSource, Query query) {
        SimpleFeatureType originalType = (SimpleFeatureType)featureSource.getSchema();
        SimpleFeatureType schema = null;
        CoordinateReferenceSystem cs = null;
        if (query.getCoordinateSystemReproject() != null) {
            cs = query.getCoordinateSystemReproject();
        } else if (query.getCoordinateSystem() != null) {
            cs = query.getCoordinateSystem();
        }
        try {
            schema = cs == null ? (query.retrieveAllProperties() ? (SimpleFeatureType)featureSource.getSchema() : DataUtilities.createSubType((SimpleFeatureType)featureSource.getSchema(), query.getPropertyNames())) : DataUtilities.createSubType(originalType, query.getPropertyNames(), cs, query.getTypeName(), null);
        }
        catch (SchemaException e) {
            LOGGER.log(Level.WARNING, "Could not change projection to " + cs, e);
            schema = null;
        }
        return schema;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return super.getSchema();
    }

    protected Transaction getTransaction() {
        if (this.featureSource instanceof FeatureStore) {
            SimpleFeatureStore featureStore = (SimpleFeatureStore)this.featureSource;
            return featureStore.getTransaction();
        }
        return Transaction.AUTO_COMMIT;
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        ReprojectFeatureReader reader = ((DataStore)this.featureSource.getDataStore()).getFeatureReader(this.query, this.getTransaction());
        int maxFeatures = this.query.getMaxFeatures();
        if (maxFeatures != Integer.MAX_VALUE) {
            reader = new MaxFeatureReader<SimpleFeatureType, SimpleFeature>(reader, maxFeatures);
        }
        if (this.transform != null) {
            reader = new ReprojectFeatureReader(reader, this.getSchema(), this.transform);
        }
        return reader;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> boundsReader() throws IOException {
        ArrayList<String> attributes = new ArrayList<String>();
        SimpleFeatureType schema = (SimpleFeatureType)this.featureSource.getSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            AttributeDescriptor at = schema.getDescriptor(i);
            if (!(at instanceof GeometryDescriptorImpl)) continue;
            attributes.add(at.getLocalName());
        }
        Query q = new Query(this.query);
        q.setPropertyNames(attributes);
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = ((DataStore)this.featureSource.getDataStore()).getFeatureReader(q, this.getTransaction());
        int maxFeatures = this.query.getMaxFeatures();
        if (maxFeatures == Integer.MAX_VALUE) {
            return reader;
        }
        return new MaxFeatureReader<SimpleFeatureType, SimpleFeature>(reader, maxFeatures);
    }

    @Override
    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope bounds;
        try {
            bounds = this.featureSource.getBounds(this.query);
        }
        catch (IOException e1) {
            bounds = new ReferencedEnvelope((CoordinateReferenceSystem)null);
        }
        if (bounds == null) {
            try {
                bounds = new ReferencedEnvelope();
                try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.boundsReader();){
                    while (reader.hasNext()) {
                        SimpleFeature feature = reader.next();
                        bounds.include(feature.getBounds());
                    }
                }
            }
            catch (IOException | IllegalAttributeException e) {
                bounds = new ReferencedEnvelope();
            }
        }
        return bounds;
    }

    @Override
    public int getCount() throws IOException {
        int count = this.featureSource.getCount(this.query);
        if (count != -1) {
            int maxFeatures = this.query.getMaxFeatures();
            return count < maxFeatures ? count : maxFeatures;
        }
        try {
            count = 0;
            try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.reader();){
                while (reader.hasNext()) {
                    reader.next();
                    ++count;
                }
            }
            return count;
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Could not read feature ", e);
        }
    }

    public SimpleFeatureCollection collection() throws IOException {
        try {
            DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
            try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.reader();){
                while (reader.hasNext()) {
                    collection.add(reader.next());
                }
            }
            return collection;
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Could not read feature ", e);
        }
    }
}

