/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.datasets;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.core.datasets.DataSetCategory;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ArchiveHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.DefaultArchiveHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.DefaultGmlHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.DefaultShpHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GmlHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.geopackage.DefaultGeoPackageHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.geopackage.GeoPackageHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.DefaultCsvHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetHandler;
import org.openstreetmap.josm.plugins.opendata.core.licenses.License;
import org.openstreetmap.josm.plugins.opendata.core.util.NamesFrUtils;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;
import org.openstreetmap.josm.tools.Pair;

public abstract class AbstractDataSetHandler {
    private String name;
    private DataSetCategory category;
    private String sourceDate;
    private File associatedFile;
    private ImageIcon menuIcon;
    private License license;
    private URL dataURL;
    private URL wikiURL;
    private URL localPortalURL;
    private URL nationalPortalURL;
    private boolean hasLicenseToBeAccepted = true;
    private ShpHandler shpHandler;
    private MifHandler mifHandler;
    private GmlHandler gmlHandler;
    private GeoPackageHandler geoPackageHandler;
    private ArchiveHandler archiveHandler;
    private SpreadSheetHandler ssHandler;
    private final Collection<JosmAction> tools = new ArrayList<JosmAction>();

    public abstract boolean acceptsFilename(String var1);

    public boolean acceptsFile(File file) {
        return this.acceptsFilename(file.getName());
    }

    public abstract void updateDataSet(DataSet var1);

    public void checkDataSetSource(DataSet ds) {
        if (ds != null) {
            for (OsmPrimitive p : ds.allPrimitives()) {
                if (!p.hasKeys() && !p.getReferrers().isEmpty()) continue;
                if (this.getSource() != null && p.get("source") == null) {
                    p.put("source", this.getSource());
                }
                if (this.sourceDate == null || p.get("source:date") != null) continue;
                p.put("source:date", this.sourceDate);
            }
        }
    }

    public void checkNames(DataSet ds) {
        if (ds != null) {
            for (OsmPrimitive p : ds.allPrimitives()) {
                if (p.get("name") == null) continue;
                p.put("name", NamesFrUtils.checkDictionary(p.get("name")));
            }
        }
    }

    protected AbstractDataSetHandler() {
        this.setShpHandler(new DefaultShpHandler());
        this.setArchiveHandler(new DefaultArchiveHandler());
        this.setCsvHandler(new DefaultCsvHandler());
        this.setGmlHandler(new DefaultGmlHandler());
        this.setGeoPackageHandler(new DefaultGeoPackageHandler());
    }

    private static boolean acceptsFilename(String filename, String[] expected, String ... extensions) {
        if (filename != null) {
            for (String expectedName : expected) {
                for (String ext : extensions) {
                    if (!Pattern.compile(expectedName + "\\." + ext, 2).matcher(filename).matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected static boolean acceptsCsvFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "csv");
    }

    protected static boolean acceptsXlsFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "xls");
    }

    protected static boolean acceptsOdsFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "ods");
    }

    protected static boolean acceptsShpFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "shp");
    }

    protected static boolean acceptsMifFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "mif");
    }

    protected static boolean acceptsMifTabFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "mif", "tab");
    }

    protected static boolean acceptsShpMifFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "shp", "mif");
    }

    protected static boolean acceptsKmlFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "kml");
    }

    protected static boolean acceptsKmzFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "kmz");
    }

    protected static boolean acceptsKmzShpFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "kmz", "shp");
    }

    protected static boolean acceptsKmzTabFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "kmz", "tab");
    }

    protected static boolean acceptsZipFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "zip");
    }

    protected static boolean accepts7ZipFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "7z");
    }

    protected static boolean acceptsCsvKmzFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "csv", "kmz");
    }

    protected static boolean acceptsCsvKmzTabFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "csv", "kmz", "tab");
    }

    protected static boolean acceptsCsvXlsFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "csv", "xls");
    }

    protected static boolean acceptsGpkgFilename(String filename, String ... expected) {
        return AbstractDataSetHandler.acceptsFilename(filename, expected, "gpkg");
    }

    public License getLicense() {
        return this.license;
    }

    public final void setLicense(License license) {
        this.license = license;
    }

    public URL getDataURL() {
        return this.dataURL;
    }

    public final void setDataURL(URL dataURL) {
        this.dataURL = dataURL;
    }

    public final void setDataURL(String dataURL) throws MalformedURLException {
        this.setDataURL(new URL(dataURL));
    }

    public URL getWikiURL() {
        return this.wikiURL;
    }

    public final void setWikiURL(URL wikiURL) {
        this.wikiURL = wikiURL;
    }

    public final void setWikiURL(String wikiURL) throws MalformedURLException {
        this.setWikiURL(new URL(wikiURL));
    }

    public URL getLocalPortalURL() {
        return this.localPortalURL;
    }

    public final void setLocalPortalURL(URL localPortalURL) {
        this.localPortalURL = localPortalURL;
    }

    public final void setLocalPortalURL(String localPortalURL) throws MalformedURLException {
        this.setLocalPortalURL(new URL(localPortalURL));
    }

    public URL getNationalPortalURL() {
        return this.nationalPortalURL;
    }

    public final void setNationalPortalURL(URL nationalPortalURL) {
        this.nationalPortalURL = nationalPortalURL;
    }

    public final void setNationalPortalURL(String nationalPortalURL) throws MalformedURLException {
        this.setNationalPortalURL(new URL(nationalPortalURL));
    }

    public List<Pair<String, URL>> getDataURLs() {
        return Collections.emptyList();
    }

    public AbstractReader getReaderForUrl(String url) {
        return null;
    }

    public final boolean hasLicenseToBeAccepted() {
        return this.hasLicenseToBeAccepted;
    }

    public final void setHasLicenseToBeAccepted(boolean hasLicenseToBeAccepted) {
        this.hasLicenseToBeAccepted = hasLicenseToBeAccepted;
    }

    public final DataSetCategory getCategory() {
        return this.category;
    }

    public final void setCategory(DataSetCategory category) {
        this.category = category;
    }

    public final Collection<String> getOsmXapiRequests(Bounds bounds) {
        return this.getOsmXapiRequests(LatLon.roundToOsmPrecision((double)bounds.getMin().lon()) + "," + LatLon.roundToOsmPrecision((double)bounds.getMin().lat()) + "," + LatLon.roundToOsmPrecision((double)bounds.getMax().lon()) + "," + LatLon.roundToOsmPrecision((double)bounds.getMax().lat()));
    }

    protected Collection<String> getOsmXapiRequests(String bbox) {
        return null;
    }

    public final String getOverpassApiRequest(Bounds bounds) {
        return this.getOverpassApiRequest("w=\"" + LatLon.roundToOsmPrecision((double)bounds.getMin().lon()) + "\" s=\"" + LatLon.roundToOsmPrecision((double)bounds.getMin().lat()) + "\" e=\"" + LatLon.roundToOsmPrecision((double)bounds.getMax().lon()) + "\" n=\"" + LatLon.roundToOsmPrecision((double)bounds.getMax().lat()) + "\"");
    }

    protected String getOverpassApiRequest(String bbox) {
        return null;
    }

    public boolean equals(IPrimitive p1, IPrimitive p2) {
        return false;
    }

    public boolean isRelevant(IPrimitive p) {
        return false;
    }

    public final Collection<IPrimitive> extractRelevantPrimitives(DataSet ds) {
        ArrayList<IPrimitive> result = new ArrayList<IPrimitive>();
        for (IPrimitive p : ds.allPrimitives()) {
            if (!this.isRelevant(p)) continue;
            result.add(p);
        }
        return result;
    }

    public boolean isForbidden(IPrimitive p) {
        return false;
    }

    public boolean hasForbiddenTags() {
        return false;
    }

    protected static void replace(IPrimitive p, String dataKey, String osmKey) {
        AbstractDataSetHandler.addOrReplace(p, dataKey, osmKey, null, null, null, true);
    }

    protected static void replace(IPrimitive p, String dataKey, String osmKey, ValueReplacer replacer) {
        AbstractDataSetHandler.addOrReplace(p, dataKey, osmKey, null, null, replacer, true);
    }

    protected static void replace(IPrimitive p, String dataKey, String osmKey, String[] dataValues, String[] osmValues) {
        AbstractDataSetHandler.addOrReplace(p, dataKey, osmKey, dataValues, osmValues, null, true);
    }

    protected static void add(IPrimitive p, String dataKey, String osmKey, ValueReplacer replacer) {
        AbstractDataSetHandler.addOrReplace(p, dataKey, osmKey, null, null, replacer, false);
    }

    protected static void add(IPrimitive p, String dataKey, String osmKey, String[] dataValues, String[] osmValues) {
        AbstractDataSetHandler.addOrReplace(p, dataKey, osmKey, dataValues, osmValues, null, false);
    }

    private static void addOrReplace(IPrimitive p, String dataKey, String osmKey, String[] dataValues, String[] osmValues, ValueReplacer replacer, boolean replace) {
        String value = p.get(dataKey);
        if (value != null) {
            int index = -1;
            for (int i = 0; dataValues != null && index == -1 && i < dataValues.length; ++i) {
                if (!Pattern.compile(dataValues[i], 2).matcher(value).matches()) continue;
                index = i;
            }
            if (index > -1 && osmValues != null) {
                AbstractDataSetHandler.doAddReplace(p, dataKey, osmKey, osmValues[index], replace);
            } else if (replacer != null) {
                AbstractDataSetHandler.doAddReplace(p, dataKey, osmKey, replacer.replace(value), replace);
            } else if (dataValues == null || osmValues == null) {
                AbstractDataSetHandler.doAddReplace(p, dataKey, osmKey, value, replace);
            }
        }
    }

    private static void doAddReplace(IPrimitive p, String dataKey, String osmKey, String osmValue, boolean replace) {
        if (replace) {
            p.remove(dataKey);
        }
        p.put(osmKey, osmValue);
    }

    public String getSource() {
        return null;
    }

    public final String getSourceDate() {
        return this.sourceDate;
    }

    public final void setSourceDate(String sourceDate) {
        this.sourceDate = sourceDate;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String getLocalPortalIconName() {
        return "o24.png";
    }

    public String getNationalPortalIconName() {
        return "o24.png";
    }

    public String getDataLayerIconName() {
        return "o16.png";
    }

    public ExtendedSourceEntry getMapPaintStyle() {
        return null;
    }

    public ExtendedSourceEntry getTaggingPreset() {
        return null;
    }

    protected final ExtendedSourceEntry getMapPaintStyle(String displayName) {
        return this.getMapPaintStyle(displayName, this.getClass().getSimpleName().replace("Handler", ""));
    }

    protected final ExtendedSourceEntry getMapPaintStyle(String displayName, String fileNameWithoutExtension) {
        return new ExtendedSourceEntry(SourceType.MAP_PAINT_STYLE, displayName, "resource://" + this.getClass().getPackage().getName().replace(".", "/") + "/" + fileNameWithoutExtension + "." + "mapcss");
    }

    public final ImageIcon getMenuIcon() {
        return this.menuIcon;
    }

    public final void setMenuIcon(ImageIcon icon) {
        this.menuIcon = icon;
    }

    public final void setMenuIcon(String iconName) {
        this.setMenuIcon(OdUtils.getImageIcon(iconName));
    }

    public final void setAssociatedFile(File associatedFile) {
        this.associatedFile = associatedFile;
    }

    public final File getAssociatedFile() {
        return this.associatedFile;
    }

    public boolean acceptsUrl(String url) {
        URL currentDataUrl = this.getDataURL();
        if (currentDataUrl != null && url.equals(currentDataUrl.toString())) {
            return true;
        }
        List<Pair<String, URL>> dataURLs = this.getDataURLs();
        if (dataURLs != null) {
            for (Pair<String, URL> pair : dataURLs) {
                if (pair.b == null || !url.equals(((URL)pair.b).toString())) continue;
                return true;
            }
        }
        return false;
    }

    public final void setShpHandler(ShpHandler handler) {
        this.shpHandler = handler;
    }

    public final ShpHandler getShpHandler() {
        return this.shpHandler;
    }

    public final void setMifHandler(MifHandler handler) {
        this.mifHandler = handler;
    }

    public final MifHandler getMifHandler() {
        return this.mifHandler;
    }

    public final void setGmlHandler(GmlHandler handler) {
        this.gmlHandler = handler;
    }

    public final GmlHandler getGmlHandler() {
        return this.gmlHandler;
    }

    public final void setGeoPackageHandler(GeoPackageHandler handler) {
        this.geoPackageHandler = handler;
    }

    public final GeoPackageHandler getGeoPackageHandler() {
        return this.geoPackageHandler;
    }

    public final void setArchiveHandler(ArchiveHandler handler) {
        this.archiveHandler = handler;
    }

    public ArchiveHandler getArchiveHandler() {
        return this.archiveHandler;
    }

    public final void setSpreadSheetHandler(SpreadSheetHandler handler) {
        this.ssHandler = handler;
    }

    public final SpreadSheetHandler getSpreadSheetHandler() {
        return this.ssHandler;
    }

    public final void setCsvHandler(CsvHandler handler) {
        this.setSpreadSheetHandler(handler);
    }

    public final CsvHandler getCsvHandler() {
        if (this.ssHandler instanceof CsvHandler) {
            return (CsvHandler)this.ssHandler;
        }
        return null;
    }

    public final Collection<JosmAction> getTools() {
        return this.tools;
    }

    public final boolean addTool(JosmAction tool) {
        return tool != null && this.tools.add(tool);
    }

    public final boolean removeTool(JosmAction tool) {
        return tool != null && this.tools.remove(tool);
    }

    public void notifyActive() {
    }

    public static interface ValueReplacer {
        public String replace(String var1);
    }
}

