/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.math.BigInteger;
import org.apache.poi.ss.util.NormalisedDecimal;

final class MutableFPNumber {
    private static final BigInteger BI_MIN_BASE = new BigInteger("0B5E620F47FFFE666", 16);
    private static final BigInteger BI_MAX_BASE = new BigInteger("0E35FA9319FFFE000", 16);
    private static final int C_64 = 64;
    private static final int MIN_PRECISION = 72;
    private BigInteger _significand;
    private int _binaryExponent;

    public MutableFPNumber(BigInteger bigInteger, int n) {
        this._significand = bigInteger;
        this._binaryExponent = n;
    }

    public void normalise64bit() {
        int n = this._significand.bitLength();
        int n2 = n - 64;
        if (n2 == 0) {
            return;
        }
        if (n2 < 0) {
            throw new IllegalStateException("Not enough precision");
        }
        this._binaryExponent += n2;
        if (n2 > 32) {
            int n3 = n2 - 1 & 0xFFFFE0;
            this._significand = this._significand.shiftRight(n3);
            n2 -= n3;
            n -= n3;
        }
        if (n2 < 1) {
            throw new IllegalStateException();
        }
        this._significand = Rounder.round(this._significand, n2);
        if (this._significand.bitLength() > n) {
            ++n2;
            ++this._binaryExponent;
        }
        this._significand = this._significand.shiftRight(n2);
    }

    public int get64BitNormalisedExponent() {
        return this._binaryExponent + this._significand.bitLength() - 64;
    }

    public boolean isBelowMaxRep() {
        int n = this._significand.bitLength() - 64;
        return this._significand.compareTo(BI_MAX_BASE.shiftLeft(n)) < 0;
    }

    public boolean isAboveMinRep() {
        int n = this._significand.bitLength() - 64;
        return this._significand.compareTo(BI_MIN_BASE.shiftLeft(n)) > 0;
    }

    public NormalisedDecimal createNormalisedDecimal(int n) {
        int n2 = this._binaryExponent - 39;
        int n3 = this._significand.intValue() << n2 & 0xFFFF80;
        long l = this._significand.shiftRight(64 - this._binaryExponent - 1).longValue();
        return new NormalisedDecimal(l, n3, n);
    }

    public void multiplyByPowerOfTen(int n) {
        TenPower tenPower = TenPower.getInstance(Math.abs(n));
        if (n < 0) {
            this.mulShift(tenPower._divisor, tenPower._divisorShift);
        } else {
            this.mulShift(tenPower._multiplicand, tenPower._multiplierShift);
        }
    }

    private void mulShift(BigInteger bigInteger, int n) {
        this._significand = this._significand.multiply(bigInteger);
        this._binaryExponent += n;
        int n2 = this._significand.bitLength() - 72 & 0xFFFFFFE0;
        if (n2 > 0) {
            this._significand = this._significand.shiftRight(n2);
            this._binaryExponent += n2;
        }
    }

    private static final class Rounder {
        private static final BigInteger[] HALF_BITS;

        private Rounder() {
        }

        public static BigInteger round(BigInteger bigInteger, int n) {
            if (n < 1) {
                return bigInteger;
            }
            return bigInteger.add(HALF_BITS[n]);
        }

        static {
            BigInteger[] bigIntegerArray = new BigInteger[33];
            long l = 1L;
            for (int i = 1; i < bigIntegerArray.length; ++i) {
                bigIntegerArray[i] = BigInteger.valueOf(l);
                l <<= 1;
            }
            HALF_BITS = bigIntegerArray;
        }
    }

    private static final class TenPower {
        private static final BigInteger FIVE = new BigInteger("5");
        private static final TenPower[] _cache = new TenPower[350];
        public final BigInteger _multiplicand;
        public final BigInteger _divisor;
        public final int _divisorShift;
        public final int _multiplierShift;

        private TenPower(int n) {
            BigInteger bigInteger = FIVE.pow(n);
            int n2 = bigInteger.bitLength();
            int n3 = 80 + n2;
            BigInteger bigInteger2 = BigInteger.ONE.shiftLeft(n3).divide(bigInteger);
            int n4 = bigInteger2.bitLength() - 80;
            this._divisor = bigInteger2.shiftRight(n4);
            this._divisorShift = -((n2 -= n4) + n + 80);
            int n5 = bigInteger.bitLength() - 68;
            if (n5 > 0) {
                this._multiplierShift = n + n5;
                this._multiplicand = bigInteger.shiftRight(n5);
            } else {
                this._multiplierShift = n;
                this._multiplicand = bigInteger;
            }
        }

        static TenPower getInstance(int n) {
            TenPower tenPower = _cache[n];
            if (tenPower == null) {
                TenPower._cache[n] = tenPower = new TenPower(n);
            }
            return tenPower;
        }
    }
}

