/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.utils;

import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class PluginState {
    private static final Logger LOGGER = Logger.getLogger(PluginState.class.getCanonicalName());
    private static boolean submittingChangeset;
    private static int runningDownloads;
    private static int imagesToUpload;
    private static int imagesUploaded;

    private PluginState() {
    }

    public static void startDownload() {
        ++runningDownloads;
    }

    public static void finishDownload() {
        if (runningDownloads == 0) {
            LOGGER.log(Logging.LEVEL_WARN, I18n.tr((String)"The amount of running downloads is equal to 0", (Object[])new Object[0]));
            return;
        }
        --runningDownloads;
    }

    public static boolean isDownloading() {
        return runningDownloads > 0;
    }

    public static boolean isSubmittingChangeset() {
        return submittingChangeset;
    }

    public static void setSubmittingChangeset(boolean isSubmitting) {
        submittingChangeset = isSubmitting;
    }

    public static boolean isUploading() {
        return imagesToUpload > imagesUploaded;
    }

    public static void addImagesToUpload(int amount) {
        if (imagesToUpload <= imagesUploaded) {
            imagesToUpload = 0;
            imagesUploaded = 0;
        }
        imagesToUpload += amount;
    }

    public static int getImagesToUpload() {
        return imagesToUpload;
    }

    public static int getImagesUploaded() {
        return imagesUploaded;
    }

    public static void imageUploaded() {
        if (imagesToUpload == ++imagesUploaded) {
            PluginState.finishedUploadDialog(imagesUploaded);
        }
    }

    private static void finishedUploadDialog(int numImages) {
        JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"You have successfully uploaded {0} images to Bing.com", (Object[])new Object[]{numImages}), I18n.tr((String)"Finished upload", (Object[])new Object[0]), 1);
    }

    public static void notLoggedInToMapillaryDialog() {
        JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"You are not logged in, please log in to Streetside in the preferences", (Object[])new Object[0]), I18n.tr((String)"Not Logged in to Streetside", (Object[])new Object[0]), 2);
    }

    public static String getUploadString() {
        return I18n.tr((String)"Uploading: {0}", (Object[])new Object[]{"(" + imagesUploaded + "/" + imagesToUpload + ")"});
    }
}

