/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.model;

import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.streetside.cache.Caches;
import org.openstreetmap.josm.plugins.streetside.model.KeyIndexedObject;
import org.openstreetmap.josm.tools.ImageProvider;

public class MapObject
extends KeyIndexedObject {
    private static final ImageIcon ICON_UNKNOWN_TYPE = ImageProvider.get((String)"unknown-mapobject-type");
    private final LatLon coordinate;
    private final String objPackage;
    private final String value;
    private final long firstSeenTime;
    private final long lastSeenTime;
    private final long updatedTime;

    public MapObject(LatLon coordinate, String key, String objPackage, String value, long firstSeenTime, long lastSeenTime, long updatedTime) {
        super(key);
        if (objPackage == null || value == null || coordinate == null) {
            throw new IllegalArgumentException("The fields of a MapObject must not be null!");
        }
        this.coordinate = coordinate;
        this.objPackage = objPackage;
        this.value = value;
        this.firstSeenTime = firstSeenTime;
        this.lastSeenTime = lastSeenTime;
        this.updatedTime = updatedTime;
    }

    public static ImageIcon getIcon(String objectTypeID) {
        ImageIcon cachedIcon = Caches.MapObjectIconCache.getInstance().get(objectTypeID);
        if ("not-in-set".equals(objectTypeID)) {
            return ICON_UNKNOWN_TYPE;
        }
        if (cachedIcon == null) {
            // empty if block
        }
        return cachedIcon;
    }

    public LatLon getCoordinate() {
        return this.coordinate;
    }

    public String getPackage() {
        return this.objPackage;
    }

    public long getFirstSeenTime() {
        return this.firstSeenTime;
    }

    public long getLastSeenTime() {
        return this.lastSeenTime;
    }

    public long getUpdatedTime() {
        return this.updatedTime;
    }

    public String getValue() {
        return this.value;
    }
}

