/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.io.export;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.tools.Logging;

public class StreetsideExportWriterThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(StreetsideExportWriterThread.class.getCanonicalName());
    private final String path;
    private final ArrayBlockingQueue<BufferedImage> queue;
    private final ArrayBlockingQueue<StreetsideAbstractImage> queueImages;
    private final int amount;
    private final ProgressMonitor monitor;

    public StreetsideExportWriterThread(String path, ArrayBlockingQueue<BufferedImage> queue, ArrayBlockingQueue<StreetsideAbstractImage> queueImages, int amount, ProgressMonitor monitor) {
        this.path = path;
        this.queue = queue;
        this.queueImages = queueImages;
        this.amount = amount;
        this.monitor = monitor;
    }

    @Override
    public void run() {
        this.monitor.setCustomText("Downloaded 0/" + this.amount);
        String finalPath = "";
        for (int i = 0; i < this.amount; ++i) {
            try {
                BufferedImage img = this.queue.take();
                StreetsideAbstractImage mimg = this.queueImages.take();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)img, "jpg", outputStream);
                byte[] imageBytes = outputStream.toByteArray();
                TiffOutputSet outputSet = null;
                if (null == outputSet) {
                    outputSet = new TiffOutputSet();
                }
                TiffOutputDirectory exifDirectory = outputSet.getOrCreateExifDirectory();
                TiffOutputDirectory gpsDirectory = outputSet.getOrCreateGPSDirectory();
                gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION_REF);
                gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION_REF, new String[]{"T"});
                gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION);
                gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION, RationalNumber.valueOf((double)mimg.getMovingHe()));
                exifDirectory.removeField((TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
                outputSet.setGPSInDegrees(mimg.getMovingLatLon().lon(), mimg.getMovingLatLon().lat());
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(finalPath + ".jpg"));
                new ExifRewriter().updateExifMetadataLossless(imageBytes, (OutputStream)os, outputSet);
                ((OutputStream)os).close();
            }
            catch (InterruptedException e) {
                LOGGER.info("Streetside export cancelled");
                return;
            }
            catch (IOException | ImageReadException | ImageWriteException e) {
                LOGGER.log(Logging.LEVEL_ERROR, e.getMessage(), e);
            }
            this.monitor.worked(10000 / this.amount);
            this.monitor.setCustomText("Downloaded " + (i + 1) + "/" + this.amount);
        }
    }
}

