/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.io.download;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideData;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideSequence;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.io.download.BoundsDownloadRunnable;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideSequenceIdGenerator;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import org.openstreetmap.josm.tools.Logging;

public final class SequenceDownloadRunnable
extends BoundsDownloadRunnable {
    private static final Logger LOG = Logger.getLogger(BoundsDownloadRunnable.class.getCanonicalName());
    private static final Function<Bounds, URL> URL_GEN = StreetsideURL.APIv3::searchStreetsideImages;
    private final StreetsideData data;

    public SequenceDownloadRunnable(StreetsideData data, Bounds bounds) {
        super(bounds);
        this.data = data;
    }

    @Override
    public void run(URLConnection con) throws IOException {
        if (Thread.interrupted()) {
            return;
        }
        StreetsideSequence seq = new StreetsideSequence(StreetsideSequenceIdGenerator.generateId());
        ArrayList<StreetsideImage> bubbleImages = new ArrayList<StreetsideImage>();
        long startTime = System.currentTimeMillis();
        try (JsonParser parser = Json.createParser((InputStream)con.getInputStream());){
            if (!parser.hasNext() || parser.next() != JsonParser.Event.START_ARRAY) {
                throw new IllegalStateException("Expected an array");
            }
            StreetsideImage previous = null;
            while (parser.hasNext() && parser.next() == JsonParser.Event.START_OBJECT) {
                JsonObject node = parser.getObject();
                if (node.get((Object)"id") != null && node.get((Object)"la") != null && node.get((Object)"lo") != null) {
                    StreetsideImage image = new StreetsideImage(CubemapUtils.convertDecimal2Quaternary(node.getJsonNumber("id").longValue()), new LatLon(node.getJsonNumber("la").doubleValue(), node.getJsonNumber("lo").doubleValue()), node.getJsonNumber("he").doubleValue());
                    if (previous != null) {
                        image.setPr(Long.parseLong(previous.getId()));
                        previous.setNe(Long.parseLong(image.getId()));
                    }
                    previous = image;
                    if (node.containsKey((Object)"ad")) {
                        image.setAd(node.getJsonNumber("ad").intValue());
                    }
                    if (node.containsKey((Object)"al")) {
                        image.setAl(node.getJsonNumber("al").doubleValue());
                    }
                    if (node.containsKey((Object)"bl")) {
                        image.setBl(node.getString("bl"));
                    }
                    if (node.containsKey((Object)"ml")) {
                        image.setMl(node.getJsonNumber("ml").intValue());
                    }
                    if (node.containsKey((Object)"ne")) {
                        image.setNe(node.getJsonNumber("ne").longValue());
                    }
                    if (node.containsKey((Object)"pi")) {
                        image.setPi(node.getJsonNumber("pi").doubleValue());
                    }
                    if (node.containsKey((Object)"pr")) {
                        image.setPr(node.getJsonNumber("pr").longValue());
                    }
                    if (node.containsKey((Object)"ro")) {
                        image.setRo(node.getJsonNumber("ro").doubleValue());
                    }
                    if (node.containsKey((Object)"nbn")) {
                        image.setNbn(node.getJsonArray("nbn").getValuesAs(JsonValue::toString));
                    }
                    if (node.containsKey((Object)"pbn")) {
                        image.setPbn(node.getJsonArray("pbn").getValuesAs(JsonValue::toString));
                    }
                    ArrayList tiles = new ArrayList();
                    EnumSet.allOf(CubemapUtils.CubemapFaces.class).forEach(face -> {
                        for (int i = 0; i < 4; ++i) {
                            if (Boolean.FALSE.equals(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get())) {
                                StreetsideImage tile = new StreetsideImage(image.getId() + i);
                                tiles.add(tile);
                            }
                            if (!Boolean.TRUE.equals(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get())) continue;
                            for (int j = 0; j < 4; ++j) {
                                StreetsideImage tile = new StreetsideImage(image.getId() + face.getValue() + CubemapUtils.rowCol2StreetsideCellAddressMap.get(i + Integer.toString(j)));
                                tiles.add(tile);
                            }
                        }
                    });
                    bubbleImages.add(image);
                    LOG.info("Added image with id <" + image.getId() + ">");
                    if (!Boolean.TRUE.equals(StreetsideProperties.PREDOWNLOAD_CUBEMAPS.get())) continue;
                    StreetsideData.downloadSurroundingCubemaps(image);
                    continue;
                }
                LOG.info(MessageFormat.format("Unparsable JSON node object: {0}", node));
            }
        }
        catch (JsonException | ClassCastException e) {
            LOG.log(Logging.LEVEL_ERROR, e, () -> SequenceDownloadRunnable.lambda$run$1((RuntimeException)e));
        }
        catch (IOException e) {
            LOG.log(Logging.LEVEL_ERROR, e, () -> MessageFormat.format("Input/output error occurred during Streetside sequence download {0}", e.getMessage()));
        }
        seq.add(bubbleImages);
        if (Boolean.TRUE.equals(StreetsideProperties.CUT_OFF_SEQUENCES_AT_BOUNDS.get())) {
            for (StreetsideAbstractImage img : seq.getImages()) {
                if (this.bounds.contains(img.getLatLon())) {
                    this.data.add(img);
                    continue;
                }
                seq.remove(img);
            }
        } else {
            boolean sequenceCrossesThroughBounds = false;
            for (int i = 0; i < seq.getImages().size() && !sequenceCrossesThroughBounds; ++i) {
                sequenceCrossesThroughBounds = this.bounds.contains(seq.getImages().get(i).getLatLon());
            }
            if (sequenceCrossesThroughBounds) {
                this.data.addAll(seq.getImages(), true);
            }
        }
        long endTime = System.currentTimeMillis();
        LOG.info(MessageFormat.format("Successfully loaded {0} Microsoft Streetside images in {1} seconds.", seq.getImages().size(), (endTime - startTime) / 1000L));
    }

    @Override
    protected Function<Bounds, URL> getUrlGenerator() {
        return URL_GEN;
    }

    private static /* synthetic */ String lambda$run$1(RuntimeException e) {
        return MessageFormat.format("JSON parsing error occurred during Streetside sequence download {0}", e.getMessage());
    }
}

