/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.gui.boilerplate.StreetsideButton;
import org.openstreetmap.josm.plugins.streetside.io.download.StreetsideDownloader;
import org.openstreetmap.josm.plugins.streetside.oauth.OAuthPortListener;
import org.openstreetmap.josm.plugins.streetside.oauth.StreetsideLoginListener;
import org.openstreetmap.josm.plugins.streetside.oauth.StreetsideUser;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideColorScheme;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class StreetsidePreferenceSetting
implements SubPreferenceSetting,
StreetsideLoginListener {
    private static final Logger logger = Logger.getLogger(StreetsidePreferenceSetting.class.getCanonicalName());
    private final JComboBox<String> downloadModeComboBox = new JComboBox<String>(new String[]{StreetsideDownloader.DOWNLOAD_MODE.VISIBLE_AREA.getLabel(), StreetsideDownloader.DOWNLOAD_MODE.OSM_AREA.getLabel(), StreetsideDownloader.DOWNLOAD_MODE.MANUAL_ONLY.getLabel()});
    private final JCheckBox displayHour = new JCheckBox(I18n.tr((String)"Display hour when the picture was taken", (Object[])new Object[0]), (boolean)StreetsideProperties.DISPLAY_HOUR.get());
    private final JCheckBox format24 = new JCheckBox(I18n.tr((String)"Use 24 hour format", (Object[])new Object[0]), (boolean)StreetsideProperties.TIME_FORMAT_24.get());
    private final JCheckBox moveTo = new JCheckBox(I18n.tr((String)"Move to picture''s location with next/previous buttons", (Object[])new Object[0]), (boolean)StreetsideProperties.MOVE_TO_IMG.get());
    private final JCheckBox hoverEnabled = new JCheckBox(I18n.tr((String)"Preview images when hovering its icon", (Object[])new Object[0]), (boolean)StreetsideProperties.HOVER_ENABLED.get());
    private final JCheckBox cutOffSeq = new JCheckBox(I18n.tr((String)"Cut off sequences at download bounds", (Object[])new Object[0]), (boolean)StreetsideProperties.CUT_OFF_SEQUENCES_AT_BOUNDS.get());
    private final JCheckBox imageLinkToBlurEditor = new JCheckBox(I18n.tr((String)"When opening Streetside image in web browser, show the blur editor instead of the image viewer", (Object[])new Object[0]), (boolean)StreetsideProperties.IMAGE_LINK_TO_BLUR_EDITOR.get());
    private final JCheckBox developer = new JCheckBox(I18n.tr((String)"Enable experimental beta-features (might be unstable)", (Object[])new Object[0]), (boolean)StreetsideProperties.DEVELOPER.get());
    private final SpinnerNumberModel preFetchSize = new SpinnerNumberModel(StreetsideProperties.PRE_FETCH_IMAGE_COUNT.get(), 0, Integer.MAX_VALUE, 1);
    private final JButton loginButton = new StreetsideButton(new LoginAction(this));
    private final JButton logoutButton = new StreetsideButton(new LogoutAction());
    private final JLabel loginLabel = new JLabel();
    private final JPanel loginPanel = new JPanel();

    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getDisplayPreference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGui(PreferenceTabbedPane gui) {
        JPanel container = new JPanel(new BorderLayout());
        this.loginPanel.setLayout(new BoxLayout(this.loginPanel, 2));
        this.loginPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.loginPanel.setBackground(StreetsideColorScheme.TOOLBAR_DARK_GREY);
        JLabel brandImage = new JLabel();
        try (InputStream is = StreetsidePreferenceSetting.class.getResourceAsStream("/images/streetside-logo-white.png");){
            if (is != null) {
                brandImage.setIcon(new ImageIcon(ImageIO.read(is)));
            } else {
                logger.log(Logging.LEVEL_WARN, "Could not load Streetside brand image!");
            }
        }
        catch (IOException e) {
            logger.log(Logging.LEVEL_WARN, "While reading Streetside brand image, an IO-exception occured!", e);
        }
        this.loginPanel.add((Component)brandImage, 0);
        this.loginPanel.add(Box.createHorizontalGlue(), 1);
        this.loginLabel.setForeground(Color.WHITE);
        this.loginLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.loginPanel.add((Component)this.loginLabel, 2);
        this.loginPanel.add((Component)this.loginButton, 3);
        this.onLogout();
        container.add((Component)this.loginPanel, "North");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.downloadModeComboBox.setSelectedItem(StreetsideDownloader.DOWNLOAD_MODE.fromPrefId(StreetsideProperties.DOWNLOAD_MODE.get()).getLabel());
        JPanel downloadModePanel = new JPanel();
        downloadModePanel.add(new JLabel(I18n.tr((String)"Download mode", (Object[])new Object[0])));
        downloadModePanel.add(this.downloadModeComboBox);
        mainPanel.add((Component)downloadModePanel, GBC.eol());
        mainPanel.add((Component)this.displayHour, GBC.eol());
        mainPanel.add((Component)this.format24, GBC.eol());
        mainPanel.add((Component)this.moveTo, GBC.eol());
        mainPanel.add((Component)this.hoverEnabled, GBC.eol());
        mainPanel.add((Component)this.cutOffSeq, GBC.eol());
        mainPanel.add((Component)this.imageLinkToBlurEditor, GBC.eol());
        JPanel preFetchPanel = new JPanel();
        preFetchPanel.add(new JLabel(I18n.tr((String)"Number of images to be pre-fetched (forwards and backwards)", (Object[])new Object[0])));
        JSpinner spinner = new JSpinner(this.preFetchSize);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner);
        editor.getTextField().setColumns(3);
        spinner.setEditor(editor);
        preFetchPanel.add(spinner);
        mainPanel.add((Component)preFetchPanel, GBC.eol());
        if (ExpertToggleAction.isExpert() || this.developer.isSelected()) {
            mainPanel.add((Component)this.developer, GBC.eol());
        }
        StreetsideColorScheme.styleAsDefaultPanel(mainPanel, downloadModePanel, this.displayHour, this.format24, this.moveTo, this.hoverEnabled, this.cutOffSeq, this.imageLinkToBlurEditor, this.developer, preFetchPanel);
        mainPanel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
        container.add((Component)mainPanel, "Center");
        JTabbedPane jTabbedPane = gui.getDisplayPreference().getTabPane();
        synchronized (jTabbedPane) {
            gui.getDisplayPreference().addSubTab((SubPreferenceSetting)this, "Streetside", (Component)new JScrollPane(container));
            gui.getDisplayPreference().getTabPane().setIconAt(gui.getDisplayPreference().getTabPane().getTabCount() - 1, StreetsidePlugin.LOGO.setSize(12, 12).get());
        }
        new Thread(() -> {
            String username = StreetsideUser.getUsername();
            if (username != null) {
                SwingUtilities.invokeLater(() -> this.onLogin(StreetsideUser.getUsername()));
            }
        }).start();
    }

    @Override
    public void onLogin(String username) {
        this.loginPanel.remove(this.loginButton);
        this.loginPanel.add((Component)this.logoutButton, 3);
        this.loginLabel.setText(I18n.tr((String)"You are logged in as ''{0}''.", (Object[])new Object[]{username}));
        this.loginPanel.revalidate();
        this.loginPanel.repaint();
    }

    @Override
    public void onLogout() {
        this.loginPanel.remove(this.logoutButton);
        this.loginPanel.add((Component)this.loginButton, 3);
        this.loginLabel.setText(I18n.tr((String)"You are currently not logged in.", (Object[])new Object[0]));
        this.loginPanel.revalidate();
        this.loginPanel.repaint();
    }

    public boolean ok() {
        StreetsideProperties.DOWNLOAD_MODE.put(StreetsideDownloader.DOWNLOAD_MODE.fromLabel(this.downloadModeComboBox.getSelectedItem().toString()).getPrefId());
        StreetsideProperties.DISPLAY_HOUR.put(Boolean.valueOf(this.displayHour.isSelected()));
        StreetsideProperties.TIME_FORMAT_24.put(Boolean.valueOf(this.format24.isSelected()));
        StreetsideProperties.MOVE_TO_IMG.put(Boolean.valueOf(this.moveTo.isSelected()));
        StreetsideProperties.HOVER_ENABLED.put(Boolean.valueOf(this.hoverEnabled.isSelected()));
        StreetsideProperties.CUT_OFF_SEQUENCES_AT_BOUNDS.put(Boolean.valueOf(this.cutOffSeq.isSelected()));
        StreetsideProperties.IMAGE_LINK_TO_BLUR_EDITOR.put(Boolean.valueOf(this.imageLinkToBlurEditor.isSelected()));
        StreetsideProperties.DEVELOPER.put(Boolean.valueOf(this.developer.isSelected()));
        StreetsideProperties.PRE_FETCH_IMAGE_COUNT.put(Integer.valueOf(this.preFetchSize.getNumber().intValue()));
        return false;
    }

    public boolean isExpert() {
        return false;
    }

    private static class LoginAction
    extends AbstractAction {
        private static final long serialVersionUID = 8743119160917296506L;
        private final transient StreetsideLoginListener callback;

        LoginAction(StreetsideLoginListener loginCallback) {
            super(I18n.tr((String)"Login", (Object[])new Object[0]));
            this.callback = loginCallback;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            OAuthPortListener portListener = new OAuthPortListener(this.callback);
            portListener.start();
        }
    }

    private class LogoutAction
    extends AbstractAction {
        private static final long serialVersionUID = -4146587895393766981L;

        private LogoutAction() {
            super(I18n.tr((String)"Logout", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            StreetsideUser.reset();
            StreetsidePreferenceSetting.this.onLogout();
        }
    }
}

