/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideCubemap;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBox;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.cubemap.ITileDownloadingTaskListener;
import org.openstreetmap.josm.plugins.streetside.cubemap.TileDownloadingTask;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideViewerDialog;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.StreetsideViewerPanel;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.ThreeSixtyDegreeViewerPanel;
import org.openstreetmap.josm.plugins.streetside.utils.GraphicsUtils;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.Logging;

public class CubemapBuilder
implements ITileDownloadingTaskListener,
StreetsideDataListener {
    private static final Logger LOGGER = Logger.getLogger(CubemapBuilder.class.getCanonicalName());
    private static CubemapBuilder instance;
    protected boolean isBuilding;
    private StreetsideCubemap cubemap;
    private long startTime;
    private Map<String, BufferedImage> tileImages = new ConcurrentHashMap<String, BufferedImage>();
    private ExecutorService pool;
    private int currentTileCount = 0;

    private CubemapBuilder() {
    }

    public static CubemapBuilder getInstance() {
        if (instance == null) {
            instance = new CubemapBuilder();
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static synchronized void destroyInstance() {
        instance = null;
    }

    public Map<String, BufferedImage> getTileImages() {
        return this.tileImages;
    }

    public void setTileImages(Map<String, BufferedImage> tileImages) {
        this.tileImages = tileImages;
    }

    @Override
    public void imagesAdded() {
    }

    @Override
    public void selectedImageChanged(StreetsideAbstractImage oldImage, StreetsideAbstractImage newImage) {
        this.startTime = System.currentTimeMillis();
        if (newImage != null) {
            this.cubemap = null;
            this.cubemap = new StreetsideCubemap(newImage.getId(), newImage.getLatLon(), newImage.getHe());
            this.currentTileCount = 0;
            this.resetTileImages();
            this.downloadCubemapImages(this.cubemap.getId());
            long runTime = (System.currentTimeMillis() - this.startTime) / 1000L;
            if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
                LOGGER.log(Logging.LEVEL_DEBUG, MessageFormat.format("Completed downloading tiles for {0} in {1} seconds.", newImage.getId(), runTime));
            }
        }
    }

    public void reload(String imageId) {
        if (this.cubemap != null && imageId.equals(this.cubemap.getId())) {
            this.tileImages = new HashMap<String, BufferedImage>();
            this.downloadCubemapImages(imageId);
        }
    }

    public void downloadCubemapImages(String imageId) {
        ThreeSixtyDegreeViewerPanel panel360 = StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel();
        if (panel360 != null && panel360.getScene() != panel360.getLoadingScene()) {
            panel360.setScene(panel360.getLoadingScene());
        }
        int maxThreadCount = Boolean.TRUE.equals(StreetsideProperties.DOWNLOAD_CUBEFACE_TILES_TOGETHER.get()) ? 6 : 6 * CubemapUtils.getMaxCols() * CubemapUtils.getMaxRows();
        int fails = 0;
        String[] message = new String[]{MessageFormat.format("Downloading Streetside imagery for {0}", imageId), "Wait for completion\u2026\u2026."};
        long startTime = System.currentTimeMillis();
        if (!CubemapBuilder.getInstance().getTileImages().keySet().isEmpty()) {
            this.pool.shutdownNow();
            CubemapBuilder.getInstance().resetTileImages();
        }
        try {
            this.pool = Executors.newFixedThreadPool(maxThreadCount);
            ArrayList<TileDownloadingTask> tasks = new ArrayList<TileDownloadingTask>(maxThreadCount);
            if (Boolean.TRUE.equals(StreetsideProperties.DOWNLOAD_CUBEFACE_TILES_TOGETHER.get())) {
                EnumSet.allOf(CubemapUtils.CubemapFaces.class).forEach(face -> {
                    String tileId = imageId + face.getValue();
                    tasks.add(new TileDownloadingTask(tileId));
                });
            } else if (Boolean.FALSE.equals(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get())) {
                for (int i = 0; i < 6; ++i) {
                    int tileNr = 0;
                    for (int j = 0; j < CubemapUtils.getMaxCols(); ++j) {
                        for (int k = 0; k < CubemapUtils.getMaxRows(); ++k) {
                            String tileId = imageId + CubemapUtils.getFaceNumberForCount(i) + tileNr++;
                            tasks.add(new TileDownloadingTask(tileId));
                        }
                    }
                }
            } else if (Boolean.TRUE.equals(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get())) {
                for (int i = 0; i < 6; ++i) {
                    for (int j = 0; j < CubemapUtils.getMaxCols(); ++j) {
                        for (int k = 0; k < CubemapUtils.getMaxRows(); ++k) {
                            String tileId = imageId + CubemapUtils.getFaceNumberForCount(i) + j + k;
                            tasks.add(new TileDownloadingTask(tileId));
                        }
                    }
                }
            }
            MainApplication.worker.submit(() -> {
                try {
                    List results = this.pool.invokeAll(tasks);
                    if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get()) && results != null) {
                        for (Future ff : results) {
                            try {
                                LOGGER.log(Logging.LEVEL_DEBUG, MessageFormat.format("Completed tile downloading task {0} in {1} seconds.", ((List)ff.get()).toString(), (System.currentTimeMillis() - startTime) / 1000L));
                            }
                            catch (ExecutionException e) {
                                LOGGER.log(Logging.LEVEL_ERROR, e.getMessage(), e);
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.log(Logging.LEVEL_ERROR, e.getMessage(), e);
                }
            });
        }
        catch (Exception ee) {
            ++fails;
            LOGGER.log(Logging.LEVEL_ERROR, ee, () -> "Error loading tile for image " + imageId);
        }
        long stopTime = System.currentTimeMillis();
        long runTime = stopTime - startTime;
        if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
            LOGGER.log(Logging.LEVEL_DEBUG, MessageFormat.format("Tile imagery downloading tasks completed in {0} seconds.", runTime / 1000L));
        }
        if (fails > 0) {
            LOGGER.log(Logging.LEVEL_ERROR, fails + " downloading tasks failed!");
        }
    }

    @Override
    public void tileAdded(String tileId) {
        if (!tileId.startsWith(this.cubemap.getId())) {
            return;
        }
        ++this.currentTileCount;
        if (this.currentTileCount == 6 * CubemapUtils.getMaxCols() * CubemapUtils.getMaxRows()) {
            if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
                long endTime = System.currentTimeMillis();
                long runTime = (endTime - this.startTime) / 1000L;
                LOGGER.log(Logging.LEVEL_DEBUG, MessageFormat.format("{0} tile images ready for building cumbemap faces for cubemap {1} in {2} seconds.", this.currentTileCount, CubemapBuilder.getInstance().getCubemap().getId(), Long.toString(runTime)));
            }
            this.buildCubemapFaces();
        }
    }

    private void buildCubemapFaces() {
        int i;
        StreetsideViewerDialog.getInstance();
        CubemapBox cmb = StreetsideViewerPanel.getCubemapBox();
        ImageView[] views = cmb.getViews();
        Image[] finalImages = new Image[6];
        if (Boolean.FALSE.equals(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get())) {
            for (i = 0; i < 6; ++i) {
                BufferedImage[] faceTileImages = new BufferedImage[CubemapUtils.getMaxCols() * CubemapUtils.getMaxRows()];
                for (int j = 0; j < CubemapUtils.getMaxCols() * CubemapUtils.getMaxRows(); ++j) {
                    BufferedImage currentTile;
                    String tileId = this.getCubemap().getId() + CubemapUtils.getFaceNumberForCount(i) + j;
                    faceTileImages[j] = currentTile = this.tileImages.get(tileId);
                }
                BufferedImage finalImg = GraphicsUtils.buildMultiTiledCubemapFaceImage(faceTileImages);
                if (i == 4) {
                    finalImg = GraphicsUtils.rotateImage(finalImg);
                }
                finalImages[i] = GraphicsUtils.convertBufferedImage2JavaFXImage(finalImg);
            }
        } else if (Boolean.TRUE.equals(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get())) {
            for (i = 0; i < 6; ++i) {
                int tileCount = 0;
                BufferedImage[] faceTileImages = new BufferedImage[Boolean.TRUE.equals(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get()) ? 16 : 4];
                for (int j = 0; j < CubemapUtils.getMaxCols(); ++j) {
                    for (int k = 0; k < CubemapUtils.getMaxRows(); ++k) {
                        String tileId = this.getCubemap().getId() + CubemapUtils.getFaceNumberForCount(i) + CubemapUtils.convertDoubleCountNrto16TileNr(j + Integer.toString(k));
                        BufferedImage currentTile = this.tileImages.get(tileId);
                        faceTileImages[tileCount++] = currentTile;
                    }
                }
                BufferedImage finalImg = GraphicsUtils.buildMultiTiledCubemapFaceImage(faceTileImages);
                if (i == 4) {
                    finalImg = GraphicsUtils.rotateImage(finalImg);
                }
                finalImages[i] = GraphicsUtils.convertBufferedImage2JavaFXImage(finalImg);
            }
        }
        for (i = 0; i < 6; ++i) {
            views[i].setImage(finalImages[i]);
        }
        StreetsideViewerDialog.getInstance().getStreetsideViewerPanel().revalidate();
        StreetsideViewerDialog.getInstance().getStreetsideViewerPanel().repaint();
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().setScene(StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().getCubemapScene());
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().revalidate();
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().repaint();
        long endTime = System.currentTimeMillis();
        long runTime = (endTime - this.startTime) / 1000L;
        String message = MessageFormat.format("Completed downloading, assembling and setting cubemap imagery for cubemap {0} in  {1} seconds.", this.cubemap.getId(), runTime);
        if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
            LOGGER.log(Logging.LEVEL_DEBUG, message);
        }
        this.resetTileImages();
        this.currentTileCount = 0;
        this.isBuilding = false;
    }

    private void resetTileImages() {
        this.tileImages = new HashMap<String, BufferedImage>();
    }

    public synchronized StreetsideCubemap getCubemap() {
        return this.cubemap;
    }

    public static void setCubemap(StreetsideCubemap cubemap) {
        CubemapBuilder.getInstance().cubemap = cubemap;
    }

    public boolean isBuilding() {
        return this.isBuilding;
    }
}

