/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cache;

import java.io.IOException;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.cache.StreetsideCache;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBuilder;
import org.openstreetmap.josm.tools.Logging;

public final class CacheUtils {
    private static final Logger LOGGER = Logger.getLogger(CacheUtils.class.getCanonicalName());
    private static final IgnoreDownload ignoreDownload = new IgnoreDownload();

    private CacheUtils() {
    }

    public static void downloadPicture(StreetsideImage img) {
        CacheUtils.downloadPicture(img, PICTURE.BOTH);
    }

    public static void downloadCubemap(StreetsideImage cm) {
        CacheUtils.downloadPicture(cm, PICTURE.CUBEMAP);
    }

    public static void downloadPicture(StreetsideImage img, PICTURE pic) {
        switch (pic) {
            case BOTH: {
                if (new StreetsideCache(img.getId(), StreetsideCache.Type.THUMBNAIL).get() == null) {
                    CacheUtils.submit(img.getId(), StreetsideCache.Type.THUMBNAIL, ignoreDownload);
                }
                if (new StreetsideCache(img.getId(), StreetsideCache.Type.FULL_IMAGE).get() != null) break;
                CacheUtils.submit(img.getId(), StreetsideCache.Type.FULL_IMAGE, ignoreDownload);
                break;
            }
            case THUMBNAIL: {
                CacheUtils.submit(img.getId(), StreetsideCache.Type.THUMBNAIL, ignoreDownload);
                break;
            }
            case FULL_IMAGE: {
                break;
            }
            case CUBEMAP: {
                if (img.getId() == null) {
                    LOGGER.log(Logging.LEVEL_ERROR, "Download cancelled. Image id is null.");
                    break;
                }
                CubemapBuilder.getInstance().downloadCubemapImages(img.getId());
                break;
            }
            default: {
                CacheUtils.submit(img.getId(), StreetsideCache.Type.FULL_IMAGE, ignoreDownload);
            }
        }
    }

    public static void submit(String key, StreetsideCache.Type type, ICachedLoaderListener lis) {
        try {
            new StreetsideCache(key, type).submit(lis, false);
        }
        catch (IOException e) {
            LOGGER.log(Logging.LEVEL_ERROR, e.getMessage(), e);
        }
    }

    public static enum PICTURE {
        THUMBNAIL,
        FULL_IMAGE,
        BOTH,
        CUBEMAP;

    }

    private static class IgnoreDownload
    implements ICachedLoaderListener {
        private IgnoreDownload() {
        }

        public void loadingFinished(CacheEntry arg0, CacheEntryAttributes arg1, ICachedLoaderListener.LoadResult arg2) {
        }
    }
}

