/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class StreetsideZoomAction
extends JosmAction
implements StreetsideDataListener {
    private static final long serialVersionUID = -5885977359895624233L;

    public StreetsideZoomAction() {
        super(I18n.tr((String)"Zoom to selected image", (Object[])new Object[0]), new ImageProvider(StreetsidePlugin.LOGO).setSize(ImageProvider.ImageSizes.DEFAULT), I18n.tr((String)"Zoom to the currently selected Streetside image", (Object[])new Object[0]), null, false, "mapillaryZoom", true);
    }

    public void actionPerformed(ActionEvent arg0) {
        if (StreetsideLayer.getInstance().getData().getSelectedImage() == null) {
            throw new IllegalStateException();
        }
        MainApplication.getMap().mapView.zoomTo(StreetsideLayer.getInstance().getData().getSelectedImage().getMovingLatLon());
    }

    @Override
    public void imagesAdded() {
    }

    protected boolean listenToSelectionChange() {
        return false;
    }

    @Override
    public void selectedImageChanged(StreetsideAbstractImage oldImage, StreetsideAbstractImage newImage) {
        if (oldImage == null && newImage != null) {
            this.setEnabled(true);
        } else if (oldImage != null && newImage == null) {
            this.setEnabled(false);
        }
    }

    protected void updateEnabledState() {
        super.updateEnabledState();
        this.setEnabled(StreetsideLayer.hasInstance() && StreetsideLayer.getInstance().getData().getSelectedImage() != null);
    }
}

