/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageryxmlbounds.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IRelationMember;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsConstants;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class ComputeBoundsAction
extends AbstractAction
implements XmlBoundsConstants {
    protected static final DecimalFormat DF = new DecimalFormat("#0.#####", new DecimalFormatSymbols(Locale.UK));
    protected static final String ACTION_NAME = I18n.tr((String)"XML Imagery Bounds", (Object[])new Object[0]);
    protected static final String EIGHT_SP = "        ";
    private final Set<IRelation<?>> multipolygons = new HashSet();
    private final Set<IWay<?>> closedWays = new HashSet();

    public ComputeBoundsAction() {
        this((OsmDataLayer)null);
    }

    public ComputeBoundsAction(OsmDataLayer layer) {
        this.putValue("ShortDescription", I18n.tr((String)"Generate Imagery XML bounds for the selection", (Object[])new Object[0]));
        this.putValue("Name", ACTION_NAME);
        new ImageProvider("imagery_xml_bounds_icon").getResource().attachImageIcon((AbstractAction)this, true);
        this.setEnabled(false);
        if (layer != null) {
            ArrayList primitives = new ArrayList();
            primitives.addAll(layer.data.getRelations());
            primitives.addAll(layer.data.getWays());
            this.updateOsmPrimitives(primitives);
        }
    }

    protected void updateOsmPrimitives(Collection<? extends IPrimitive> primitives) {
        this.multipolygons.clear();
        this.closedWays.clear();
        for (IPrimitive iPrimitive : primitives) {
            IWay w;
            if (iPrimitive instanceof IRelation) {
                IRelation r = (IRelation)iPrimitive;
                if (!r.isMultipolygon()) continue;
                this.multipolygons.add(r);
                continue;
            }
            if (!(iPrimitive instanceof IWay) || !(w = (IWay)iPrimitive).isClosed()) continue;
            this.closedWays.add(w);
        }
        Iterator<IWay<?>> it = this.closedWays.iterator();
        while (it.hasNext()) {
            this.processIterator(it);
        }
        this.setEnabled(!this.multipolygons.isEmpty() || !this.closedWays.isEmpty());
    }

    private void processIterator(Iterator<IWay<?>> it) {
        IWay<?> way = it.next();
        for (IRelation<?> mp : this.multipolygons) {
            for (IRelationMember mb : mp.getMembers()) {
                if (!mb.getMember().equals(way)) continue;
                it.remove();
                return;
            }
        }
    }

    public final String getXml() {
        ArrayList<Object> primitives = new ArrayList<Object>();
        primitives.addAll(this.multipolygons);
        primitives.addAll(this.closedWays);
        return ComputeBoundsAction.getXml(primitives.toArray(new OsmPrimitive[primitives.size()]));
    }

    protected static final String startTag(String tag) {
        return "<" + tag + ">";
    }

    protected static final String startMandatoryTag(String tag) {
        return "<" + tag + " mandatory='true'>";
    }

    protected static final String endTag(String tag) {
        return "</" + tag + ">";
    }

    protected static final String simpleTag(String tag, String content) {
        return ComputeBoundsAction.simpleTag(tag, content, "");
    }

    protected static final String simpleTag(String tag, String content, boolean escape) {
        return ComputeBoundsAction.simpleTag(tag, content, "", escape);
    }

    protected static final String simpleTag(String tag, String content, String def) {
        return ComputeBoundsAction.simpleTag(tag, content, def, true);
    }

    protected static final String simpleTag(String tag, String content, String def, boolean escape) {
        return ComputeBoundsAction.startTag(tag) + (content != null ? (escape ? ComputeBoundsAction.escapeReservedCharacters(content) : content) : def) + ComputeBoundsAction.endTag(tag);
    }

    protected static final String mandatoryTag(String tag, String content) {
        return ComputeBoundsAction.mandatoryTag(tag, content, true);
    }

    protected static final String mandatoryTag(String tag, String content, boolean escape) {
        return ComputeBoundsAction.startMandatoryTag(tag) + (escape ? ComputeBoundsAction.escapeReservedCharacters(content) : content) + ComputeBoundsAction.endTag(tag);
    }

    public static String escapeReservedCharacters(String s) {
        return s == null ? "" : s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    protected static final String getXml(OsmPrimitive ... primitives) {
        ArrayList<String> entries = new ArrayList<String>();
        for (OsmPrimitive p : primitives) {
            if (p instanceof Relation) {
                entries.add(ComputeBoundsAction.getEntry(p, ComputeBoundsAction.getMultiPolygonBounds((Relation)p)));
                continue;
            }
            if (!(p instanceof Way)) continue;
            entries.add(ComputeBoundsAction.getEntry(p, ComputeBoundsAction.getClosedWayBounds((Way)p)));
        }
        return ComputeBoundsAction.getImagery(entries.toArray(new String[entries.size()]));
    }

    protected static final String getImagery(String ... entries) {
        String version = "UNKNOWN";
        try {
            InputStream revision = ComputeBoundsAction.class.getResourceAsStream("/REVISION");
            if (revision != null) {
                Properties p = new Properties();
                p.load(revision);
                version = p.getProperty("Revision");
            }
        }
        catch (IOException e) {
            Logging.warn((Throwable)e);
        }
        StringBuilder result = new StringBuilder(256);
        result.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n").append("<!-- Generated with JOSM Imagery XML Plugin version ").append(version).append(" -->\n").append("<imagery xmlns=\"").append("http://josm.openstreetmap.de/maps-1.0").append("\">\n");
        for (String entry : entries) {
            result.append(entry).append('\n');
        }
        result.append("</imagery>");
        return result.toString();
    }

    protected static final String getEntry(OsmPrimitive p, String bounds) {
        return ComputeBoundsAction.getEntry(p.get("name"), p.get("imagery:type"), p.get("imagery:default"), p.get("imagery:url"), bounds, p.get("imagery:projections"), p.get("imagery:logo-url"), p.get("imagery:eula"), p.get("imagery:attribution-text"), p.get("imagery:attribution-url"), p.get("imagery:terms-of-use-text"), p.get("imagery:terms-of-use-url"), p.get("imagery:country-code"), p.get("imagery:max-zoom"), p.get("imagery:min-zoom"), p.get("imagery:id"), p.get("imagery:date"));
    }

    protected static final boolean isSet(String tag) {
        return tag != null && !tag.isEmpty();
    }

    protected static final String getEntry(String name, String type, String def, String url, String bounds, String projections, String logoURL, String eula, String attributionText, String attributionUrl, String termsText, String termsUrl, String countryCode, String maxZoom, String minZoom, String id, String date) {
        StringBuilder result = new StringBuilder(128);
        result.append("    <entry>\n        " + ComputeBoundsAction.simpleTag("name", name) + '\n' + EIGHT_SP + ComputeBoundsAction.simpleTag("type", type, "wms") + '\n' + EIGHT_SP + ComputeBoundsAction.simpleTag("url", url != null ? ComputeBoundsAction.encodeUrl(url) : "", false) + '\n' + bounds + '\n');
        if (projections != null && !projections.isEmpty()) {
            String[] codes;
            result.append(EIGHT_SP + ComputeBoundsAction.startTag("projections") + '\n');
            int i = 0;
            for (String code : codes = projections.split(";")) {
                if (i % 6 == 0) {
                    result.append("            ");
                }
                result.append(ComputeBoundsAction.simpleTag("code", code.trim()));
                if (i % 6 == 5 || i == codes.length - 1) {
                    result.append('\n');
                }
                ++i;
            }
            result.append(EIGHT_SP + ComputeBoundsAction.endTag("projections") + '\n');
        }
        if (ComputeBoundsAction.isSet(def) && "true".equals(def)) {
            result.append(EIGHT_SP + ComputeBoundsAction.simpleTag("default", def) + '\n');
        }
        if (ComputeBoundsAction.isSet(id)) {
            result.append(EIGHT_SP + ComputeBoundsAction.simpleTag("id", id, false) + '\n');
        }
        if (ComputeBoundsAction.isSet(date)) {
            result.append(EIGHT_SP + ComputeBoundsAction.simpleTag("date", date, false) + '\n');
        }
        if (ComputeBoundsAction.isSet(eula)) {
            result.append(EIGHT_SP + ComputeBoundsAction.mandatoryTag("eula", ComputeBoundsAction.encodeUrl(eula), false) + '\n');
        }
        if (ComputeBoundsAction.isSet(attributionText)) {
            result.append(EIGHT_SP + ComputeBoundsAction.mandatoryTag("attribution-text", attributionText) + '\n');
        }
        if (ComputeBoundsAction.isSet(attributionUrl)) {
            result.append(EIGHT_SP + ComputeBoundsAction.simpleTag("attribution-url", ComputeBoundsAction.encodeUrl(attributionUrl), false) + '\n');
        }
        if (ComputeBoundsAction.isSet(termsText)) {
            result.append(EIGHT_SP + ComputeBoundsAction.simpleTag("terms-of-use-text", termsText) + '\n');
        }
        if (ComputeBoundsAction.isSet(termsUrl)) {
            result.append(EIGHT_SP + ComputeBoundsAction.simpleTag("terms-of-use-url", ComputeBoundsAction.encodeUrl(termsUrl), false) + '\n');
        }
        if (ComputeBoundsAction.isSet(logoURL)) {
            result.append(EIGHT_SP + ComputeBoundsAction.simpleTag("logo-url", ComputeBoundsAction.encodeUrl(logoURL), false) + '\n');
        }
        if (ComputeBoundsAction.isSet(countryCode)) {
            result.append(EIGHT_SP + ComputeBoundsAction.simpleTag("country-code", countryCode) + '\n');
        }
        if ("tms".equals(type)) {
            if (ComputeBoundsAction.isSet(maxZoom)) {
                result.append(EIGHT_SP + ComputeBoundsAction.simpleTag("max-zoom", maxZoom) + '\n');
            }
            if (ComputeBoundsAction.isSet(minZoom)) {
                result.append(EIGHT_SP + ComputeBoundsAction.simpleTag("min-zoom", minZoom) + '\n');
            }
        }
        result.append("    </entry>");
        return result.toString();
    }

    protected static final String encodeUrl(String url) {
        return "<![CDATA[" + url + "]]>";
    }

    protected static final String getBounds(OsmPrimitive p, boolean closeTag) {
        BBox bbox = p.getBBox();
        String result = "        <bounds ";
        result = result + "min-lat='" + DF.format(bbox.getBottomRight().lat()) + "' ";
        result = result + "min-lon='" + DF.format(bbox.getTopLeft().lon()) + "' ";
        result = result + "max-lat='" + DF.format(bbox.getTopLeft().lat()) + "' ";
        result = result + "max-lon='" + DF.format(bbox.getBottomRight().lon()) + "'";
        result = result + (closeTag ? " />" : ">\n");
        return result;
    }

    protected static final boolean isValidOuterMember(RelationMember mb) {
        return (mb.getRole() == null || mb.getRole().isEmpty() || "outer".equals(mb.getRole())) && mb.getMember() instanceof Way;
    }

    protected static final boolean isValidOuterClosedMember(RelationMember mb) {
        return ComputeBoundsAction.isValidOuterMember(mb) && ((Way)mb.getMember()).isClosed();
    }

    protected static final String getMultiPolygonBounds(Relation mp) {
        List polygons = new Multipolygon(mp).getOuterPolygons();
        if (polygons.isEmpty() || polygons.size() == 1 && ComputeBoundsAction.areJoinedWayAndBboxEqual((Multipolygon.JoinedWay)polygons.get(0), mp.getBBox())) {
            return ComputeBoundsAction.getBounds((OsmPrimitive)mp, true);
        }
        StringBuilder result = new StringBuilder(ComputeBoundsAction.getBounds((OsmPrimitive)mp, false));
        for (Multipolygon.PolyData way : polygons) {
            result.append(ComputeBoundsAction.getJoinedWayShape((Multipolygon.JoinedWay)way));
        }
        result.append("        </bounds>");
        return result.toString();
    }

    protected static final boolean areClosedWayAndBboxEqual(Way way, BBox bBox) {
        return ComputeBoundsAction.areNodeListAndBboxEqual(way.getNodes(), bBox);
    }

    protected static final boolean areJoinedWayAndBboxEqual(Multipolygon.JoinedWay way, BBox bBox) {
        return ComputeBoundsAction.areNodeListAndBboxEqual(way.getNodes(), bBox);
    }

    protected static boolean areNodeListAndBboxEqual(List<Node> nodes, BBox bBox) {
        if (nodes.size() == 5) {
            HashMap<Double, List> latMap = new HashMap<Double, List>();
            HashMap<Double, List> lonMap = new HashMap<Double, List>();
            for (int i = 0; i < 4; ++i) {
                ILatLon b;
                ILatLon c = (ILatLon)nodes.get(i);
                if (i > 1 && (b = (ILatLon)nodes.get(i - 1)).lat() != c.lat() && b.lon() != c.lon()) {
                    return false;
                }
                List latList = latMap.computeIfAbsent(c.lat(), lat -> new ArrayList(1));
                latList.add(i);
                List lonList = lonMap.computeIfAbsent(c.lon(), lon -> new ArrayList(1));
                lonList.add(i);
            }
            return latMap.size() == 2 && lonMap.size() == 2 && latMap.containsKey(bBox.getBottomRight().lat()) && latMap.containsKey(bBox.getTopLeft().lat()) && lonMap.containsKey(bBox.getBottomRight().lon()) && lonMap.containsKey(bBox.getTopLeft().lon());
        }
        return false;
    }

    protected static final String getClosedWayBounds(Way cw) {
        if (ComputeBoundsAction.areClosedWayAndBboxEqual(cw, cw.getBBox())) {
            return ComputeBoundsAction.getBounds((OsmPrimitive)cw, true);
        }
        return ComputeBoundsAction.getBounds((OsmPrimitive)cw, false) + ComputeBoundsAction.getClosedWayShape(cw) + "        </bounds>";
    }

    protected static final String getClosedWayShape(Way cw) {
        return ComputeBoundsAction.getNodeListShape(cw.getNodes());
    }

    protected static final String getJoinedWayShape(Multipolygon.JoinedWay jw) {
        return ComputeBoundsAction.getNodeListShape(jw.getNodes());
    }

    protected static String getNodeListShape(List<Node> nodes) {
        StringBuilder result = new StringBuilder("            <shape>\n");
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            int j;
            if (i % 3 == 0) {
                result.append("                ");
            }
            if ((j = i) == size) {
                j = 0;
            }
            ILatLon ll = (ILatLon)nodes.get(i);
            result.append("<point lat='").append(DF.format(ll.lat())).append("' lon='").append(DF.format(ll.lon())).append("'/>");
            if (i % 3 != 2 && i != size - 1) continue;
            result.append('\n');
        }
        result.append("            </shape>\n");
        return result.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (Logging.isDebugEnabled()) {
            Logging.debug((String)this.getXml());
        }
    }

    static {
        DF.setRoundingMode(RoundingMode.CEILING);
    }
}

