/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.utils;

import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class ImageUtil {
    private static final Logger LOGGER = Logger.getLogger(ImageUtil.class.getCanonicalName());

    private ImageUtil() {
    }

    public static ImageIcon scaleImageIcon(ImageIcon icon, int size) {
        if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
            LOGGER.log(Logging.LEVEL_DEBUG, I18n.tr((String)"Scale icon {0} \u2192 {1}", (Object[])new Object[]{icon.getIconWidth(), size}));
        }
        return new ImageIcon(icon.getImage().getScaledInstance(icon.getIconWidth() >= icon.getIconHeight() ? size : Math.max(1, Math.round((float)icon.getIconWidth() / (float)icon.getIconHeight() * (float)size)), icon.getIconHeight() >= icon.getIconWidth() ? size : Math.max(1, Math.round((float)icon.getIconHeight() / (float)icon.getIconWidth() * (float)size)), 4));
    }
}

