/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.mode;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideData;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideMainDialog;
import org.openstreetmap.josm.plugins.streetside.history.StreetsideRecord;
import org.openstreetmap.josm.plugins.streetside.history.commands.CommandMove;
import org.openstreetmap.josm.plugins.streetside.history.commands.CommandTurn;
import org.openstreetmap.josm.plugins.streetside.mode.AbstractMode;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;

public class SelectMode
extends AbstractMode {
    private final StreetsideRecord record = StreetsideRecord.getInstance();
    private StreetsideAbstractImage closest;
    private StreetsideAbstractImage lastClicked;
    private boolean nothingHighlighted;
    private boolean imageHighlighted;

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        StreetsideAbstractImage closest = this.getClosest(e.getPoint());
        if (!(MainApplication.getLayerManager().getActiveLayer() instanceof StreetsideLayer) && closest != null && MainApplication.getMap().mapMode == MainApplication.getMap().mapModeSelect) {
            this.lastClicked = this.closest;
            StreetsideLayer.getInstance().getData().setSelectedImage(closest);
            return;
        }
        if (MainApplication.getLayerManager().getActiveLayer() != StreetsideLayer.getInstance()) {
            return;
        }
        if (e.getClickCount() == 2 && StreetsideLayer.getInstance().getData().getSelectedImage() != null && closest != null) {
            closest.getSequence().getImages().forEach(StreetsideLayer.getInstance().getData()::addMultiSelectedImage);
        }
        this.lastClicked = this.closest;
        this.closest = closest;
        if (closest != null && StreetsideLayer.getInstance().getData().getMultiSelectedImages().contains(closest)) {
            return;
        }
        if (e.getModifiers() == 18 && closest != null) {
            StreetsideLayer.getInstance().getData().addMultiSelectedImage(closest);
        } else if (e.getModifiers() == 17 && this.lastClicked instanceof StreetsideImage) {
            if (this.closest != null && this.closest.getSequence() == this.lastClicked.getSequence()) {
                int i = this.closest.getSequence().getImages().indexOf(this.closest);
                int j = this.lastClicked.getSequence().getImages().indexOf(this.lastClicked);
                StreetsideLayer.getInstance().getData().addMultiSelectedImage(i < j ? new ConcurrentSkipListSet<StreetsideAbstractImage>(this.closest.getSequence().getImages().subList(i, j + 1)) : new ConcurrentSkipListSet<StreetsideAbstractImage>(this.closest.getSequence().getImages().subList(j, i + 1)));
            }
        } else {
            StreetsideLayer.getInstance().getData().setSelectedImage(closest);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        StreetsideAbstractImage highlightImg = StreetsideLayer.getInstance().getData().getHighlightedImage();
        if (MainApplication.getLayerManager().getActiveLayer() == StreetsideLayer.getInstance() && SwingUtilities.isLeftMouseButton(e) && highlightImg != null && highlightImg.getLatLon() != null) {
            Point highlightImgPoint = MainApplication.getMap().mapView.getPoint(highlightImg.getTempLatLon());
            if (e.isShiftDown()) {
                StreetsideLayer.getInstance().getData().getMultiSelectedImages().parallelStream().filter(img -> !(img instanceof StreetsideImage) || StreetsideProperties.DEVELOPER.get() != false).forEach(img -> img.turn(Math.toDegrees(Math.atan2((double)e.getX() - highlightImgPoint.getX(), (double)(-e.getY()) + highlightImgPoint.getY())) - highlightImg.getTempHe()));
            } else {
                LatLon eventLatLon = MainApplication.getMap().mapView.getLatLon(e.getX(), e.getY());
                LatLon imgLatLon = MainApplication.getMap().mapView.getLatLon(highlightImgPoint.getX(), highlightImgPoint.getY());
                StreetsideLayer.getInstance().getData().getMultiSelectedImages().parallelStream().filter(img -> !(img instanceof StreetsideImage) || StreetsideProperties.DEVELOPER.get() != false).forEach(img -> img.move(eventLatLon.getX() - imgLatLon.getX(), eventLatLon.getY() - imgLatLon.getY()));
            }
            StreetsideLayer.invalidateInstance();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        StreetsideData data = StreetsideLayer.getInstance().getData();
        if (data.getSelectedImage() == null) {
            return;
        }
        if (!Objects.equals(data.getSelectedImage().getTempHe(), data.getSelectedImage().getMovingHe())) {
            double from = data.getSelectedImage().getTempHe();
            double to = data.getSelectedImage().getMovingHe();
            this.record.addCommand(new CommandTurn(data.getMultiSelectedImages(), to - from));
        } else if (!Objects.equals(data.getSelectedImage().getTempLatLon(), data.getSelectedImage().getMovingLatLon())) {
            LatLon from = data.getSelectedImage().getTempLatLon();
            LatLon to = data.getSelectedImage().getMovingLatLon();
            this.record.addCommand(new CommandMove(data.getMultiSelectedImages(), to.getX() - from.getX(), to.getY() - from.getY()));
        }
        data.getMultiSelectedImages().parallelStream().filter(Objects::nonNull).forEach(StreetsideAbstractImage::stopMoving);
        StreetsideLayer.invalidateInstance();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (MainApplication.getLayerManager().getActiveLayer() instanceof OsmDataLayer && MainApplication.getMap().mapMode != MainApplication.getMap().mapModeSelect) {
            return;
        }
        if (Boolean.FALSE.equals(StreetsideProperties.HOVER_ENABLED.get())) {
            return;
        }
        StreetsideAbstractImage closestTemp = this.getClosest(e.getPoint());
        OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
        if (editLayer != null) {
            if (closestTemp != null && !this.imageHighlighted) {
                if (MainApplication.getMap().mapMode != null) {
                    MainApplication.getMap().mapMode.putValue("active", (Object)Boolean.FALSE);
                }
                this.imageHighlighted = true;
            } else if (closestTemp == null && this.imageHighlighted && this.nothingHighlighted) {
                if (MainApplication.getMap().mapMode != null) {
                    MainApplication.getMap().mapMode.putValue("active", (Object)Boolean.TRUE);
                }
                this.nothingHighlighted = false;
            } else if (this.imageHighlighted && !this.nothingHighlighted && editLayer.data != null) {
                for (OsmPrimitive primivitive : MainApplication.getLayerManager().getEditLayer().data.allPrimitives()) {
                    primivitive.setHighlighted(false);
                }
                this.imageHighlighted = false;
                this.nothingHighlighted = true;
            }
        }
        if (StreetsideLayer.getInstance().getData().getHighlightedImage() != closestTemp && closestTemp != null) {
            StreetsideLayer.getInstance().getData().setHighlightedImage(closestTemp);
            StreetsideMainDialog.getInstance().setImage(closestTemp);
            StreetsideMainDialog.getInstance().updateImage(false);
        } else if (StreetsideLayer.getInstance().getData().getHighlightedImage() != closestTemp && closestTemp == null) {
            StreetsideLayer.getInstance().getData().setHighlightedImage(null);
            StreetsideMainDialog.getInstance().setImage(StreetsideLayer.getInstance().getData().getSelectedImage());
            StreetsideMainDialog.getInstance().updateImage();
        }
        StreetsideLayer.invalidateInstance();
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
    }

    public String toString() {
        return I18n.tr((String)"Select mode", (Object[])new Object[0]);
    }
}

