/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideUtils;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class WebLinkAction
extends AbstractAction {
    private static final long serialVersionUID = -8168227661356480455L;
    private static final Logger LOGGER = Logger.getLogger(WebLinkAction.class.getCanonicalName());
    private URL url;

    public WebLinkAction(String name, URL url) {
        super(name, ImageProvider.get((String)"link", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.SMALLICON));
        this.setURL(url);
    }

    public final void setURL(URL url) {
        this.url = url;
        this.setEnabled(url != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            StreetsideUtils.browse(this.url);
        }
        catch (IOException e1) {
            String msg = "Could not open the URL " + this.url == null ? "\u2039null\u203a" : this.url + " in a browser";
            LOGGER.log(Logging.LEVEL_WARN, msg, e1);
            new Notification(msg).setIcon(2).show();
        }
    }
}

