/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photoadjust;

import java.awt.event.MouseEvent;
import java.util.List;
import org.openstreetmap.josm.data.ImageData;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;

public class PhotoAdjustWorker {
    private ImageEntry dragPhoto;
    private ImageData dragData;
    private EastNorth dragOffset;
    private boolean centerViewIsDisabled;
    private boolean centerViewNeedsEnable;

    public void reset() {
        this.dragPhoto = null;
        this.dragData = null;
        this.dragOffset = EastNorth.ZERO;
    }

    public synchronized void disableCenterView() {
        if (!this.centerViewIsDisabled && ImageViewerDialog.isCenterView()) {
            this.centerViewIsDisabled = true;
            this.centerViewNeedsEnable = ImageViewerDialog.setCentreEnabled((boolean)false);
        }
    }

    public synchronized void restoreCenterView() {
        if (this.centerViewIsDisabled) {
            if (this.centerViewNeedsEnable) {
                this.centerViewNeedsEnable = false;
                ImageViewerDialog.setCentreEnabled((boolean)true);
            }
            this.centerViewIsDisabled = false;
        }
    }

    public void doMousePressed(MouseEvent evt, List<GeoImageLayer> imageLayers) {
        block10: {
            boolean isShift;
            this.reset();
            if (evt.getButton() != 1 || imageLayers == null || imageLayers.isEmpty()) break block10;
            boolean isAlt = (evt.getModifiersEx() & 0x200) == 512;
            boolean isCtrl = (evt.getModifiersEx() & 0x80) == 128;
            boolean bl = isShift = (evt.getModifiersEx() & 0x40) == 64;
            if (isShift) {
                return;
            }
            if (isAlt || isCtrl) {
                for (GeoImageLayer layer : imageLayers) {
                    List entries;
                    if (!layer.isVisible() || (entries = layer.getImageData().getSelectedImages()).isEmpty()) continue;
                    for (ImageEntry img : entries) {
                        if (isCtrl && !isAlt) {
                            if (img.getPos() != null) {
                                this.changeDirection(img, layer.getImageData(), evt);
                            }
                        } else if (isCtrl) {
                            PhotoAdjustWorker.movePhoto(img, layer.getImageData(), evt);
                        }
                        this.dragPhoto = img;
                    }
                    this.dragData = layer.getImageData();
                    break;
                }
            } else {
                for (GeoImageLayer layer : imageLayers) {
                    if (!layer.isVisible()) continue;
                    this.dragPhoto = layer.getPhotoUnderMouse(evt);
                    if (this.dragPhoto == null) continue;
                    this.dragData = layer.getImageData();
                    this.setDragOffset(this.dragPhoto, evt);
                    this.disableCenterView();
                    break;
                }
            }
        }
    }

    public void doMouseReleased(MouseEvent evt) {
        this.restoreCenterView();
    }

    public void doMouseDragged(MouseEvent evt) {
        if (this.dragData != null && this.dragPhoto != null) {
            if ((evt.getModifiersEx() & 0x80) == 128) {
                if (this.dragData.isImageSelected(this.dragPhoto)) {
                    for (ImageEntry photo : this.dragData.getSelectedImages()) {
                        this.changeDirection(photo, this.dragData, evt);
                    }
                } else {
                    this.changeDirection(this.dragPhoto, this.dragData, evt);
                }
            } else {
                this.disableCenterView();
                EastNorth startEN = this.dragPhoto.getPos().getEastNorth((Projecting)ProjectionRegistry.getProjection()).subtract(this.dragOffset);
                EastNorth currentEN = MainApplication.getMap().mapView.getEastNorth(evt.getX(), evt.getY());
                EastNorth translation = currentEN.subtract(startEN);
                if (this.dragData.isImageSelected(this.dragPhoto)) {
                    for (ImageEntry photo : this.dragData.getSelectedImages()) {
                        this.translatePhoto(photo, translation);
                    }
                } else {
                    this.translatePhoto(this.dragPhoto, translation);
                }
                this.dragData.notifyImageUpdate();
            }
        }
    }

    private void setDragOffset(ImageEntry photo, MouseEvent evt) {
        EastNorth centerEN = photo.getPos().getEastNorth((Projecting)ProjectionRegistry.getProjection());
        EastNorth offsetEN = MainApplication.getMap().mapView.getEastNorth(evt.getX(), evt.getY());
        this.dragOffset = centerEN.subtract(offsetEN);
    }

    private static void movePhoto(ImageEntry photo, ImageData data, MouseEvent evt) {
        LatLon newPos = MainApplication.getMap().mapView.getLatLon(evt.getX(), evt.getY());
        data.updateImagePosition(photo, newPos);
    }

    private void translatePhoto(ImageEntry photo, EastNorth translation) {
        EastNorth startEN = photo.getPos().getEastNorth((Projecting)ProjectionRegistry.getProjection());
        EastNorth newPosEN = startEN.add(translation);
        LatLon newPos = MainApplication.getMap().mapView.getProjection().eastNorth2latlon(newPosEN);
        this.dragData.updateImagePosition(photo, newPos);
    }

    private void changeDirection(ImageEntry photo, ImageData data, MouseEvent evt) {
        CachedLatLon photoLL = photo.getPos();
        if (photoLL == null) {
            return;
        }
        LatLon mouseLL = MainApplication.getMap().mapView.getLatLon(evt.getX(), evt.getY());
        double direction = photoLL.bearing((ILatLon)mouseLL) * 360.0 / 2.0 / Math.PI;
        if (direction < 0.0) {
            direction += 360.0;
        } else if (direction >= 360.0) {
            direction -= 360.0;
        }
        data.updateImageDirection(photo, direction);
        this.setDragOffset(photo, evt);
    }
}

