/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionType;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class TurnRestrictionBuilder {
    public static double phi(Way w) throws IllegalArgumentException {
        return TurnRestrictionBuilder.phi(w, false);
    }

    public static double phi(Way w, boolean doInvert) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)w, (String)"w");
        if (w.getNodesCount() < 2) {
            throw new IllegalArgumentException("can't compute phi for way with less than 2 nodes");
        }
        List nodes = w.getNodes();
        if (doInvert) {
            Collections.reverse(nodes);
        }
        Node n0 = (Node)nodes.get(0);
        Node n1 = (Node)nodes.get(1);
        double x = n1.lon() - n0.lon();
        double y = n1.lat() - n0.lat();
        return Math.atan2(y, x);
    }

    public static Node getUniqueCommonNode(Way w1, Way w2) throws IllegalArgumentException {
        HashSet w1Nodes = new HashSet(w1.getNodes());
        w1Nodes.retainAll(w2.getNodes());
        if (w1Nodes.size() != 1) {
            return null;
        }
        return (Node)w1Nodes.iterator().next();
    }

    public static boolean isStartNode(Way w, Node n) {
        if (w.getNodesCount() == 0) {
            return false;
        }
        return w.getNode(0).equals((Object)n);
    }

    public static boolean isEndNode(Way w, Node n) {
        if (w.getNodesCount() == 0) {
            return false;
        }
        return w.getNode(w.getNodesCount() - 1).equals((Object)n);
    }

    public static boolean isInnerNode(Way w, Node n) {
        if (!w.getNodes().contains(n)) {
            return false;
        }
        if (TurnRestrictionBuilder.isStartNode(w, n)) {
            return false;
        }
        return !TurnRestrictionBuilder.isEndNode(w, n);
    }

    public static double intersectionAngle(Way from, Way to) throws IllegalArgumentException {
        Node via = TurnRestrictionBuilder.getUniqueCommonNode(from, to);
        if (via == null) {
            throw new IllegalArgumentException("the two ways must share exactly one common node");
        }
        if (!TurnRestrictionBuilder.isStartNode(from, via) && !TurnRestrictionBuilder.isEndNode(from, via)) {
            throw new IllegalArgumentException("via node must be start or end node of from-way");
        }
        if (!TurnRestrictionBuilder.isStartNode(to, via) && !TurnRestrictionBuilder.isEndNode(to, via)) {
            throw new IllegalArgumentException("via node must be start or end node of to-way");
        }
        double phi1 = TurnRestrictionBuilder.phi(from, TurnRestrictionBuilder.isStartNode(from, via));
        double phi2 = TurnRestrictionBuilder.phi(to, TurnRestrictionBuilder.isEndNode(to, via));
        return phi1 - phi2;
    }

    public static RelativeWayJoinOrientation determineWayJoinOrientation(Way from, Way to) {
        Node via = TurnRestrictionBuilder.getUniqueCommonNode(from, to);
        if (via == null) {
            return null;
        }
        if (!TurnRestrictionBuilder.isConnectingNode(from, to, via)) {
            return null;
        }
        if (TurnRestrictionBuilder.isClosedAt(from, via)) {
            return null;
        }
        if (TurnRestrictionBuilder.isClosedAt(to, via)) {
            return null;
        }
        double phi = TurnRestrictionBuilder.intersectionAngle(from, to);
        if (phi >= 0.0 && phi <= Math.PI) {
            return RelativeWayJoinOrientation.RIGHT;
        }
        return RelativeWayJoinOrientation.LEFT;
    }

    public static Way selectToWayAfterSplit(Way from, Way to1, Way to2, TurnRestrictionType restrictionType) {
        if (restrictionType == null) {
            return null;
        }
        Node cn1 = TurnRestrictionBuilder.getUniqueCommonNode(from, to1);
        if (cn1 == null) {
            return null;
        }
        Node cn2 = TurnRestrictionBuilder.getUniqueCommonNode(from, to2);
        if (cn2 == null) {
            return null;
        }
        if (cn1 != cn2) {
            return null;
        }
        if (!TurnRestrictionBuilder.isStartNode(from, cn1) && !TurnRestrictionBuilder.isEndNode(from, cn1)) {
            return null;
        }
        RelativeWayJoinOrientation o1 = TurnRestrictionBuilder.determineWayJoinOrientation(from, to1);
        RelativeWayJoinOrientation o2 = TurnRestrictionBuilder.determineWayJoinOrientation(from, to2);
        switch (restrictionType) {
            case NO_LEFT_TURN: 
            case ONLY_LEFT_TURN: {
                if (RelativeWayJoinOrientation.LEFT.equals((Object)o1)) {
                    return to1;
                }
                if (RelativeWayJoinOrientation.LEFT.equals((Object)o2)) {
                    return to2;
                }
                return null;
            }
            case NO_RIGHT_TURN: 
            case ONLY_RIGHT_TURN: {
                if (RelativeWayJoinOrientation.RIGHT.equals((Object)o1)) {
                    return to1;
                }
                if (RelativeWayJoinOrientation.RIGHT.equals((Object)o2)) {
                    return to2;
                }
                return null;
            }
        }
        return null;
    }

    public synchronized Relation buildFromSelection(OsmDataLayer layer) {
        CheckParameterUtil.ensureParameterNotNull((Object)layer, (String)"layer");
        ArrayList<OsmPrimitive> selection = new ArrayList<OsmPrimitive>(layer.data.getSelected());
        return this.build(selection);
    }

    protected Relation initNoUTurnRestriction(List<OsmPrimitive> primitives) {
        if (primitives.size() != 2) {
            return null;
        }
        ArrayList nodes = new ArrayList(Utils.filteredCollection(primitives, Node.class));
        ArrayList ways = new ArrayList(Utils.filteredCollection(primitives, Way.class));
        if (nodes.size() != 1 || ways.size() != 1) {
            return null;
        }
        Way way = (Way)ways.get(0);
        Node node = (Node)nodes.get(0);
        List wayNodes = way.getNodes();
        if (wayNodes.size() < 2) {
            return null;
        }
        if (!((Node)wayNodes.get(0)).equals((Object)node) && !((Node)wayNodes.get(wayNodes.size() - 1)).equals((Object)node)) {
            return null;
        }
        Relation tr = new Relation();
        tr.put("type", "restriction");
        tr.addMember(new RelationMember("from", (OsmPrimitive)way));
        tr.addMember(new RelationMember("to", (OsmPrimitive)way));
        tr.addMember(new RelationMember("via", (OsmPrimitive)node));
        tr.put("restriction", TurnRestrictionType.NO_U_TURN.getTagValue());
        return tr;
    }

    public static boolean isConnectingNode(Way w1, Way w2, Node n) {
        if (TurnRestrictionBuilder.isStartNode(w1, n)) {
            return TurnRestrictionBuilder.isStartNode(w2, n) || TurnRestrictionBuilder.isEndNode(w2, n);
        }
        if (TurnRestrictionBuilder.isEndNode(w1, n)) {
            return TurnRestrictionBuilder.isStartNode(w2, n) || TurnRestrictionBuilder.isEndNode(w2, n);
        }
        return false;
    }

    public static boolean isClosedAt(Way w, Node n) {
        List nodes = w.getNodes();
        nodes.retainAll(Collections.singletonList(n));
        return nodes.size() >= 2;
    }

    protected Relation initTurnRestrictionFromTwoWays(List<OsmPrimitive> primitives) {
        ArrayList selWays;
        Way w1 = null;
        Way w2 = null;
        Node via = null;
        if (primitives.size() == 2) {
            selWays = new ArrayList(Utils.filteredCollection(primitives, Way.class));
            if (selWays.size() != 2) {
                return null;
            }
            w1 = (Way)selWays.get(0);
            w2 = (Way)selWays.get(1);
            via = TurnRestrictionBuilder.getUniqueCommonNode(w1, w2);
        } else if (primitives.size() == 3) {
            selWays = new ArrayList(Utils.filteredCollection(primitives, Way.class));
            ArrayList selNodes = new ArrayList(Utils.filteredCollection(primitives, Node.class));
            if (selWays.size() != 2) {
                return null;
            }
            if (selNodes.size() != 1) {
                return null;
            }
            w1 = (Way)selWays.get(0);
            w2 = (Way)selWays.get(1);
            via = (Node)selNodes.get(0);
            if (!w1.getNodes().contains(via) || !w2.getNodes().contains(via)) {
                via = null;
            }
        } else {
            return null;
        }
        assert (w1 != null);
        assert (w2 != null);
        Relation tr = new Relation();
        tr.put("type", "restriction");
        tr.addMember(new RelationMember("from", (OsmPrimitive)w1));
        tr.addMember(new RelationMember("to", (OsmPrimitive)w2));
        if (via != null) {
            tr.addMember(new RelationMember("via", (OsmPrimitive)via));
            RelativeWayJoinOrientation orientation = TurnRestrictionBuilder.determineWayJoinOrientation(w1, w2);
            if (orientation != null) {
                switch (orientation) {
                    case LEFT: {
                        tr.put("restriction", TurnRestrictionType.NO_LEFT_TURN.getTagValue());
                        break;
                    }
                    case RIGHT: {
                        tr.put("restriction", TurnRestrictionType.NO_RIGHT_TURN.getTagValue());
                    }
                }
            }
        }
        return tr;
    }

    protected Relation initEmptyTurnRestriction() {
        Relation tr = new Relation();
        tr.put("type", "restriction");
        return tr;
    }

    public synchronized Relation build(List<OsmPrimitive> primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return this.initEmptyTurnRestriction();
        }
        switch (primitives.size()) {
            case 1: {
                Relation tr = this.initEmptyTurnRestriction();
                if (Utils.filteredCollection(primitives, Way.class).size() == 1) {
                    tr.addMember(new RelationMember("from", primitives.get(0)));
                }
                return tr;
            }
            case 2: {
                Relation tr = this.initNoUTurnRestriction(primitives);
                if (tr != null) {
                    return tr;
                }
                tr = this.initTurnRestrictionFromTwoWays(primitives);
                if (tr != null) {
                    return tr;
                }
                return this.initEmptyTurnRestriction();
            }
        }
        Relation tr = this.initTurnRestrictionFromTwoWays(primitives);
        if (tr != null) {
            return tr;
        }
        return this.initEmptyTurnRestriction();
    }

    public static enum RelativeWayJoinOrientation {
        LEFT,
        RIGHT;

    }
}

