/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ohe;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.ohe.ClockSystem;
import org.openstreetmap.josm.plugins.ohe.gui.TimeRect;
import org.openstreetmap.josm.plugins.ohe.parser.OpeningTimeCompiler;

public final class OpeningTimeUtils {
    private OpeningTimeUtils() {
    }

    public static List<int[]> convert(List<DateTime> dateTimes) {
        ArrayList<int[]> ret = new ArrayList<int[]>();
        for (int i = 0; i < dateTimes.size(); ++i) {
            DateTime dateTime = dateTimes.get(i);
            ArrayList<DateTime> newDateTimes = new ArrayList<DateTime>();
            if (dateTime.daySpans.size() == 1 && dateTime.daySpans.get(0).isSpan()) {
                List<DaySpan> following;
                ArrayList<DaySpan> partDaySpans = new ArrayList<DaySpan>();
                int startDay = dateTime.daySpans.get((int)0).startDay;
                while (i + 1 < dateTimes.size() && (following = dateTimes.get((int)(i + 1)).daySpans).size() == 1 && following.get((int)0).startDay > dateTime.daySpans.get((int)0).startDay && following.get((int)0).endDay < dateTime.daySpans.get((int)0).endDay) {
                    partDaySpans.add(new DaySpan(startDay, following.get((int)0).startDay - 1));
                    startDay = following.get((int)0).endDay + 1;
                    newDateTimes.add(dateTimes.get(i + 1));
                    ++i;
                }
                partDaySpans.add(new DaySpan(startDay, dateTime.daySpans.get((int)0).endDay));
                newDateTimes.add(new DateTime(partDaySpans, dateTime.daytimeSpans));
            }
            if (newDateTimes.isEmpty()) {
                newDateTimes.add(dateTime);
            }
            for (DateTime dateTime2 : newDateTimes) {
                for (DaySpan dayspan : dateTime2.daySpans) {
                    for (DaytimeSpan timespan : dateTime2.daytimeSpans) {
                        if (timespan.isOff()) continue;
                        ret.add(new int[]{dayspan.startDay, dayspan.endDay, timespan.startMinute, timespan.endMinute});
                    }
                }
            }
        }
        return ret;
    }

    public static String makeStringFromRects(List<TimeRect> givenTimeRects) {
        boolean[][] minuteArray = new boolean[7][1442];
        for (int day = 0; day < 7; ++day) {
            for (int minute = 0; minute < 1442; ++minute) {
                minuteArray[day][minute] = false;
            }
        }
        for (TimeRect timeRect : givenTimeRects) {
            for (int day = timeRect.getDayStart(); day <= timeRect.getDayEnd(); ++day) {
                for (int minute = timeRect.getMinuteStart(); minute <= timeRect.getMinuteEnd(); ++minute) {
                    minuteArray[day][minute] = true;
                }
            }
        }
        StringBuilder ret = new StringBuilder();
        int[] days = new int[7];
        for (int i = 0; i < 7; ++i) {
            String add = "";
            if (OpeningTimeUtils.isArrayEmpty(minuteArray[i]) && days[i] == 0) {
                days[i] = 8;
            } else if (OpeningTimeUtils.isArrayEmpty(minuteArray[i]) && days[i] < 0) {
                add = OpeningTimeCompiler.WEEKDAYS[i] + " off";
                days[i] = -8;
            } else if (days[i] <= 0) {
                int j;
                days[i] = i + 1;
                int lastSameDay = i;
                int sameDayCount = 1;
                for (j = i + 1; j < 7; ++j) {
                    if (!OpeningTimeUtils.arraysEqual(minuteArray[i], minuteArray[j])) continue;
                    days[j] = i + 1;
                    lastSameDay = j;
                    ++sameDayCount;
                }
                if (sameDayCount == 1) {
                    add = OpeningTimeCompiler.WEEKDAYS[i] + " " + OpeningTimeUtils.makeStringFromMinuteArray(minuteArray[i]);
                } else if (sameDayCount == 2) {
                    add = OpeningTimeCompiler.WEEKDAYS[i] + "," + OpeningTimeCompiler.WEEKDAYS[lastSameDay] + " " + OpeningTimeUtils.makeStringFromMinuteArray(minuteArray[i]);
                } else if (sameDayCount > 2) {
                    add = OpeningTimeCompiler.WEEKDAYS[i] + "-" + OpeningTimeCompiler.WEEKDAYS[lastSameDay] + " " + OpeningTimeUtils.makeStringFromMinuteArray(minuteArray[i]);
                    for (j = i + 1; j < lastSameDay; ++j) {
                        if (days[j] != 0) continue;
                        days[j] = -i - 1;
                    }
                }
            }
            if (add.isEmpty()) continue;
            if (ret.length() != 0) {
                ret.append("; ");
            }
            ret.append(add);
        }
        return ret.toString();
    }

    private static String makeStringFromMinuteArray(boolean[] minutes) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < minutes.length; ++i) {
            if (!minutes[i]) continue;
            int start = i;
            while (i < minutes.length && minutes[i]) {
                ++i;
            }
            String addString = OpeningTimeUtils.timeString(start);
            if (i - 1 == 1441) {
                addString = addString + "+";
            } else if (start != i - 1) {
                addString = addString + "-" + OpeningTimeUtils.timeString(i - 1);
            }
            if (ret.length() != 0) {
                ret.append(',');
            }
            ret.append(addString);
        }
        return ret.toString();
    }

    public static String timeString(int minutes) {
        return OpeningTimeUtils.timeString(minutes, ClockSystem.TWENTYFOUR_HOURS);
    }

    public static String timeString(int minutes, ClockSystem hourMode) {
        return OpeningTimeUtils.timeString(minutes, hourMode, false);
    }

    public static String timeString(int minutes, ClockSystem hourMode, boolean showPeriod) {
        int h = minutes / 60;
        String period = "";
        if (hourMode == ClockSystem.TWELVE_HOURS) {
            if (h == 24) {
                return "midnight";
            }
            if (showPeriod) {
                String string = period = h < 12 ? " AM" : " PM";
            }
            if ((h %= 12) == 0) {
                h = 12;
            }
        }
        int m = minutes % 60;
        return (h < 10 ? "0" : "") + h + ":" + (m < 10 ? "0" : "") + m + period;
    }

    private static boolean isArrayEmpty(boolean[] bs) {
        for (boolean b : bs) {
            if (!b) continue;
            return false;
        }
        return true;
    }

    private static boolean arraysEqual(boolean[] bs, boolean[] bs2) {
        boolean ret = true;
        for (int i = 0; i < bs.length; ++i) {
            ret &= bs[i] == bs2[i];
        }
        return ret;
    }

    public static void ensureValidDay(int day, String paramName) throws IllegalArgumentException {
        if (day < 0 || day > 6) {
            throw new IllegalArgumentException(paramName + " is not a valid day (0-6). Given value is " + day);
        }
    }

    public static void ensureValidMinute(int minute, String paramName) throws IllegalArgumentException {
        if (minute < 0 || minute > 1441) {
            throw new IllegalArgumentException(paramName + " is not a valid minute (0-1441). Given value is " + minute);
        }
    }

    public static class DateTime {
        public final List<DaySpan> daySpans;
        public final List<DaytimeSpan> daytimeSpans;

        public DateTime(List<DaySpan> daySpans, List<DaytimeSpan> daytimeSpans) {
            this.daySpans = daySpans;
            this.daytimeSpans = daytimeSpans;
        }
    }

    public static class DaytimeSpan {
        public final int startMinute;
        public final int endMinute;

        public DaytimeSpan(int startMinute, int endMinute) {
            this.startMinute = startMinute;
            this.endMinute = endMinute;
        }

        public boolean isOff() {
            return this.startMinute == -1;
        }

        public boolean isSpan() {
            return this.endMinute > this.startMinute;
        }
    }

    public static class DaySpan {
        public final int startDay;
        public final int endDay;

        public DaySpan(int startDay, int endDay) {
            this.startDay = startDay;
            this.endDay = endDay;
        }

        public boolean isSpan() {
            return this.endDay > this.startDay;
        }

        public boolean isSingleDay() {
            return this.startDay == this.endDay;
        }
    }
}

