/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.datasets.at;

import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.DefaultGmlHandler;

public class AustrianGmlHandler
extends DefaultGmlHandler {
    @Override
    public CoordinateReferenceSystem getCrsFor(String crsName) throws NoSuchAuthorityCodeException, FactoryException {
        if (crsName != null && crsName.startsWith("AUT")) {
            if ("AUT-GK28".equalsIgnoreCase(crsName)) {
                return CRS.decode((String)"EPSG:31281");
            }
            if ("AUT-GK31".equalsIgnoreCase(crsName)) {
                return CRS.decode((String)"EPSG:31282");
            }
            if ("AUT-GK34".equalsIgnoreCase(crsName)) {
                return CRS.decode((String)"EPSG:31283");
            }
            if ("AUT-GK28-5".equalsIgnoreCase(crsName)) {
                return CRS.decode((String)"EPSG:31251");
            }
            if ("AUT-GK31-5".equalsIgnoreCase(crsName)) {
                return CRS.decode((String)"EPSG:31252");
            }
            if ("AUT-GK34-5".equalsIgnoreCase(crsName)) {
                return CRS.decode((String)"EPSG:31253");
            }
            if ("AUT-BM28".equalsIgnoreCase(crsName)) {
                return CRS.decode((String)"EPSG:31288");
            }
            if ("AUT-BM31".equalsIgnoreCase(crsName)) {
                return CRS.decode((String)"EPSG:31289");
            }
            if ("AUT-BM34".equalsIgnoreCase(crsName)) {
                return CRS.decode((String)"EPSG:31290");
            }
            if ("AUT-LM".equalsIgnoreCase(crsName)) {
                return CRS.decode((String)"EPSG:31287");
            }
            if ("AUT-LL-BESSEL".equalsIgnoreCase(crsName)) {
                // empty if block
            }
        }
        return super.getCrsFor(crsName);
    }
}

