/*
 * Decompiled with CFR 0.152.
 */
package net.simon04.comfort0;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class EditorLauncher {
    private final Path fileToEdit;

    public EditorLauncher(Path fileToEdit) {
        this.fileToEdit = fileToEdit;
    }

    public Process launch() throws IOException {
        String key = "comfort0.editor";
        List editors = Config.getPref().getList("comfort0.editor", Arrays.asList("code --new-window --reuse-window --wait", "atom --wait", "gedit --standalone --wait", "kate --new --block", "konsole -e nvim", "urxvt -e nvim", "konsole -e vim", "urxvt -e vim", "konsole -e nano", "urxvt -e nano", "notepad++", "notepad"));
        for (String editor : editors) {
            List<String> cmd = Stream.concat(Pattern.compile("\\s+").splitAsStream(editor), Stream.of(this.fileToEdit.toString())).collect(Collectors.toList());
            try {
                return new ProcessBuilder(cmd).start();
            }
            catch (IOException ex) {
                Logging.trace((Throwable)ex);
            }
        }
        throw new IOException(I18n.tr((String)"No supported editor found. Please ''{0}'' set in advanced preferences!", (Object[])new Object[]{"comfort0.editor"}));
    }
}

