/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fit.lib.global;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.plugins.fit.lib.FitBaseType;
import org.openstreetmap.josm.plugins.fit.lib.global.FitData;
import org.openstreetmap.josm.plugins.fit.lib.global.FitDevDataRecord;
import org.openstreetmap.josm.plugins.fit.lib.global.IFitTimestamp;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperField;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperFieldDescriptionMessage;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitField;
import org.openstreetmap.josm.plugins.fit.lib.utils.DevDataUtils;
import org.openstreetmap.josm.plugins.fit.lib.utils.NumberUtils;

public record HeartRateCadenceDistanceSpeed(Instant timestamp, double lat, double lon, double ele, short heartRate, short cadence, int distance, int speed, long[][] unknown, FitDevDataRecord devData) implements FitData,
IFitTimestamp<HeartRateCadenceDistanceSpeed>
{
    static final long[][] NO_UNKNOWNS = new long[0][];
    private static final long EPOCH_DIFFERENCE = Instant.parse("1989-12-31T00:00:00Z").getEpochSecond();

    public HeartRateCadenceDistanceSpeed(int heartRate, int cadence, int distance, int speed, FitDevDataRecord devData) {
        this(Instant.EPOCH, Double.NaN, Double.NaN, Double.NaN, NumberUtils.checkShort(heartRate), NumberUtils.checkShort(cadence), distance, speed, NO_UNKNOWNS, devData);
    }

    @Override
    public HeartRateCadenceDistanceSpeed withTimestamp(Instant timestamp) {
        return new HeartRateCadenceDistanceSpeed(timestamp, this.lat, this.lon, this.ele, this.heartRate, this.cadence, this.distance, this.speed, this.unknown, this.devData);
    }

    public static HeartRateCadenceDistanceSpeed parse(boolean littleEndian, List<FitField> fieldList, List<FitDeveloperField> developerFieldList, FitDeveloperFieldDescriptionMessage[] developerFields, InputStream inputStream) throws IOException {
        long heartRate = FitBaseType.uint8.invalidValue();
        short cadence = 255;
        double lat = Double.NaN;
        double lon = Double.NaN;
        double ele = Double.NaN;
        long distance = FitBaseType.uint32.invalidValue();
        long speed = FitBaseType.uint16.invalidValue();
        Instant timestamp = Instant.EPOCH;
        long[][] unknowns = NO_UNKNOWNS;
        block10: for (FitField fitField : fieldList) {
            short size = fitField.size();
            switch (fitField.fieldDefinitionNumber()) {
                case 0: {
                    lat = HeartRateCadenceDistanceSpeed.decodeDegrees(NumberUtils.decodeLong(size, littleEndian, inputStream));
                    continue block10;
                }
                case 1: {
                    lon = HeartRateCadenceDistanceSpeed.decodeDegrees(NumberUtils.decodeLong(size, littleEndian, inputStream));
                    continue block10;
                }
                case 2: {
                    ele = HeartRateCadenceDistanceSpeed.decodeElevation(NumberUtils.decodeLong(size, littleEndian, inputStream));
                    continue block10;
                }
                case 3: {
                    heartRate = NumberUtils.decodeShort(size, littleEndian, inputStream);
                    continue block10;
                }
                case 4: {
                    cadence = NumberUtils.decodeShort(size, littleEndian, inputStream);
                    continue block10;
                }
                case 5: {
                    distance = NumberUtils.decodeInt(size, littleEndian, inputStream);
                    continue block10;
                }
                case 6: {
                    speed = NumberUtils.decodeInt(size, littleEndian, inputStream);
                    continue block10;
                }
                case 253: {
                    timestamp = HeartRateCadenceDistanceSpeed.decodeInstant(size, littleEndian, inputStream);
                    continue block10;
                }
            }
            unknowns = (long[][])Arrays.copyOf(unknowns, unknowns.length + 1);
            unknowns[unknowns.length - 1] = new long[]{fitField.fieldDefinitionNumber(), NumberUtils.decodeLong(size, littleEndian, inputStream)};
        }
        return new HeartRateCadenceDistanceSpeed(timestamp, lat, lon, ele, (short)heartRate, cadence, (int)distance, (int)speed, unknowns, DevDataUtils.parseDevFields(littleEndian, developerFieldList, developerFields, inputStream));
    }

    static Instant decodeInstant(short size, boolean littleEndian, InputStream inputStream) throws IOException {
        long timestamp = NumberUtils.decodeLong(size, littleEndian, inputStream);
        return Instant.ofEpochSecond(EPOCH_DIFFERENCE + timestamp);
    }

    private static double decodeDegrees(long original) {
        if (original == FitBaseType.sint32.invalidValue()) {
            return Double.NaN;
        }
        return (double)original * 180.0 / 2.147483647E9;
    }

    private static double decodeElevation(long original) {
        return (double)original / 5.0 - 500.0;
    }
}

