/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo;

import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.actions.SimplifyWayAction;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.fr.cadastre.download.CadastreDownloadData;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFile;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileDIC;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileGEN;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileGEO;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileQAL;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileSCD;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileVEC;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoLotFile;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoRecord;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class EdigeoFileTHF
extends EdigeoFile {
    Support support;
    final List<Lot> lots = new ArrayList<Lot>();

    public EdigeoFileTHF(Path path) throws IOException {
        super(path);
    }

    public Support getSupport() {
        return this.support;
    }

    public List<Lot> getLots() {
        return Collections.unmodifiableList(this.lots);
    }

    @Override
    protected EdigeoFile.Block createBlock(String type) {
        switch (type) {
            case "GTS": {
                this.support = new Support(type);
                return this.support;
            }
            case "GTL": {
                return EdigeoFileTHF.addBlock(this.lots, new Lot(type));
            }
        }
        throw new IllegalArgumentException(type);
    }

    @Override
    public EdigeoFileTHF read() throws IOException, ReflectiveOperationException {
        super.read();
        for (Lot lot : this.getLots()) {
            lot.readFiles(this.path);
        }
        return this;
    }

    @Override
    public EdigeoFileTHF fill(DataSet ds, CadastreDownloadData data) {
        super.fill(ds, data);
        for (Lot lot : this.getLots()) {
            lot.fill(ds, data);
        }
        ds.getWays().forEach(w -> {
            SequenceCommand command = SimplifyWayAction.createSimplifyCommand((Way)w, (double)Config.getPref().getDouble("cadastre.simplify-way.max-error", 0.2));
            if (command != null) {
                command.executeCommand();
            }
        });
        return this;
    }

    @Override
    boolean isValid() {
        return this.support.isValid() && this.lots.stream().allMatch(EdigeoFile.Block::isValid);
    }

    public static class Support
    extends EdigeoFile.Block {
        String author = "";
        String recipient = "";
        int nLots;
        int nVolumes;
        final List<String> volumeLabels = new ArrayList<String>();
        SecurityClassification security;
        String diffusionRestriction = "";
        String edigeoVersion = "";
        LocalDate edigeoDate;
        String transmissionName = "";
        int transmissionEdition;
        LocalDate transmissionDate;
        String transmissionInformation = "";

        Support(String type) {
            super(type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "AUT": {
                    this.safeGetAndLog(r, s -> {
                        this.author = this.author + s;
                    }, I18n.tr((String)"Author", (Object[])new Object[0]));
                    break;
                }
                case "ADR": {
                    this.safeGetAndLog(r, s -> {
                        this.recipient = this.recipient + s;
                    }, I18n.tr((String)"Recipient", (Object[])new Object[0]));
                    break;
                }
                case "LOC": {
                    this.nLots = this.safeGetInt(r);
                    break;
                }
                case "VOC": {
                    this.nVolumes = this.safeGetInt(r);
                    break;
                }
                case "VOL": {
                    this.safeGet(r, this.volumeLabels);
                    break;
                }
                case "SEC": {
                    this.security = SecurityClassification.of(this.safeGetInt(r));
                    break;
                }
                case "RDI": {
                    this.safeGetAndLog(r, s -> {
                        this.diffusionRestriction = this.diffusionRestriction + s;
                    }, I18n.tr((String)"Diffusion restriction", (Object[])new Object[0]));
                    break;
                }
                case "VER": {
                    this.safeGet(r, (String s) -> {
                        this.edigeoVersion = this.edigeoVersion + s;
                    });
                    break;
                }
                case "VDA": {
                    this.edigeoDate = this.safeGetDate(r);
                    break;
                }
                case "TRL": {
                    this.safeGet(r, (String s) -> {
                        this.transmissionName = this.transmissionName + s;
                    });
                    break;
                }
                case "EDN": {
                    this.transmissionEdition = this.safeGetInt(r);
                    break;
                }
                case "TDA": {
                    this.transmissionDate = this.safeGetDateAndLog(r, I18n.tr((String)"Date", (Object[])new Object[0]));
                    break;
                }
                case "INF": {
                    this.safeGetAndLog(r, s -> {
                        this.transmissionInformation = this.transmissionInformation + s;
                    }, I18n.tr((String)"Information", (Object[])new Object[0]));
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && Support.areNotEmpty(this.author, this.recipient, this.edigeoVersion, this.transmissionName) && Support.areSameSize(this.nVolumes, this.volumeLabels) && this.transmissionEdition >= 1;
        }

        public final String getAuthor() {
            return this.author;
        }

        public final String getRecipient() {
            return this.recipient;
        }

        public final int getnLots() {
            return this.nLots;
        }

        public final int getnVolumes() {
            return this.nVolumes;
        }

        public final List<String> getVolumeLabels() {
            return Collections.unmodifiableList(this.volumeLabels);
        }

        public final SecurityClassification getSecurity() {
            return this.security;
        }

        public final String getDiffusionRestriction() {
            return this.diffusionRestriction;
        }

        public final String getEdigeoVersion() {
            return this.edigeoVersion;
        }

        public final LocalDate getEdigeoDate() {
            return this.edigeoDate;
        }

        public final String getTransmissionName() {
            return this.transmissionName;
        }

        public final int getTransmissionEdition() {
            return this.transmissionEdition;
        }

        public final LocalDate getTransmissionDate() {
            return this.transmissionDate;
        }

        public final String getTransmissionInformation() {
            return this.transmissionInformation;
        }

        static enum SecurityClassification {
            MILITARY_SECRECY(1),
            INDUSTRIAL_SECRECY(2),
            CONFIDENTIAL(3),
            MILITARY_CONFIDENTIAL(4),
            INDUSTRIAL_CONFIDENTIAL(5),
            RESTRICTED_DIFFUSION(6),
            NOT_PROTECTED(7);

            final int level;

            private SecurityClassification(int level) {
                this.level = level;
            }

            public static SecurityClassification of(int level) {
                for (SecurityClassification s : SecurityClassification.values()) {
                    if (s.level != level) continue;
                    return s;
                }
                throw new IllegalArgumentException(Integer.toString(level));
            }
        }
    }

    public static class Lot
    extends EdigeoFile.Block {
        String name = "";
        String information = "";
        String genName = "";
        String genId = "";
        String geoName = "";
        String geoId = "";
        String qalName = "";
        String qalId = "";
        String dicName = "";
        String dicId = "";
        String scdName = "";
        String scdId = "";
        int nVec;
        final List<String> vecName = new ArrayList<String>();
        final List<String> vecId = new ArrayList<String>();
        EdigeoFileGEN gen;
        EdigeoFileGEO geo;
        EdigeoFileDIC dic;
        EdigeoFileSCD scd;
        EdigeoFileQAL qal;
        final List<EdigeoFileVEC> vec = new ArrayList<EdigeoFileVEC>();
        final List<EdigeoLotFile<?>> allFiles = new ArrayList();

        Lot(String type) {
            super(type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "LON": {
                    this.safeGetAndLog(r, s -> {
                        this.name = this.name + s;
                    }, I18n.tr((String)"Name", (Object[])new Object[0]));
                    break;
                }
                case "INF": {
                    this.safeGetAndLog(r, s -> {
                        this.information = this.information + s;
                    }, I18n.tr((String)"Information", (Object[])new Object[0]));
                    break;
                }
                case "GNN": {
                    this.safeGet(r, (String s) -> {
                        this.genName = this.genName + s;
                    });
                    break;
                }
                case "GNI": {
                    this.safeGet(r, (String s) -> {
                        this.genId = this.genId + s;
                    });
                    break;
                }
                case "GON": {
                    this.safeGet(r, (String s) -> {
                        this.geoName = this.geoName + s;
                    });
                    break;
                }
                case "GOI": {
                    this.safeGet(r, (String s) -> {
                        this.geoId = this.geoId + s;
                    });
                    break;
                }
                case "QAN": {
                    this.safeGet(r, (String s) -> {
                        this.qalName = this.qalName + s;
                    });
                    break;
                }
                case "QAI": {
                    this.safeGet(r, (String s) -> {
                        this.qalId = this.qalId + s;
                    });
                    break;
                }
                case "DIN": {
                    this.safeGet(r, (String s) -> {
                        this.dicName = this.dicName + s;
                    });
                    break;
                }
                case "DII": {
                    this.safeGet(r, (String s) -> {
                        this.dicId = this.dicId + s;
                    });
                    break;
                }
                case "SCN": {
                    this.safeGet(r, (String s) -> {
                        this.scdName = this.scdName + s;
                    });
                    break;
                }
                case "SCI": {
                    this.safeGet(r, (String s) -> {
                        this.scdId = this.scdId + s;
                    });
                    break;
                }
                case "GDC": {
                    this.nVec = this.safeGetInt(r);
                    break;
                }
                case "GDN": {
                    this.safeGet(r, this.vecName);
                    break;
                }
                case "GDI": {
                    this.safeGet(r, this.vecId);
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        void readFiles(Path path) throws IOException, ReflectiveOperationException {
            Path dir = path.getParent();
            this.allFiles.add((EdigeoLotFile<?>)new EdigeoFileGEN(this, this.genId, dir.resolve(this.name + this.genName + ".GEN")).read());
            this.allFiles.add((EdigeoLotFile<?>)new EdigeoFileGEO(this, this.geoId, dir.resolve(this.name + this.geoName + ".GEO")).read());
            this.allFiles.add((EdigeoLotFile<?>)new EdigeoFileDIC(this, this.dicId, dir.resolve(this.name + this.dicName + ".DIC")).read());
            this.allFiles.add((EdigeoLotFile<?>)new EdigeoFileSCD(this, this.scdId, dir.resolve(this.name + this.scdName + ".SCD")).read());
            this.allFiles.add((EdigeoLotFile<?>)new EdigeoFileQAL(this, this.qalId, dir.resolve(this.name + this.qalName + ".QAL")).read());
            for (int i = 0; i < this.getNumberOfGeoData(); ++i) {
                this.allFiles.add((EdigeoLotFile<?>)new EdigeoFileVEC(this, this.vecId.get(i), dir.resolve(this.name + this.vecName.get(i) + ".VEC")).read());
            }
            this.allFiles.forEach(EdigeoFile::resolve);
            for (EdigeoFile edigeoFile : this.allFiles) {
                boolean valid = edigeoFile.isValid();
                if (valid) {
                    Logging.debug((String)(edigeoFile.path + ": valid"));
                    continue;
                }
                Logging.warn((String)(edigeoFile.path + ": invalid!"));
            }
        }

        void fill(DataSet ds, CadastreDownloadData data) {
            this.allFiles.forEach(f -> f.fill(ds, data));
        }

        @Override
        boolean isValid() {
            return super.isValid() && Lot.areNotEmpty(this.name, this.genName, this.genId, this.geoName, this.geoId);
        }

        public final String getName() {
            return this.name;
        }

        public final String getInformation() {
            return this.information;
        }

        public final String getGenDataName() {
            return this.genName;
        }

        public final String getGenDataId() {
            return this.genId;
        }

        public final String getCoorRefName() {
            return this.geoName;
        }

        public final String getCoorRefId() {
            return this.geoId;
        }

        public final String getQualityName() {
            return this.qalName;
        }

        public final String getQualityId() {
            return this.qalId;
        }

        public final String getDictName() {
            return this.dicName;
        }

        public final String getDictId() {
            return this.dicId;
        }

        public final String getScdName() {
            return this.scdName;
        }

        public final String getScdId() {
            return this.scdId;
        }

        public final int getNumberOfGeoData() {
            return this.nVec;
        }

        public final String getGeoDataName(int i) {
            return this.vecName.get(i);
        }

        public final List<String> getGeoDataNames() {
            return Collections.unmodifiableList(this.vecName);
        }

        public final List<String> getGeoDataIds() {
            return Collections.unmodifiableList(this.vecId);
        }

        public final String getGeoDataId(int i) {
            return this.vecId.get(i);
        }
    }

    public static class ChildBlock
    extends EdigeoFile.Block {
        protected final Lot lot;

        ChildBlock(Lot lot, String type) {
            super(type);
            this.lot = Objects.requireNonNull(lot, "lot");
        }
    }
}

