/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common.historic;

import javax.measure.MetricPrefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Time;
import si.uom.quantity.Impulse;
import systems.uom.common.historic.CGS;
import tech.units.indriya.AbstractSystemOfUnits;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.TransformedUnit;
import tech.units.indriya.unit.Units;

public final class MKpS
extends AbstractSystemOfUnits {
    private static final String SYSTEM_NAME = "Gravitational metric system";
    private static final MKpS INSTANCE = new MKpS();
    public static final Unit<Length> METRE = MKpS.addUnit(Units.METRE, Length.class);
    public static final Unit<Mass> HYL = MKpS.addUnit(Units.KILOGRAM.multiply(9.80665), "Hyl", "hyl", Mass.class);
    public static final Unit<Mass> TME = MKpS.addUnit(new TransformedUnit<Mass>("Technical mass unit", "TME", HYL, (UnitConverter)MultiplyConverter.identity()));
    public static final Unit<Time> SECOND = MKpS.addUnit(Units.SECOND, Time.class);
    public static final Unit<Speed> METRE_PER_SECOND = MKpS.addUnit(new ProductUnit(METRE.divide(SECOND)), Speed.class);
    public static final Unit<Energy> KILOPOND_METRE = MKpS.addUnit(Units.JOULE.multiply(9.80665), "Kilopond-metre", "kpm", Energy.class);
    public static final Unit<Force> POND = MKpS.addUnit(CGS.DYNE.multiply(980.665), "Pond", "p", Force.class);
    public static final Unit<Power> HORSEPOWER = MKpS.addUnit(Units.WATT.multiply(735.499), "Horsepower", "HP");
    public static final Unit<Power> PONCELET = MKpS.addUnit(Units.WATT.multiply(980.665), "Poncelet", "Pq", Power.class);
    public static final Unit<Pressure> TECHNICAL_ATMOSPHERE = MKpS.addUnit(MetricPrefix.KILO(Units.PASCAL).multiply(98.0665), "Technical atmosphere", "at", Pressure.class);
    public static final Unit<Pressure> METER_OF_WATER_COLUMN = MKpS.addUnit(MetricPrefix.KILO(Units.PASCAL).multiply(980665.0).divide(100000.0));
    public static final Unit<Impulse> KILOPOND_SECOND = MKpS.addUnit(new ProductUnit(MetricPrefix.KILO(POND).multiply(SECOND)), Impulse.class);

    private MKpS() {
    }

    public static MKpS getInstance() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return SYSTEM_NAME;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        MKpS.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, boolean isLabel) {
        if (isLabel && text != null) {
            SimpleUnitFormat.getInstance().label(unit, text);
        }
        if (name != null && unit instanceof AbstractUnit) {
            return AbstractSystemOfUnits.Helper.addUnit(MKpS.INSTANCE.units, unit, name);
        }
        MKpS.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text) {
        return MKpS.addUnit(unit, name, text, true);
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, Class<? extends Quantity<?>> type) {
        MKpS.INSTANCE.quantityToUnit.put(type, unit);
        return MKpS.addUnit(unit, name, text, true);
    }

    private static <U extends Unit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        MKpS.INSTANCE.units.add(unit);
        MKpS.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }
}

