/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.NativeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.xml.filter.UnsupportedFilterException;

public class FilterCompliancePreProcessor
implements FilterVisitor {
    private static final int LOW = 0;
    private static final int MEDIUM = 1;
    private static final int HIGH = 2;
    private int complianceInt;
    private Stack<Data> current = new Stack();
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private boolean requiresPostProcessing = false;

    public FilterCompliancePreProcessor(Integer complianceLevel) {
        if (complianceLevel != 0 && complianceLevel != 1 && complianceLevel != 2) {
            throw new IllegalArgumentException("compliance level must be one of: XMLHandlerHints.VALUE_FILTER_COMPLIANCE_LOOSE XMLHandlerHints.VALUE_FILTER_COMPLIANCE_MEDIUM or XMLHandlerHints.VALUE_FILTER_COMPLIANCE_MAXIMUM");
        }
        this.complianceInt = complianceLevel;
    }

    public Id getFidFilter() {
        if (this.current.isEmpty()) {
            Set empty = Collections.emptySet();
            return this.ff.id(empty);
        }
        Data data = this.current.peek();
        if (!data.fids.isEmpty()) {
            HashSet<FeatureId> set = new HashSet<FeatureId>();
            Set<String> fids = data.fids;
            for (String fid : fids) {
                set.add(this.ff.featureId(fid));
            }
            return this.ff.id(set);
        }
        Set empty = Collections.emptySet();
        return this.ff.id(empty);
    }

    public Filter getFilter() {
        if (this.current.isEmpty()) {
            return Filter.EXCLUDE;
        }
        return this.current.peek().filter;
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(BBOX filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(Contains filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(Crosses filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(Disjoint filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    public Object visit(DistanceBufferOperator filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(Equals filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(Intersects filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(Overlaps filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(Touches filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(Within filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(Beyond filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(DWithin filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(PropertyIsLike filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(And filter, Object extraData) {
        int startSize = this.current.size();
        try {
            switch (this.complianceInt) {
                case 0: {
                    this.current.push(new Data(filter));
                    break;
                }
                case 1: {
                    for (Filter child : filter.getChildren()) {
                        extraData = child.accept(this, extraData);
                    }
                    Data mediumFilter = this.createMediumLevelLogicFilter((short)2, startSize);
                    this.current.push(mediumFilter);
                    break;
                }
                case 2: {
                    for (Filter child : filter.getChildren()) {
                        extraData = child.accept(this, extraData);
                    }
                    Data highFilter = this.createHighLevelLogicFilter((short)2, startSize);
                    this.current.push(highFilter);
                    break;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof UnsupportedFilterException) {
                throw (UnsupportedFilterException)e;
            }
            throw new UnsupportedFilterException("Exception creating filter", e);
        }
        return extraData;
    }

    @Override
    public Object visit(Or filter, Object extraData) {
        int startSize = this.current.size();
        try {
            switch (this.complianceInt) {
                case 0: {
                    this.current.push(new Data(filter));
                    break;
                }
                case 1: {
                    for (Filter child : filter.getChildren()) {
                        extraData = child.accept(this, extraData);
                    }
                    Data mediumFilter = this.createMediumLevelLogicFilter((short)1, startSize);
                    this.current.push(mediumFilter);
                    break;
                }
                case 2: {
                    for (Filter child : filter.getChildren()) {
                        extraData = child.accept(this, extraData);
                    }
                    Data highFilter = this.createHighLevelLogicFilter((short)1, startSize);
                    this.current.push(highFilter);
                    break;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof UnsupportedFilterException) {
                throw (UnsupportedFilterException)e;
            }
            throw new UnsupportedFilterException("Exception creating filter", e);
        }
        return extraData;
    }

    @Override
    public Object visit(Not filter, Object extraData) {
        int startSize = 1;
        try {
            switch (this.complianceInt) {
                case 0: {
                    this.current.push(new Data(filter));
                    break;
                }
                case 1: {
                    Filter child = filter.getFilter();
                    extraData = child.accept(this, extraData);
                    Data mediumFilter = this.createMediumLevelLogicFilter((short)3, startSize);
                    this.current.push(mediumFilter);
                    break;
                }
                case 2: {
                    Filter child = filter.getFilter();
                    extraData = child.accept(this, extraData);
                    Data highFilter = this.createHighLevelLogicFilter((short)3, startSize);
                    this.current.push(highFilter);
                    break;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof UnsupportedFilterException) {
                throw (UnsupportedFilterException)e;
            }
            throw new UnsupportedFilterException("Exception creating filter", e);
        }
        return extraData;
    }

    private Data createMediumLevelLogicFilter(short filterType, int startOfFilterStack) throws IllegalFilterException {
        Data resultingFilter;
        switch (filterType) {
            case 2: {
                Set<String> fids = this.andFids(startOfFilterStack);
                resultingFilter = this.buildFilter(filterType, startOfFilterStack);
                resultingFilter.fids.addAll(fids);
                if (resultingFilter.filter == Filter.EXCLUDE || fids.isEmpty()) break;
                this.requiresPostProcessing = true;
                break;
            }
            case 1: {
                Set<String> fids = this.orFids(startOfFilterStack);
                resultingFilter = this.buildFilter(filterType, startOfFilterStack);
                resultingFilter.fids.addAll(fids);
                break;
            }
            case 3: {
                resultingFilter = this.buildFilter(filterType, startOfFilterStack);
                break;
            }
            default: {
                resultingFilter = this.buildFilter(filterType, startOfFilterStack);
            }
        }
        return resultingFilter;
    }

    private Set<String> orFids(int startOfFilterStack) {
        HashSet<String> set = new HashSet<String>();
        for (int i = startOfFilterStack; i < this.current.size(); ++i) {
            Data data = (Data)this.current.get(i);
            if (data.fids.isEmpty()) continue;
            set.addAll(data.fids);
        }
        return set;
    }

    private Set<String> andFids(int startOfFilterStack) {
        if (!this.hasFidFilter(startOfFilterStack)) {
            return Collections.emptySet();
        }
        HashSet<Data> toRemove = new HashSet<Data>();
        ArrayList<Set<String>> fidSet = new ArrayList<Set<String>>();
        boolean doRemove = true;
        for (int i = startOfFilterStack; i < this.current.size(); ++i) {
            Data data = (Data)this.current.get(i);
            if (data.fids.isEmpty()) {
                toRemove.add(data);
                continue;
            }
            fidSet.add(data.fids);
            if (data.filter == Filter.EXCLUDE) continue;
            doRemove = false;
        }
        if (doRemove) {
            this.current.removeAll(toRemove);
        }
        if (fidSet.isEmpty()) {
            return Collections.emptySet();
        }
        if (fidSet.size() == 1) {
            return (Set)fidSet.get(0);
        }
        HashSet<String> set = new HashSet<String>();
        for (Set set2 : fidSet) {
            for (String fid : set2) {
                if (!this.allContain(fid, fidSet)) continue;
                set.add(fid);
            }
        }
        return set;
    }

    private boolean allContain(String fid, List<Set<String>> fidSets) {
        for (Set<String> tmp : fidSets) {
            if (tmp.contains(fid)) continue;
            return false;
        }
        return true;
    }

    private Data buildFilter(short filterType, int startOfFilterStack) throws IllegalFilterException {
        if (this.current.isEmpty()) {
            return Data.ALL;
        }
        if (filterType == 3) {
            return this.buildNotFilter(startOfFilterStack);
        }
        if (this.current.size() == startOfFilterStack + 1) {
            return this.current.pop();
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        while (this.current.size() > startOfFilterStack) {
            Data data = this.current.pop();
            if (data.filter == Filter.EXCLUDE) continue;
            filterList.add(data.filter);
        }
        BinaryLogicOperator f = filterType == 2 ? this.ff.and(filterList) : (filterType == 1 ? this.ff.or(filterList) : null);
        return new Data(this.compressFilter(filterType, f));
    }

    private Filter compressFilter(short filterType, Filter f) throws IllegalFilterException {
        BinaryLogicOperator result;
        int added = 0;
        ArrayList<Filter> resultList = new ArrayList<Filter>();
        switch (filterType) {
            case 2: {
                if (this.contains((And)f, Filter.EXCLUDE)) {
                    return Filter.EXCLUDE;
                }
                for (Filter item : ((And)f).getChildren()) {
                    Filter filter = item;
                    if (filter == Filter.INCLUDE) continue;
                    ++added;
                    resultList.add(filter);
                }
                if (resultList.isEmpty()) {
                    return Filter.EXCLUDE;
                }
                result = this.ff.and(resultList);
                break;
            }
            case 1: {
                if (this.contains((Or)f, Filter.INCLUDE)) {
                    return Filter.INCLUDE;
                }
                for (Filter item : ((Or)f).getChildren()) {
                    Filter filter = item;
                    if (filter == Filter.EXCLUDE) continue;
                    ++added;
                    resultList.add(filter);
                }
                if (resultList.isEmpty()) {
                    return Filter.EXCLUDE;
                }
                result = this.ff.or(resultList);
                break;
            }
            default: {
                return Filter.EXCLUDE;
            }
        }
        switch (added) {
            case 0: {
                return Filter.EXCLUDE;
            }
            case 1: {
                if (result instanceof Not) {
                    return ((Not)((Object)result)).getFilter();
                }
                return ((BinaryLogicOperator)result).getChildren().get(0);
            }
        }
        return result;
    }

    private boolean contains(BinaryLogicOperator f, Filter toFind) {
        for (Filter filter : f.getChildren()) {
            if (!toFind.equals(filter)) continue;
            return true;
        }
        return false;
    }

    private Data buildNotFilter(int startOfFilterStack) {
        if (this.current.size() > startOfFilterStack + 1) {
            throw new UnsupportedFilterException("A not filter cannot have more than one filter");
        }
        Data tmp = this.current.pop();
        Data data = new Data(this.ff.not(tmp.filter));
        if (!tmp.fids.isEmpty()) {
            data.filter = Filter.INCLUDE;
            data.fids.clear();
            this.requiresPostProcessing = true;
        }
        return data;
    }

    private Data createHighLevelLogicFilter(short filterType, int startOfFilterStack) throws IllegalFilterException {
        if (this.hasFidFilter(startOfFilterStack)) {
            switch (filterType) {
                case 2: {
                    Set<String> fids = this.andFids(startOfFilterStack);
                    Data filter = this.buildFilter(filterType, startOfFilterStack);
                    filter.fids.addAll(fids);
                    return filter;
                }
                case 1: {
                    if (this.hasNonFidFilter(startOfFilterStack)) {
                        throw new UnsupportedFilterException("Maximum compliance does not allow Logic filters to contain FidFilters");
                    }
                    Set<String> fids = this.orFids(startOfFilterStack);
                    this.pop(startOfFilterStack);
                    Data data = new Data();
                    data.fids.addAll(fids);
                    return data;
                }
                case 3: {
                    return this.buildFilter(filterType, startOfFilterStack);
                }
            }
            return Data.ALL;
        }
        return this.buildFilter(filterType, startOfFilterStack);
    }

    private void pop(int startOfFilterStack) {
        while (this.current.size() > startOfFilterStack) {
            this.current.pop();
        }
    }

    private boolean hasNonFidFilter(int startOfFilterStack) {
        for (int i = startOfFilterStack; i < this.current.size(); ++i) {
            Data data = (Data)this.current.get(i);
            if (data.filter == Filter.EXCLUDE) continue;
            return true;
        }
        return false;
    }

    private boolean hasFidFilter(int startOfFilterStack) {
        for (int i = startOfFilterStack; i < this.current.size(); ++i) {
            Data data = (Data)this.current.get(i);
            if (data.fids.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object visit(PropertyIsNull filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(PropertyIsNil filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(Id filter, Object extraData) {
        Data data = new Data();
        for (Identifier identifier : filter.getIdentifiers()) {
            FeatureId featureIdentifier = (FeatureId)identifier;
            data.fids.add(featureIdentifier.getID());
        }
        this.current.push(data);
        return extraData;
    }

    @Override
    public Object visit(IncludeFilter filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visit(ExcludeFilter filter, Object extraData) {
        this.current.push(new Data(filter));
        return extraData;
    }

    @Override
    public Object visitNullFilter(Object extraData) {
        return extraData;
    }

    @Override
    public Object visit(After after, Object extraData) {
        return this.visit((BinaryTemporalOperator)after, extraData);
    }

    @Override
    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.visit((BinaryTemporalOperator)anyInteracts, extraData);
    }

    @Override
    public Object visit(Before before, Object extraData) {
        return this.visit((BinaryTemporalOperator)before, extraData);
    }

    @Override
    public Object visit(Begins begins, Object extraData) {
        return this.visit((BinaryTemporalOperator)begins, extraData);
    }

    @Override
    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)begunBy, extraData);
    }

    @Override
    public Object visit(During during, Object extraData) {
        return this.visit((BinaryTemporalOperator)during, extraData);
    }

    @Override
    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)endedBy, extraData);
    }

    @Override
    public Object visit(Ends ends, Object extraData) {
        return this.visit((BinaryTemporalOperator)ends, extraData);
    }

    @Override
    public Object visit(Meets meets, Object extraData) {
        return this.visit((BinaryTemporalOperator)meets, extraData);
    }

    @Override
    public Object visit(MetBy metBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)metBy, extraData);
    }

    @Override
    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)overlappedBy, extraData);
    }

    @Override
    public Object visit(TContains contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, extraData);
    }

    @Override
    public Object visit(TEquals equals, Object extraData) {
        return this.visit((BinaryTemporalOperator)equals, extraData);
    }

    @Override
    public Object visit(TOverlaps contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, extraData);
    }

    protected Object visit(BinaryTemporalOperator filter, Object data) {
        this.current.push(new Data(filter));
        return data;
    }

    public boolean requiresPostProcessing() {
        return this.requiresPostProcessing;
    }

    @Override
    public Object visit(NativeFilter nativeFilter, Object extraData) {
        throw new UnsupportedOperationException("XML encoding of native filters is not supported.");
    }

    private static class Data {
        public static final Data NONE = new Data(Filter.EXCLUDE);
        public static final Data ALL = new Data(Filter.INCLUDE);
        final Set<String> fids = new HashSet<String>();
        Filter filter;

        public Data() {
            this(Filter.EXCLUDE);
        }

        public Data(Filter f) {
            this.filter = f;
        }

        public String toString() {
            return this.filter + ":" + this.fids;
        }
    }
}

