/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Transformation;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;

public class WarpTransform2DProvider
extends MathTransformProvider {
    private static final long serialVersionUID = -7949539694656719923L;
    public static final ParameterDescriptor<Integer> DEGREE = DefaultParameterDescriptor.create("degree", 2, 1, 7);
    public static final ParameterDescriptor<?> X_COEFFS = new DefaultParameterDescriptor<Object>("xCoeffs", float[].class, null, null);
    public static final ParameterDescriptor<?> Y_COEFFS = new DefaultParameterDescriptor<Object>("yCoeffs", float[].class, null, null);
    public static final ParameterDescriptor<Float> PRE_SCALE_X;
    public static final ParameterDescriptor<Float> PRE_SCALE_Y;
    public static final ParameterDescriptor<Float> POST_SCALE_X;
    public static final ParameterDescriptor<Float> POST_SCALE_Y;
    static final ParameterDescriptorGroup PARAMETERS;

    public WarpTransform2DProvider() {
        super(2, 2, PARAMETERS);
    }

    public Class<Transformation> getOperationType() {
        return Transformation.class;
    }

    @Override
    protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException {
        int degree = WarpTransform2DProvider.intValue(DEGREE, values);
        float[] xCoeffs = (float[])WarpTransform2DProvider.value(X_COEFFS, values);
        float[] yCoeffs = (float[])WarpTransform2DProvider.value(Y_COEFFS, values);
        float preScaleX = WarpTransform2DProvider.scale(PRE_SCALE_X, values);
        float preScaleY = WarpTransform2DProvider.scale(PRE_SCALE_Y, values);
        float postScaleX = WarpTransform2DProvider.scale(POST_SCALE_X, values);
        float postScaleY = WarpTransform2DProvider.scale(POST_SCALE_Y, values);
        try {
            Object warp;
            switch (degree) {
                case 1: {
                    warp = this.createWarp("javax.media.jai.WarpAffine", xCoeffs, yCoeffs, preScaleX, preScaleY, postScaleX, postScaleY);
                    break;
                }
                case 2: {
                    warp = this.createWarp("javax.media.jai.WarpQuadratic", xCoeffs, yCoeffs, preScaleX, preScaleY, postScaleX, postScaleY);
                    break;
                }
                case 3: {
                    warp = this.createWarp("javax.media.jai.WarpCubic", xCoeffs, yCoeffs, preScaleX, preScaleY, postScaleX, postScaleY);
                    break;
                }
                default: {
                    warp = this.createWarp("javax.media.jai.WarpGeneralPolynomial", xCoeffs, yCoeffs, preScaleX, preScaleY, postScaleX, postScaleY);
                }
            }
            Class<?> transformClass = Class.forName("org.geotools.referencing.operation.transform.WarpTransform2D");
            Class<?> warpClass = Class.forName("javax.media.jai.Warp");
            Constructor<?> createTransform = transformClass.getConstructor(warpClass, warpClass);
            return (MathTransform)createTransform.newInstance(warp, null);
        }
        catch (Exception jaiUnavailable) {
            throw new UnsupportedOperationException("WarpTransform2D requires Java Advanced Imaging extension");
        }
    }

    private Object createWarp(String warpName, float[] xCoeffs, float[] yCoeffs, float preScaleX, float preScaleY, float postScaleX, float postScaleY) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> warpClass = Class.forName(warpName);
        Class[] params = new Class[]{float[].class, float[].class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE};
        Constructor<?> constrctor = warpClass.getConstructor(params);
        return constrctor.newInstance(xCoeffs, yCoeffs, Float.valueOf(preScaleX), Float.valueOf(preScaleY), Float.valueOf(postScaleX), Float.valueOf(postScaleY));
    }

    private static float scale(ParameterDescriptor<Float> param, ParameterValueGroup group) throws ParameterNotFoundException {
        Float value = WarpTransform2DProvider.value(param, group);
        return value != null ? ((Number)value).floatValue() : 1.0f;
    }

    static {
        Float ONE = Float.valueOf(1.0f);
        PRE_SCALE_X = DefaultParameterDescriptor.create("preScaleX", null, Float.class, ONE, false);
        PRE_SCALE_Y = DefaultParameterDescriptor.create("preScaleY", null, Float.class, ONE, false);
        POST_SCALE_X = DefaultParameterDescriptor.create("postScaleX", null, Float.class, ONE, false);
        POST_SCALE_Y = DefaultParameterDescriptor.create("postScaleY", null, Float.class, ONE, false);
        PARAMETERS = WarpTransform2DProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "WarpPolynomial")}, new ParameterDescriptor[]{DEGREE, X_COEFFS, Y_COEFFS, PRE_SCALE_X, PRE_SCALE_Y, POST_SCALE_X, POST_SCALE_Y});
    }
}

