/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.EngineeringCRS;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.datum.DefaultEngineeringDatum;
import org.geotools.referencing.factory.DirectAuthorityFactory;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.Hints;

public class CartesianAuthorityFactory
extends DirectAuthorityFactory
implements CRSAuthorityFactory {
    public static final String GENERIC_2D_CODE = "404000";
    public static final DefaultEngineeringCRS GENERIC_2D = new DefaultEngineeringCRS(CartesianAuthorityFactory.buildProperties("Wildcard 2D cartesian plane in metric unit", Citations.EPSG, "404000"), DefaultEngineeringDatum.UNKNOWN, DefaultCartesianCS.GENERIC_2D, true);

    static Map<String, ?> buildProperties(String name, Citation authority, String code) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", name);
        props.put("identifiers", new NamedIdentifier(authority, code));
        return props;
    }

    public CartesianAuthorityFactory() {
        this(null);
    }

    public CartesianAuthorityFactory(Hints hints) {
        super(hints, 80);
    }

    @Override
    public Citation getAuthority() {
        return Citations.EPSG;
    }

    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        if (type.isAssignableFrom(EngineeringCRS.class)) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            set.add(GENERIC_2D_CODE);
            return set;
        }
        return Collections.emptySet();
    }

    @Override
    public InternationalString getDescriptionText(String code) throws NoSuchAuthorityCodeException, FactoryException {
        if (code.equals("EPSG:404000")) {
            return new SimpleInternationalString("A two-dimensional wildcard coordinate system with X,Y axis in meters");
        }
        throw this.noSuchAuthorityException(code);
    }

    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.createCoordinateReferenceSystem(code);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        return this.createEngineeringCRS(code);
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        if (GENERIC_2D_CODE.equals(code) || "EPSG:404000".equals(code)) {
            return GENERIC_2D;
        }
        throw this.noSuchAuthorityException(code);
    }

    private NoSuchAuthorityCodeException noSuchAuthorityException(String code) throws NoSuchAuthorityCodeException {
        String authority = "EPSG";
        return new NoSuchAuthorityCodeException(MessageFormat.format("No code \"{0}\" from authority \"{1}\" found for object of type \"{2}\".", code, authority, EngineeringCRS.class), authority, code);
    }
}

