/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.geotools.api.metadata.Identifier;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.datum.DatumFactory;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.EngineeringDatum;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.datum.ImageDatum;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.datum.PrimeMeridian;
import org.geotools.api.referencing.datum.TemporalDatum;
import org.geotools.api.referencing.datum.VerticalDatum;
import org.geotools.api.referencing.datum.VerticalDatumType;
import org.geotools.api.util.GenericName;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.util.LocalName;
import org.geotools.util.NameFactory;
import org.geotools.util.ScopedName;
import org.geotools.util.XArray;

public class DatumAliases
extends ReferencingFactory
implements DatumFactory {
    private static final String ALIAS_TABLE = "DatumAliasesTable.txt";
    private static final String SEPARATORS = ";";
    private static final Object[] NEED_LOADING = new Object[0];
    private final URL aliasURL;
    private final Map<String, Object[]> aliasMap = new HashMap<String, Object[]>();
    private LocalName[] authorities;
    private DatumFactory factory;

    public DatumAliases() {
        super(60);
        this.aliasURL = DatumAliases.class.getResource(ALIAS_TABLE);
        if (this.aliasURL == null) {
            throw new NoSuchElementException(ALIAS_TABLE);
        }
    }

    public DatumAliases(DatumFactory factory) {
        this();
        this.factory = factory;
        DatumAliases.ensureNonNull("factory", factory);
    }

    public DatumAliases(DatumFactory factory, URL aliasURL) {
        super(60);
        this.factory = factory;
        this.aliasURL = aliasURL;
        DatumAliases.ensureNonNull("factory", factory);
        DatumAliases.ensureNonNull("aliasURL", aliasURL);
    }

    private DatumFactory getDatumFactory() throws NoSuchElementException {
        assert (Thread.holdsLock(this));
        if (this.factory == null) {
            DatumFactory candidate;
            Iterator<DatumFactory> it = ReferencingFactoryFinder.getDatumFactories(null).iterator();
            while ((candidate = it.next()) == this) {
            }
            this.factory = candidate;
        }
        return this.factory;
    }

    private static String toCaseless(String key) {
        return key.replace('_', ' ').trim().toLowerCase();
    }

    private static String readLine(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null && ((line = line.trim()).length() == 0 || line.charAt(0) == '#')) {
        }
        return line;
    }

    private void reload() throws IOException {
        assert (Thread.holdsLock(this));
        LogRecord record = Loggings.format(Level.FINE, 27, this.aliasURL);
        record.setLoggerName(LOGGER.getName());
        LOGGER.log(record);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.aliasURL.openStream()));){
            String line = DatumAliases.readLine(in);
            if (line != null) {
                ArrayList<Object> elements = new ArrayList<Object>();
                StringTokenizer st = new StringTokenizer(line, SEPARATORS);
                while (st.hasMoreTokens()) {
                    String name = st.nextToken().trim();
                    elements.add(name.length() != 0 ? new LocalName(name) : null);
                }
                this.authorities = elements.toArray(new LocalName[elements.size()]);
                HashMap<String, String> canonical = new HashMap<String, String>();
                while ((line = DatumAliases.readLine(in)) != null) {
                    Object[] names;
                    elements.clear();
                    canonical.clear();
                    st = new StringTokenizer(line, SEPARATORS);
                    while (st.hasMoreTokens()) {
                        String alias = st.nextToken().trim();
                        if (alias.length() != 0) {
                            String previous = canonical.put(alias, alias);
                            if (previous != null) {
                                canonical.put(previous, previous);
                                alias = previous;
                            }
                        } else {
                            alias = null;
                        }
                        elements.add(alias);
                    }
                    int i = elements.size();
                    while (--i >= 0 && elements.get(i) == null) {
                        elements.remove(i);
                    }
                    if (elements.isEmpty()) continue;
                    for (String string : names = elements.toArray(new String[elements.size()])) {
                        String key = DatumAliases.toCaseless(string);
                        Object[] previous = this.aliasMap.put(key, names);
                        if (previous == null || previous == NEED_LOADING) continue;
                        if (previous instanceof GenericName[]) {
                            this.aliasMap.put(key, previous);
                            continue;
                        }
                        if (Arrays.equals(previous, names)) continue;
                        LOGGER.warning("Inconsistent aliases for datum \"" + string + "\".");
                    }
                }
            }
        }
    }

    private void log(IOException exception) {
        LogRecord record = Loggings.format(Level.WARNING, 9, this.aliasURL);
        record.setSourceClassName(DatumAliases.class.getName());
        record.setSourceMethodName("reload");
        record.setThrown(exception);
        record.setLoggerName(LOGGER.getName());
        LOGGER.log(record);
    }

    private GenericName[] getAliases(String name) {
        CharSequence alias;
        Object[] aliases;
        assert (Thread.holdsLock(this));
        if (this.aliasMap.isEmpty()) {
            try {
                this.reload();
            }
            catch (IOException exception) {
                this.log(exception);
            }
        }
        if ((aliases = this.aliasMap.get(name = DatumAliases.toCaseless(name))) == null) {
            return null;
        }
        if (aliases == NEED_LOADING) {
            try {
                this.reload();
            }
            catch (IOException exception) {
                this.log(exception);
            }
            aliases = this.aliasMap.get(name);
            if (aliases == NEED_LOADING) {
                return null;
            }
        }
        if (aliases instanceof GenericName[]) {
            return (GenericName[])aliases;
        }
        int count = 0;
        GenericName[] names = new GenericName[aliases.length];
        for (Object o : aliases) {
            LocalName authority;
            alias = (CharSequence)o;
            if (alias == null) continue;
            names[count++] = count < this.authorities.length && (authority = this.authorities[count]) != null ? new ScopedName(authority, alias) : new LocalName(alias);
        }
        names = XArray.resize(names, count);
        for (GenericName genericName : names) {
            alias = genericName.tip().toString();
            Object[] previous = this.aliasMap.put(DatumAliases.toCaseless((String)alias), names);
            assert (previous == names || Arrays.equals(aliases, previous)) : alias;
        }
        return names;
    }

    private Map<String, ?> addAliases(Map<String, ?> properties) {
        DatumAliases.ensureNonNull("properties", properties);
        Object value = properties.get("name");
        DatumAliases.ensureNonNull("name", value);
        String name = value instanceof Identifier ? ((Identifier)value).getCode() : value.toString();
        GenericName[] aliases = this.getAliases(name);
        if (aliases != null) {
            int count = aliases.length;
            value = properties.get("alias");
            if (value != null) {
                LinkedHashMap<String, GenericName> merged = new LinkedHashMap<String, GenericName>();
                DatumAliases.putAll(NameFactory.toArray(value), merged);
                count -= DatumAliases.putAll(aliases, merged);
                Collection c = merged.values();
                aliases = c.toArray(new GenericName[c.size()]);
            }
            if (count > 0) {
                HashMap copy = new HashMap(properties);
                copy.put("alias", aliases);
                properties = copy;
            }
        }
        return properties;
    }

    private static final int putAll(GenericName[] names, Map<String, GenericName> map) {
        int ignored = 0;
        for (GenericName name : names) {
            GenericName scoped = name.toFullyQualifiedName();
            String key = DatumAliases.toCaseless(scoped.toString());
            GenericName old = map.put(key, name);
            if (!(old instanceof org.geotools.api.util.ScopedName)) continue;
            map.put(key, old);
            ++ignored;
        }
        return ignored;
    }

    @Override
    public synchronized EngineeringDatum createEngineeringDatum(Map<String, ?> properties) throws FactoryException {
        return this.getDatumFactory().createEngineeringDatum(this.addAliases(properties));
    }

    @Override
    public synchronized GeodeticDatum createGeodeticDatum(Map<String, ?> properties, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) throws FactoryException {
        return this.getDatumFactory().createGeodeticDatum(this.addAliases(properties), ellipsoid, primeMeridian);
    }

    @Override
    public synchronized ImageDatum createImageDatum(Map<String, ?> properties, PixelInCell pixelInCell) throws FactoryException {
        return this.getDatumFactory().createImageDatum(this.addAliases(properties), pixelInCell);
    }

    @Override
    public synchronized TemporalDatum createTemporalDatum(Map<String, ?> properties, Date origin) throws FactoryException {
        return this.getDatumFactory().createTemporalDatum(this.addAliases(properties), origin);
    }

    @Override
    public synchronized VerticalDatum createVerticalDatum(Map<String, ?> properties, VerticalDatumType type) throws FactoryException {
        return this.getDatumFactory().createVerticalDatum(this.addAliases(properties), type);
    }

    @Override
    public synchronized Ellipsoid createEllipsoid(Map<String, ?> properties, double semiMajorAxis, double semiMinorAxis, Unit<Length> unit) throws FactoryException {
        return this.getDatumFactory().createEllipsoid(this.addAliases(properties), semiMajorAxis, semiMinorAxis, unit);
    }

    @Override
    public synchronized Ellipsoid createFlattenedSphere(Map<String, ?> properties, double semiMajorAxis, double inverseFlattening, Unit<Length> unit) throws FactoryException {
        return this.getDatumFactory().createFlattenedSphere(this.addAliases(properties), semiMajorAxis, inverseFlattening, unit);
    }

    @Override
    public synchronized PrimeMeridian createPrimeMeridian(Map<String, ?> properties, double longitude, Unit<Angle> angularUnit) throws FactoryException {
        return this.getDatumFactory().createPrimeMeridian(this.addAliases(properties), longitude, angularUnit);
    }

    public synchronized void freeUnused() {
        if (this.aliasMap != null) {
            for (Map.Entry<String, Object[]> entry : this.aliasMap.entrySet()) {
                Object[] value = entry.getValue();
                if (value instanceof GenericName[]) continue;
                entry.setValue(NEED_LOADING);
            }
        }
    }
}

