/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import javax.measure.Unit;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.metadata.extent.Extent;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.DerivedCRS;
import org.geotools.api.referencing.crs.EngineeringCRS;
import org.geotools.api.referencing.crs.GeocentricCRS;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ImageCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.crs.TemporalCRS;
import org.geotools.api.referencing.crs.VerticalCRS;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.CylindricalCS;
import org.geotools.api.referencing.cs.EllipsoidalCS;
import org.geotools.api.referencing.cs.PolarCS;
import org.geotools.api.referencing.cs.SphericalCS;
import org.geotools.api.referencing.cs.TimeCS;
import org.geotools.api.referencing.cs.VerticalCS;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.EngineeringDatum;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.datum.ImageDatum;
import org.geotools.api.referencing.datum.PrimeMeridian;
import org.geotools.api.referencing.datum.TemporalDatum;
import org.geotools.api.referencing.datum.VerticalDatum;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.OperationMethod;
import org.geotools.api.util.GenericName;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.util.NameFactory;

public abstract class AbstractAuthorityFactory
extends ReferencingFactory
implements AuthorityFactory {
    protected AbstractAuthorityFactory(int priority) {
        super(priority);
    }

    boolean isAvailable() {
        return true;
    }

    boolean sameAuthorityCodes(AuthorityFactory factory) {
        return factory == this;
    }

    @Override
    public abstract Citation getAuthority();

    public String getBackingStoreDescription() throws FactoryException {
        return null;
    }

    @Override
    public IdentifiedObject createObject(String code) throws NoSuchAuthorityCodeException, FactoryException {
        AbstractAuthorityFactory.ensureNonNull("code", code);
        throw this.noSuchAuthorityCode(IdentifiedObject.class, code);
    }

    public Datum createDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (Datum)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(Datum.class, code, exception);
        }
    }

    public EngineeringDatum createEngineeringDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (EngineeringDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(EngineeringDatum.class, code, exception);
        }
    }

    public ImageDatum createImageDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (ImageDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ImageDatum.class, code, exception);
        }
    }

    public VerticalDatum createVerticalDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (VerticalDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(VerticalDatum.class, code, exception);
        }
    }

    public TemporalDatum createTemporalDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (TemporalDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(TemporalDatum.class, code, exception);
        }
    }

    public GeodeticDatum createGeodeticDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (GeodeticDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(GeodeticDatum.class, code, exception);
        }
    }

    public Ellipsoid createEllipsoid(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (Ellipsoid)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(Ellipsoid.class, code, exception);
        }
    }

    public PrimeMeridian createPrimeMeridian(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (PrimeMeridian)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(PrimeMeridian.class, code, exception);
        }
    }

    public Extent createExtent(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (Extent)((Object)object);
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(Extent.class, code, exception);
        }
    }

    public CoordinateSystem createCoordinateSystem(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (CoordinateSystem)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CoordinateSystem.class, code, exception);
        }
    }

    public CartesianCS createCartesianCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (CartesianCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CartesianCS.class, code, exception);
        }
    }

    public PolarCS createPolarCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (PolarCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(PolarCS.class, code, exception);
        }
    }

    public CylindricalCS createCylindricalCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (CylindricalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CylindricalCS.class, code, exception);
        }
    }

    public SphericalCS createSphericalCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (SphericalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(SphericalCS.class, code, exception);
        }
    }

    public EllipsoidalCS createEllipsoidalCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (EllipsoidalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(EllipsoidalCS.class, code, exception);
        }
    }

    public VerticalCS createVerticalCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (VerticalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(VerticalCS.class, code, exception);
        }
    }

    public TimeCS createTimeCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (TimeCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(TimeCS.class, code, exception);
        }
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (CoordinateSystemAxis)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CoordinateSystemAxis.class, code, exception);
        }
    }

    public Unit<?> createUnit(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (Unit)((Object)object);
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(Unit.class, code, exception);
        }
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (CoordinateReferenceSystem)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, code, exception);
        }
    }

    public CompoundCRS createCompoundCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (CompoundCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CompoundCRS.class, code, exception);
        }
    }

    public DerivedCRS createDerivedCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (DerivedCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(DerivedCRS.class, code, exception);
        }
    }

    public EngineeringCRS createEngineeringCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (EngineeringCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(EngineeringCRS.class, code, exception);
        }
    }

    public GeographicCRS createGeographicCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (GeographicCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(GeographicCRS.class, code, exception);
        }
    }

    public GeocentricCRS createGeocentricCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (GeocentricCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(GeocentricCRS.class, code, exception);
        }
    }

    public ImageCRS createImageCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (ImageCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ImageCRS.class, code, exception);
        }
    }

    public ProjectedCRS createProjectedCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (ProjectedCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ProjectedCRS.class, code, exception);
        }
    }

    public TemporalCRS createTemporalCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (TemporalCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(TemporalCRS.class, code, exception);
        }
    }

    public VerticalCRS createVerticalCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (VerticalCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(VerticalCRS.class, code, exception);
        }
    }

    public ParameterDescriptor createParameterDescriptor(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject operation = this.createObject(code);
        try {
            return (ParameterDescriptor)operation;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ParameterDescriptor.class, code, exception);
        }
    }

    public OperationMethod createOperationMethod(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject operation = this.createObject(code);
        try {
            return (OperationMethod)operation;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(OperationMethod.class, code, exception);
        }
    }

    public CoordinateOperation createCoordinateOperation(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject operation = this.createObject(code);
        try {
            return (CoordinateOperation)operation;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CoordinateOperation.class, code, exception);
        }
    }

    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS) throws NoSuchAuthorityCodeException, FactoryException {
        return Collections.emptySet();
    }

    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> type) throws FactoryException {
        return new IdentifiedObjectFinder(this, type);
    }

    public void dispose() throws FactoryException {
    }

    private NoSuchAuthorityCodeException noSuchAuthorityCode(Class type, String code, ClassCastException cause) {
        NoSuchAuthorityCodeException exception = this.noSuchAuthorityCode(type, code);
        exception.initCause(cause);
        return exception;
    }

    protected String trimAuthority(String code) {
        GenericName name = NameFactory.create(code = code.trim());
        GenericName scope = name.scope().name();
        if (scope == null) {
            return code;
        }
        if (Citations.identifierMatches(this.getAuthority(), scope.toString())) {
            return name.tip().toString().trim();
        }
        return code;
    }

    protected final NoSuchAuthorityCodeException noSuchAuthorityCode(Class type, String code) {
        InternationalString authority = this.getAuthority().getTitle();
        return new NoSuchAuthorityCodeException(MessageFormat.format("No code \"{0}\" from authority \"{1}\" found for object of type \"{2}\".", code, authority, type), authority.toString(), code);
    }
}

