/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Map;
import javax.measure.IncommensurableException;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.EllipsoidalCS;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import si.uom.NonSI;
import si.uom.SI;

public class DefaultEllipsoidalCS
extends AbstractCS
implements EllipsoidalCS {
    private static final long serialVersionUID = -1452492488902329211L;
    public static DefaultEllipsoidalCS GEODETIC_2D = new DefaultEllipsoidalCS((Map<String, ?>)DefaultEllipsoidalCS.name(83), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE);
    public static DefaultEllipsoidalCS GEODETIC_3D = new DefaultEllipsoidalCS((Map<String, ?>)DefaultEllipsoidalCS.name(84), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);
    private transient int longitudeAxis;
    private transient int latitudeAxis;
    private transient int heightAxis;
    private transient UnitConverter longitudeConverter;
    private transient UnitConverter latitudeConverter;
    private transient UnitConverter heightConverter;

    public DefaultEllipsoidalCS(EllipsoidalCS cs) {
        super(cs);
    }

    public DefaultEllipsoidalCS(String name, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) {
        super(name, axis0, axis1);
    }

    public DefaultEllipsoidalCS(String name, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(name, axis0, axis1, axis2);
    }

    public DefaultEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) {
        super(properties, axis0, axis1);
    }

    public DefaultEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(properties, axis0, axis1, axis2);
    }

    private DefaultEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis ... axis) {
        super(properties, axis);
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection direction) {
        return AxisDirection.NORTH.equals(direction = direction.absolute()) || AxisDirection.EAST.equals(direction) || AxisDirection.UP.equals(direction);
    }

    @Override
    protected boolean isCompatibleUnit(AxisDirection direction, Unit<?> unit) {
        Unit<Angle> expected = AxisDirection.UP.equals(direction = direction.absolute()) ? SI.METRE : NonSI.DEGREE_ANGLE;
        return expected.isCompatible(unit);
    }

    private void update() {
        int i = this.getDimension();
        while (--i >= 0) {
            CoordinateSystemAxis axis = this.getAxis(i);
            AxisDirection direction = axis.getDirection().absolute();
            Unit<Angle> unit = axis.getUnit();
            try {
                if (AxisDirection.EAST.equals(direction)) {
                    this.longitudeAxis = i;
                    this.longitudeConverter = unit.getConverterToAny(NonSI.DEGREE_ANGLE);
                    continue;
                }
                if (AxisDirection.NORTH.equals(direction)) {
                    this.latitudeAxis = i;
                    this.latitudeConverter = unit.getConverterToAny(NonSI.DEGREE_ANGLE);
                    continue;
                }
                if (AxisDirection.UP.equals(direction)) {
                    this.heightAxis = i;
                    this.heightConverter = unit.getConverterToAny(SI.METRE);
                    continue;
                }
            }
            catch (IncommensurableException | UnconvertibleException e) {
                throw new MismatchedDimensionException("The axis unit is not convertible to the expected dimension", e);
            }
            throw new AssertionError(direction);
        }
    }

    public double getLongitude(double[] coordinates) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coordinates", coordinates);
        if (this.longitudeConverter == null) {
            this.update();
        }
        return this.longitudeConverter.convert(coordinates[this.longitudeAxis]);
    }

    public double getLatitude(double[] coordinates) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coordinates", coordinates);
        if (this.latitudeConverter == null) {
            this.update();
        }
        return this.latitudeConverter.convert(coordinates[this.latitudeAxis]);
    }

    public double getHeight(double[] coordinates) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coordinates", coordinates);
        if (this.heightConverter == null) {
            this.update();
            if (this.heightConverter == null) {
                throw new IllegalStateException("Not a 3D coordinate system.");
            }
        }
        return this.heightConverter.convert(coordinates[this.heightAxis]);
    }

    public DefaultEllipsoidalCS usingUnit(Unit<?> unit) throws IllegalArgumentException {
        CoordinateSystemAxis[] axis = this.axisUsingUnit(unit);
        if (axis == null) {
            return this;
        }
        return new DefaultEllipsoidalCS(DefaultEllipsoidalCS.getProperties(this, null), axis);
    }
}

