/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.api.metadata.Identifier;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.parameter.InvalidParameterValueException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.util.GenericName;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.NameSpace;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.util.GrowableInternationalString;
import org.geotools.util.LocalName;
import org.geotools.util.ScopedName;
import org.geotools.util.Utilities;
import org.geotools.util.WeakValueHashMap;
import org.geotools.util.logging.Logging;

public class NamedIdentifier
implements ReferenceIdentifier,
GenericName,
Comparable<GenericName>,
Serializable {
    private static final long serialVersionUID = 8474731565582774497L;
    private static Map<CharSequence, GenericName> SCOPES;
    private final String code;
    private final String codespace;
    private final Citation authority;
    private final String version;
    private final InternationalString remarks;
    private GenericName name;

    public NamedIdentifier(Map<String, ?> properties) throws IllegalArgumentException {
        this(properties, true);
    }

    public NamedIdentifier(Citation authority, InternationalString code) {
        this(authority, code.toString(null));
        this.name = this.getName(authority, code);
    }

    public NamedIdentifier(Citation authority, String code) {
        this(authority, code, null);
    }

    public NamedIdentifier(Citation authority, String code, String version) {
        this(NamedIdentifier.toMap(authority, code, version));
    }

    private static Map<String, ?> toMap(Citation authority, String code, String version) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        if (authority != null) {
            properties.put("authority", authority);
        }
        if (code != null) {
            properties.put("code", code);
        }
        if (version != null) {
            properties.put("version", version);
        }
        return properties;
    }

    NamedIdentifier(Map<String, ?> properties, boolean standalone) throws IllegalArgumentException {
        NamedIdentifier.ensureNonNull("properties", properties);
        Object code = null;
        String codespace = null;
        Object version = null;
        Object authority = null;
        Object remarks = null;
        GrowableInternationalString growable = null;
        String key = null;
        Object value = null;
        block10: for (Map.Entry<String, ?> entry : properties.entrySet()) {
            key = entry.getKey().trim().toLowerCase();
            value = entry.getValue();
            switch (key.hashCode()) {
                case 3373707: {
                    if (standalone || !key.equals("name")) break;
                    code = value;
                    continue block10;
                }
                case 3059181: {
                    if (!key.equals("code")) break;
                    code = value;
                    continue block10;
                }
                case -1108676807: {
                    if (!key.equals("codespace")) break;
                    codespace = value;
                    continue block10;
                }
                case 351608024: {
                    if (!key.equals("version")) break;
                    version = value;
                    continue block10;
                }
                case 1475610435: {
                    if (!key.equals("authority")) break;
                    if (value instanceof String) {
                        value = Citations.fromName(value.toString());
                    }
                    authority = value;
                    continue block10;
                }
                case 1091415283: {
                    if (!standalone || !key.equals("remarks") || !(value instanceof InternationalString)) break;
                    remarks = value;
                    continue block10;
                }
            }
            if (!standalone || !(value instanceof String)) continue;
            if (growable == null) {
                growable = remarks instanceof GrowableInternationalString ? (GrowableInternationalString)remarks : new GrowableInternationalString();
            }
            growable.add("remarks", key, value.toString());
        }
        if (growable != null && !growable.getLocales().isEmpty()) {
            if (remarks == null) {
                remarks = growable;
            } else {
                Logger logger = Logging.getLogger(NamedIdentifier.class);
                LogRecord record = Loggings.format(Level.WARNING, 28);
                record.setLoggerName(logger.getName());
                logger.log(record);
            }
        }
        if (codespace == null && authority instanceof Citation) {
            codespace = NamedIdentifier.getCodeSpace((Citation)authority);
        }
        try {
            key = "code";
            value = code;
            this.code = (String)value;
            key = "version";
            value = version;
            this.version = (String)value;
            key = "codespace";
            value = codespace;
            this.codespace = value;
            key = "authority";
            value = authority;
            this.authority = (Citation)value;
            key = "remarks";
            value = remarks;
            this.remarks = (InternationalString)value;
        }
        catch (ClassCastException exception) {
            InvalidParameterValueException e = new InvalidParameterValueException(MessageFormat.format("Illegal argument: \"{0}={1}\".", key, value), key, value);
            e.initCause(exception);
            throw e;
        }
        NamedIdentifier.ensureNonNull("code", code);
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new InvalidParameterValueException(MessageFormat.format("Argument \"{0}\" should not be null.", name), name, object);
        }
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getCodeSpace() {
        return this.codespace;
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public InternationalString getRemarks() {
        return this.remarks;
    }

    private synchronized GenericName getName() {
        if (this.name == null) {
            this.name = this.getName(this.authority, this.code);
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericName getName(Citation authority, CharSequence code) {
        if (authority == null) {
            return new LocalName(code);
        }
        CharSequence title = this.codespace != null ? this.codespace : NamedIdentifier.getShortestTitle(authority);
        Class<NamedIdentifier> clazz = NamedIdentifier.class;
        synchronized (NamedIdentifier.class) {
            GenericName scope;
            if (SCOPES == null) {
                SCOPES = new WeakValueHashMap<CharSequence, GenericName>();
            }
            if ((scope = SCOPES.get(title)) == null) {
                scope = new LocalName(title);
                SCOPES.put(title, scope);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return new ScopedName(scope, code);
        }
    }

    private static InternationalString getShortestTitle(Citation authority) {
        InternationalString title = authority.getTitle();
        int length = title.length();
        Collection<? extends InternationalString> alt = authority.getAlternateTitles();
        if (alt != null) {
            for (InternationalString internationalString : alt) {
                int candidateLength = internationalString.length();
                if (candidateLength <= 0 || candidateLength >= length) continue;
                title = internationalString;
                length = candidateLength;
            }
        }
        return title;
    }

    private static String getCodeSpace(Citation authority) {
        String title;
        Collection<? extends Identifier> identifiers = authority.getIdentifiers();
        if (identifiers != null) {
            for (Identifier identifier : identifiers) {
                String identifier2 = identifier.getCode();
                if (!NamedIdentifier.isValidCodeSpace(identifier2)) continue;
                return identifier2;
            }
        }
        if (NamedIdentifier.isValidCodeSpace(title = NamedIdentifier.getShortestTitle(authority).toString(null))) {
            return title;
        }
        return null;
    }

    private static boolean isValidCodeSpace(String codespace) {
        if (codespace == null) {
            return false;
        }
        int i = codespace.length();
        while (--i >= 0) {
            if (Character.isJavaIdentifierPart(codespace.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public org.geotools.api.util.LocalName head() {
        return this.getName().head();
    }

    @Override
    public org.geotools.api.util.LocalName tip() {
        return this.getName().tip();
    }

    @Override
    public NameSpace scope() {
        return this.getName().scope();
    }

    @Override
    public int depth() {
        return this.getName().depth();
    }

    public List<org.geotools.api.util.LocalName> getParsedNames() {
        return this.getName().getParsedNames();
    }

    @Override
    public org.geotools.api.util.ScopedName push(GenericName scope) {
        return this.getName().push(scope);
    }

    @Override
    public GenericName toFullyQualifiedName() {
        return this.getName().toFullyQualifiedName();
    }

    @Override
    public InternationalString toInternationalString() {
        return this.getName().toInternationalString();
    }

    @Override
    public String toString() {
        return this.getName().toString();
    }

    @Override
    public int compareTo(GenericName object) {
        return this.getName().compareTo(object);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            NamedIdentifier that = (NamedIdentifier)object;
            return Utilities.equals(this.code, that.code) && Utilities.equals(this.codespace, that.codespace) && Utilities.equals(this.version, that.version) && Utilities.equals(this.authority, that.authority) && Utilities.equals(this.remarks, that.remarks);
        }
        return false;
    }

    public int hashCode() {
        int hash = 895086817;
        if (this.code != null) {
            hash ^= this.code.hashCode();
        }
        if (this.version != null) {
            hash = hash * 37 + this.version.hashCode();
        }
        return hash;
    }
}

