/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio;

import java.io.Serializable;
import org.geotools.util.Utilities;

public class Identification
implements CharSequence,
Serializable {
    private static final long serialVersionUID = 7439545624472885445L;
    private final String name;
    private final String remarks;
    private final String alias;
    private final String identifier;

    public Identification(String name, String remarks, String alias, String identifier) {
        this.name = name;
        this.remarks = remarks;
        this.alias = alias;
        this.identifier = identifier;
    }

    public Identification(String name) {
        this.name = name;
        this.remarks = null;
        this.alias = null;
        this.identifier = null;
    }

    @Override
    public int length() {
        return this.name != null ? this.name.length() : 0;
    }

    @Override
    public char charAt(int index) {
        return this.name.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        return new Identification(this.name.substring(start, end), this.remarks, this.alias, this.identifier);
    }

    public int hashCode() {
        int code = 1023711429;
        if (this.name != null) {
            code ^= this.name.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            Identification that = (Identification)object;
            return Utilities.equals(this.name, that.name) && Utilities.equals(this.remarks, that.remarks) && Utilities.equals(this.alias, that.alias) && Utilities.equals(this.identifier, that.identifier);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ").append(this.name);
        if (this.alias != null) {
            sb.append("\n Alias: ").append(this.alias);
        }
        if (this.identifier != null) {
            sb.append("\n Identifier: ").append(this.identifier);
        }
        if (this.remarks != null) {
            sb.append("\n Remarks: ").append(this.remarks);
        }
        return sb.toString();
    }
}

