/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.simple;

import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.PolygonEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xsd.Encoder;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.xml.sax.helpers.AttributesImpl;

class MultiPolygonEncoder
extends GeometryEncoder<MultiPolygon> {
    static final QualifiedName MULTI_POLYGON = new QualifiedName("http://www.opengis.net/gml", "MultiPolygon", "gml");
    static final QualifiedName POLYGON_MEMBER = new QualifiedName("http://www.opengis.net/gml", "polygonMember", "gml");
    QualifiedName multiPolygon;
    QualifiedName polygonMember;
    PolygonEncoder pe;

    protected MultiPolygonEncoder(Encoder encoder, String gmlPrefix) {
        super(encoder);
        this.pe = new PolygonEncoder(encoder, gmlPrefix);
        this.multiPolygon = MULTI_POLYGON.derive(gmlPrefix);
        this.polygonMember = POLYGON_MEMBER.derive(gmlPrefix);
    }

    @Override
    public void encode(MultiPolygon geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(this.multiPolygon, atts);
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            handler.startElement(this.polygonMember, null);
            this.pe.encode((Polygon)geometry.getGeometryN(i), (AttributesImpl)null, handler);
            handler.endElement(this.polygonMember);
        }
        handler.endElement(this.multiPolygon);
    }
}

