/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.geometry.jts.JTS;
import org.geotools.gml2.GML;
import org.geotools.gml2.bindings.GMLUtil;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;

public class GMLLinearRingTypeBinding
extends AbstractComplexBinding {
    CoordinateSequenceFactory csFactory;
    GeometryFactory gFactory;

    public GMLLinearRingTypeBinding(CoordinateSequenceFactory csFactory, GeometryFactory gFactory) {
        this.csFactory = csFactory;
        this.gFactory = gFactory;
    }

    @Override
    public QName getTarget() {
        return GML.LinearRingType;
    }

    @Override
    public int getExecutionMode() {
        return 1;
    }

    public Class getType() {
        return LinearRing.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List<Node> coordinates = node.getChildren("coord");
        if (!coordinates.isEmpty() && coordinates.size() < 4) {
            throw new RuntimeException("LinearRing must have at least 4 coordinates");
        }
        if (!coordinates.isEmpty()) {
            Node cnode = coordinates.get(0);
            CoordinateSequence seq = (CoordinateSequence)cnode.getValue();
            int dimension = GMLUtil.getDimension(seq);
            CoordinateSequence lineSeq = seq = JTS.createCS(this.csFactory, coordinates.size(), dimension);
            for (int i = 0; i < coordinates.size(); ++i) {
                cnode = coordinates.get(i);
                seq = (CoordinateSequence)cnode.getValue();
                for (int j = 0; j < dimension; ++j) {
                    lineSeq.setOrdinate(i, j, seq.getOrdinate(0, j));
                }
            }
            return this.gFactory.createLinearRing(lineSeq);
        }
        if (node.getChild("coordinates") != null) {
            Node cnode = node.getChild("coordinates");
            CoordinateSequence lineSeq = (CoordinateSequence)cnode.getValue();
            return this.gFactory.createLinearRing(lineSeq);
        }
        throw new RuntimeException("Could not find coordinates to build linestring");
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        LinearRing linearRing = (LinearRing)object;
        if (GML.coordinates.equals(name)) {
            return linearRing.getCoordinateSequence();
        }
        return null;
    }
}

