/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.coordinatesequence;

import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.CoordinateSequenceTransformer;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

public class InPlaceCoordinateSequenceTransformer
implements CoordinateSequenceTransformer {
    FlyWeightDirectPosition start = new FlyWeightDirectPosition(2);

    @Override
    public CoordinateSequence transform(CoordinateSequence cs, MathTransform transform) throws TransformException {
        if (cs instanceof PackedCoordinateSequence) {
            return this.transformInternal((PackedCoordinateSequence)cs, transform);
        }
        throw new TransformException(cs.getClass().getName() + " is not a implementation that is known to be transformable in place");
    }

    private CoordinateSequence transformInternal(PackedCoordinateSequence sequence, MathTransform transform) throws TransformException {
        this.start.setSequence(sequence);
        for (int i = 0; i < sequence.size(); ++i) {
            this.start.setOffset(i);
            try {
                transform.transform(this.start, this.start);
                continue;
            }
            catch (MismatchedDimensionException e) {
                throw new TransformException("", e);
            }
        }
        return sequence;
    }

    private class FlyWeightDirectPosition
    implements Position {
        PackedCoordinateSequence sequence;
        int offset = 0;
        private int dimension;

        public FlyWeightDirectPosition(int dim) {
            this.dimension = dim;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public void setSequence(PackedCoordinateSequence sequence) {
            this.sequence = sequence;
        }

        @Override
        public int getDimension() {
            return this.dimension;
        }

        @Override
        public double[] getCoordinate() {
            return new double[]{this.sequence.getX(this.offset), this.sequence.getY(this.offset), this.sequence.getOrdinate(this.offset, 2)};
        }

        @Override
        public double getOrdinate(int arg0) throws IndexOutOfBoundsException {
            return this.sequence.getOrdinate(this.offset, arg0);
        }

        @Override
        public void setOrdinate(int arg0, double arg1) throws IndexOutOfBoundsException {
            this.sequence.setOrdinate(this.offset, arg0, arg1);
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            throw new UnsupportedOperationException();
        }

        public FlyWeightDirectPosition clone() {
            throw new UnsupportedOperationException();
        }

        public Position getPosition() {
            return this;
        }

        @Override
        public Position getDirectPosition() {
            return this;
        }
    }
}

