/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.api.filter.And;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.capability.ArithmeticOperators;
import org.geotools.api.filter.capability.ComparisonOperators;
import org.geotools.api.filter.capability.FilterCapabilities;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.capability.Functions;
import org.geotools.api.filter.capability.ScalarCapabilities;
import org.geotools.api.filter.capability.SpatialCapabilities;
import org.geotools.api.filter.capability.SpatialOperators;
import org.geotools.api.filter.capability.TemporalCapabilities;
import org.geotools.api.filter.capability.TemporalOperators;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;

public class IsSupportedFilterVisitor
implements FilterVisitor,
ExpressionVisitor {
    private FilterCapabilities capabilities;

    public IsSupportedFilterVisitor(FilterCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public Object visit(ExcludeFilter filter, Object extraData) {
        return false;
    }

    @Override
    public Object visit(IncludeFilter filter, Object extraData) {
        return false;
    }

    @Override
    public Object visit(And filter, Object extraData) {
        return this.capabilities.getScalarCapabilities() != null && this.capabilities.getScalarCapabilities().hasLogicalOperators();
    }

    @Override
    public Object visit(Id filter, Object extraData) {
        return this.capabilities.getIdCapabilities() != null && (this.capabilities.getIdCapabilities().hasFID() || this.capabilities.getIdCapabilities().hasEID());
    }

    @Override
    public Object visit(Not filter, Object extraData) {
        return this.capabilities.getScalarCapabilities() != null && this.capabilities.getScalarCapabilities().hasLogicalOperators();
    }

    @Override
    public Object visit(Or filter, Object extraData) {
        return this.capabilities.getScalarCapabilities() != null && this.capabilities.getScalarCapabilities().hasLogicalOperators();
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Between") != null;
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("EqualTo") != null;
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("NotEqualTo") != null;
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("GreaterThan") != null;
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("GreaterThanEqualTo") != null;
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("LessThan") != null;
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("LessThanEqualTo") != null;
    }

    @Override
    public Object visit(PropertyIsLike filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Like") != null;
    }

    @Override
    public Object visit(PropertyIsNull filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("NullCheck") != null;
    }

    @Override
    public Object visit(PropertyIsNil filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Nil") != null;
    }

    @Override
    public Object visit(BBOX filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("BBOX") != null;
    }

    @Override
    public Object visit(Beyond filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Beyond") != null;
    }

    @Override
    public Object visit(Contains filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Contains") != null;
    }

    @Override
    public Object visit(Crosses filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Crosses") != null;
    }

    @Override
    public Object visit(Disjoint filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Disjoint") != null;
    }

    @Override
    public Object visit(DWithin filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("DWithin") != null;
    }

    @Override
    public Object visit(Equals filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Equals") != null;
    }

    @Override
    public Object visit(Intersects filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Intersects") != null;
    }

    @Override
    public Object visit(Overlaps filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Overlaps") != null;
    }

    @Override
    public Object visit(Touches filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Touches") != null;
    }

    @Override
    public Object visit(Within filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Within") != null;
    }

    @Override
    public Object visitNullFilter(Object extraData) {
        return false;
    }

    @Override
    public Object visit(NilExpression expression, Object extraData) {
        return false;
    }

    @Override
    public Object visit(Add expression, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        return operators.hasSimpleArithmetic();
    }

    @Override
    public Object visit(Divide expression, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        return operators.hasSimpleArithmetic();
    }

    @Override
    public Object visit(Function function, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        Functions functions = operators.getFunctions();
        if (functions == null) {
            return false;
        }
        FunctionName found = functions.getFunctionName(function.getName());
        return found != null;
    }

    @Override
    public Object visit(Literal expression, Object extraData) {
        return true;
    }

    @Override
    public Object visit(Multiply expression, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        return operators.hasSimpleArithmetic();
    }

    @Override
    public Object visit(PropertyName expression, Object extraData) {
        return true;
    }

    @Override
    public Object visit(Subtract expression, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        return operators.hasSimpleArithmetic();
    }

    @Override
    public Object visit(After after, Object extraData) {
        return this.visit((BinaryTemporalOperator)after, (Object)"After");
    }

    @Override
    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.visit((BinaryTemporalOperator)anyInteracts, (Object)"AnyInteracts");
    }

    @Override
    public Object visit(Before before, Object extraData) {
        return this.visit((BinaryTemporalOperator)before, (Object)"Before");
    }

    @Override
    public Object visit(Begins begins, Object extraData) {
        return this.visit((BinaryTemporalOperator)begins, (Object)"Begins");
    }

    @Override
    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)begunBy, (Object)"BegunBy");
    }

    @Override
    public Object visit(During during, Object extraData) {
        return this.visit((BinaryTemporalOperator)during, (Object)"During");
    }

    @Override
    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)endedBy, (Object)"EndedBy");
    }

    @Override
    public Object visit(Ends ends, Object extraData) {
        return this.visit((BinaryTemporalOperator)ends, (Object)"Ends");
    }

    @Override
    public Object visit(Meets meets, Object extraData) {
        return this.visit((BinaryTemporalOperator)meets, (Object)"Meets");
    }

    @Override
    public Object visit(MetBy metBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)metBy, (Object)"MetBy");
    }

    @Override
    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)overlappedBy, (Object)"OverlappedBy");
    }

    @Override
    public Object visit(TContains contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, (Object)"TContains");
    }

    @Override
    public Object visit(TEquals equals, Object extraData) {
        return this.visit((BinaryTemporalOperator)equals, (Object)"TEquals");
    }

    @Override
    public Object visit(TOverlaps contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, (Object)"TOverlaps");
    }

    protected Object visit(BinaryTemporalOperator filter, Object data) {
        TemporalCapabilities temporal = this.capabilities.getTemporalCapabilities();
        if (temporal == null) {
            return false;
        }
        TemporalOperators operators = temporal.getTemporalOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator((String)data) != null;
    }
}

