/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Literal;
import org.geotools.filter.v1_0.OGC;
import org.geotools.util.Converters;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.geotools.xsd.Text;
import org.picocontainer.MutablePicoContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OGCLiteralTypeBinding
extends AbstractComplexBinding {
    private FilterFactory factory;

    public OGCLiteralTypeBinding(FilterFactory factory) {
        this.factory = factory;
    }

    @Override
    public QName getTarget() {
        return OGC.LiteralType;
    }

    @Override
    public int getExecutionMode() {
        return 2;
    }

    public Class getType() {
        return Literal.class;
    }

    @Override
    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List<Text> values = node.getChildValues(Text.class);
        if (!values.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<Text> iterator = values.iterator();
            while (iterator.hasNext()) {
                Text v;
                Text text = v = iterator.next();
                sb.append(text.getValue());
            }
            return this.factory.literal(sb.toString());
        }
        return this.factory.literal(value);
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        Literal literal = (Literal)object;
        Object unconvertedValue = literal.getValue();
        if (unconvertedValue != null) {
            String textValue = Converters.convert(unconvertedValue, String.class);
            value.appendChild(document.createTextNode(textValue));
        }
        return value;
    }
}

