/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.Date;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Literal;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Geometry;

public class ConstantExpression
implements Literal,
Cloneable {
    public static final ConstantExpression NULL = ConstantExpression.constant(null);
    public static final ConstantExpression BLACK = ConstantExpression.color(Color.BLACK);
    public static final ConstantExpression ZERO = ConstantExpression.constant(0);
    public static final ConstantExpression ONE = ConstantExpression.constant(1);
    public static final ConstantExpression TWO = ConstantExpression.constant(2);
    public static final ConstantExpression UNNAMED = ConstantExpression.constant("");
    final short type;
    Object value;

    protected ConstantExpression(Object value) {
        this(ConstantExpression.type(value), value);
    }

    protected ConstantExpression(short type, Object value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public Object evaluate(Object object) {
        return this.getValue();
    }

    @Override
    public <T> T evaluate(Object object, Class<T> context) {
        return Converters.convert(this.getValue(), context);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object constant) {
        throw new UnsupportedOperationException("Default value is immutable");
    }

    @Override
    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new ConstantExpression(this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Literal)) {
            return false;
        }
        Literal other = (Literal)obj;
        Object otherLiteral = other.getValue();
        if (this.value == null) {
            return otherLiteral == null;
        }
        if (this.value.getClass().isAssignableFrom(otherLiteral.getClass())) {
            return this.value.equals(other.getValue());
        }
        if (this.value instanceof Number && otherLiteral instanceof Number) {
            Number myNumber = (Number)this.value;
            Number otherNumber = (Number)otherLiteral;
            return myNumber.doubleValue() == otherNumber.doubleValue();
        }
        String myString = this.value.toString();
        String otherString = otherLiteral.toString();
        return myString.equals(otherString);
    }

    public int hashCode() {
        if (this.value instanceof Geometry || this.value instanceof Date) {
            return this.value.hashCode();
        }
        return this.value == null ? 0 : this.value.toString().hashCode();
    }

    public String toString() {
        if (this.value instanceof Color) {
            Color color = (Color)this.value;
            Object redCode = Integer.toHexString(color.getRed());
            Object greenCode = Integer.toHexString(color.getGreen());
            Object blueCode = Integer.toHexString(color.getBlue());
            if (((String)redCode).length() == 1) {
                redCode = "0" + (String)redCode;
            }
            if (((String)greenCode).length() == 1) {
                greenCode = "0" + (String)greenCode;
            }
            if (((String)blueCode).length() == 1) {
                blueCode = "0" + (String)blueCode;
            }
        }
        return this.value == null ? "NULL" : this.value.toString();
    }

    public static ConstantExpression color(Color color) {
        if (color == null) {
            return NULL;
        }
        Object redCode = Integer.toHexString(color.getRed());
        Object greenCode = Integer.toHexString(color.getGreen());
        Object blueCode = Integer.toHexString(color.getBlue());
        if (((String)redCode).length() == 1) {
            redCode = "0" + (String)redCode;
        }
        if (((String)greenCode).length() == 1) {
            greenCode = "0" + (String)greenCode;
        }
        if (((String)blueCode).length() == 1) {
            blueCode = "0" + (String)blueCode;
        }
        String colorCode = ("#" + (String)redCode + (String)greenCode + (String)blueCode).toUpperCase();
        return new ConstantExpression(colorCode);
    }

    public static ConstantExpression constant(double number) {
        return new ConstantExpression(number);
    }

    public static ConstantExpression constant(int number) {
        return new ConstantExpression(number);
    }

    public static ConstantExpression constant(Object value) {
        return new ConstantExpression(value);
    }

    static short type(Object value) {
        if (value instanceof Number) {
            if (value instanceof Double) {
                return 101;
            }
            if (value instanceof BigDecimal) {
                return 101;
            }
            return 102;
        }
        if (value instanceof Geometry) {
            return 104;
        }
        return 103;
    }
}

