/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.NIOUtilities;
import org.geotools.util.factory.Hints;

public class PrjFileReader
implements Closeable {
    private static final Boolean USE_MEMORY_MAPPED_BUFFERS = !System.getProperty("os.name", "Windows").contains("Windows");
    ByteBuffer buffer;
    ReadableByteChannel channel;
    CharBuffer charBuffer;
    CharsetDecoder decoder;
    CoordinateReferenceSystem crs;

    public PrjFileReader(ReadableByteChannel channel) throws IOException, FactoryException {
        this(channel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrjFileReader(ReadableByteChannel channel, Hints hints) throws IOException, FactoryException {
        try {
            Charset chars = StandardCharsets.ISO_8859_1;
            this.decoder = chars.newDecoder();
            this.channel = channel;
            this.init();
            this.decoder.decode(this.buffer, this.charBuffer, true);
            this.buffer.limit(this.buffer.capacity());
            this.charBuffer.flip();
            this.crs = ReferencingFactoryFinder.getCRSFactory(hints).createFromWKT(this.charBuffer.toString());
        }
        finally {
            this.close();
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    private int fill(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        int r = buffer.remaining();
        while (buffer.remaining() > 0 && r != -1) {
            r = channel.read(buffer);
        }
        if (r == -1) {
            buffer.limit(buffer.position());
        }
        return r;
    }

    private void init() throws IOException {
        if (this.channel instanceof FileChannel && USE_MEMORY_MAPPED_BUFFERS.booleanValue()) {
            FileChannel fc = (FileChannel)this.channel;
            this.buffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            ((Buffer)this.buffer).position((int)fc.position());
        } else {
            int size = 8192;
            this.buffer = ByteBuffer.allocateDirect(size);
            this.fill(this.buffer, this.channel);
            this.buffer.flip();
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.charBuffer = CharBuffer.allocate(8192);
        Charset chars = StandardCharsets.ISO_8859_1;
        this.decoder = chars.newDecoder();
    }

    @Override
    public void close() throws IOException {
        if (this.buffer != null) {
            NIOUtilities.clean(this.buffer);
            this.buffer = null;
        }
        if (this.channel.isOpen()) {
            this.channel.close();
        }
    }
}

