/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.geotools.api.data.Parameter;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.feature.type.Name;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.io.CoverageCapabilities;
import org.geotools.coverage.io.CoverageReadRequest;
import org.geotools.coverage.io.CoverageResponse;
import org.geotools.coverage.io.RasterLayout;
import org.geotools.coverage.io.metadata.MetadataNode;
import org.geotools.coverage.io.range.RangeType;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;

public interface CoverageSource {
    public Name getName(ProgressListener var1);

    public ResourceInfo getInfo(ProgressListener var1);

    public Map<String, Parameter<?>> getReadParameterInfo();

    public CoverageResponse read(CoverageReadRequest var1, ProgressListener var2) throws IOException;

    public RangeType getRangeType(ProgressListener var1) throws IOException;

    public void dispose();

    public EnumSet<CoverageCapabilities> getCapabilities();

    public MetadataNode getMetadata(String var1, ProgressListener var2);

    public Set<Name> getMetadataDomains();

    public CoordinateReferenceSystem getCoordinateReferenceSystem();

    public SpatialDomain getSpatialDomain() throws IOException;

    public TemporalDomain getTemporalDomain() throws IOException;

    public VerticalDomain getVerticalDomain() throws IOException;

    public List<AdditionalDomain> getAdditionalDomains() throws IOException;

    public List<? extends RasterLayout> getOverviewsLayouts(ProgressListener var1) throws IOException;

    public int getOverviewsNumber(ProgressListener var1) throws IOException;

    public List<DimensionDescriptor> getDimensionDescriptors() throws IOException;

    public static abstract class AdditionalDomain {
        public abstract Set<Object> getElements(boolean var1, ProgressListener var2) throws IOException;

        public abstract String getName();

        public abstract DomainType getType();
    }

    public static abstract class VerticalDomain {
        public abstract SortedSet<? extends NumberRange<Double>> getVerticalElements(boolean var1, ProgressListener var2) throws IOException;

        public abstract CoordinateReferenceSystem getCoordinateReferenceSystem();
    }

    public static abstract class TemporalDomain {
        public abstract SortedSet<? extends DateRange> getTemporalElements(boolean var1, ProgressListener var2) throws IOException;

        public abstract CoordinateReferenceSystem getCoordinateReferenceSystem();
    }

    public static abstract class SpatialDomain {
        public abstract Set<? extends BoundingBox> getSpatialElements(boolean var1, ProgressListener var2) throws IOException;

        public abstract CoordinateReferenceSystem getCoordinateReferenceSystem2D();

        public abstract MathTransform2D getGridToWorldTransform(ProgressListener var1) throws IOException;

        public abstract Set<? extends RasterLayout> getRasterElements(boolean var1, ProgressListener var2) throws IOException;
    }

    public static enum DomainType {
        NUMBER,
        NUMBERRANGE,
        DATE,
        DATERANGE,
        STRING;

    }
}

