/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geotools.api.coverage.grid.Format;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.util.Utilities;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.factory.OptionalFactory;

public final class GridFormatFinder {
    private static volatile FactoryRegistry registry;

    private GridFormatFinder() {
    }

    public static synchronized Set<GridFormatFactorySpi> getAvailableFormats() {
        GridFormatFinder.scanForPlugins();
        return GridFormatFinder.getServiceRegistry().getFactories(GridFormatFactorySpi.class, true).filter(OptionalFactory::isAvailable).collect(Utilities.toUnmodifiableSet());
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(GridFormatFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(GridFormatFactorySpi.class));
        }
        return registry;
    }

    public static synchronized void scanForPlugins() {
        GridFormatFinder.getServiceRegistry().scanForPlugins();
    }

    public static Format[] getFormatArray() {
        Set<GridFormatFactorySpi> formats = GridFormatFinder.getAvailableFormats();
        ArrayList<AbstractGridFormat> formatSet = new ArrayList<AbstractGridFormat>(formats.size());
        for (GridFormatFactorySpi element : formats) {
            formatSet.add(element.createFormat());
        }
        return formatSet.toArray(new Format[formatSet.size()]);
    }

    public static synchronized Set<AbstractGridFormat> findFormats(Object o) {
        return GridFormatFinder.findFormats(o, GeoTools.getDefaultHints());
    }

    public static synchronized Set<AbstractGridFormat> findFormats(Object o, Hints hints) {
        Set<GridFormatFactorySpi> availableFormats = GridFormatFinder.getAvailableFormats();
        HashSet<AbstractGridFormat> formats = new HashSet<AbstractGridFormat>();
        for (GridFormatFactorySpi spi : availableFormats) {
            AbstractGridFormat retVal = spi.createFormat();
            if (!(retVal instanceof AbstractGridFormat) || !retVal.accepts(o, hints)) continue;
            formats.add(retVal);
        }
        return Collections.unmodifiableSet(formats);
    }

    public static synchronized AbstractGridFormat findFormat(Object o) {
        return GridFormatFinder.findFormat(o, GeoTools.getDefaultHints());
    }

    public static synchronized AbstractGridFormat findFormat(Object o, Hints hints) {
        Set<AbstractGridFormat> formats = GridFormatFinder.findFormats(o, hints);
        for (AbstractGridFormat f : formats) {
            if (!"GeoTIFF".equals(f.getName())) continue;
            return f;
        }
        Iterator<AbstractGridFormat> it = formats.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return new UnknownFormat();
    }
}

