/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import com.sun.media.jai.util.PropertyGeneratorImpl;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.translate.TranslateIntOpImage;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collections;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.locationtech.jts.geom.Geometry;

class ScalePropertyGenerator
extends PropertyGeneratorImpl {
    public ScalePropertyGenerator() {
        super(new String[]{"ROI"}, new Class[]{ROI.class}, new Class[]{RenderedOp.class});
    }

    @Override
    public Object getProperty(String name, Object opNode) {
        this.validate(name, opNode);
        if (opNode instanceof RenderedOp && name.equalsIgnoreCase("roi")) {
            RenderedOp op = (RenderedOp)opNode;
            ParameterBlock pb = op.getParameterBlock();
            RenderedImage src = pb.getRenderedSource(0);
            Object property = src.getProperty("ROI");
            if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                if (pb.getObjectParameter(5) != null) {
                    property = pb.getObjectParameter(5);
                } else {
                    return Image.UndefinedProperty;
                }
            }
            ROI srcROI = (ROI)property;
            Interpolation interp = (Interpolation)pb.getObjectParameter(4);
            Rectangle srcBounds = new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
            if (!srcBounds.contains(srcROI.getBounds())) {
                srcROI = srcROI.intersect(new ROIShape(srcBounds));
            }
            float sx = pb.getFloatParameter(0);
            float sy = pb.getFloatParameter(1);
            float tx = pb.getFloatParameter(2);
            float ty = pb.getFloatParameter(3);
            ImageLayout targetLayout = new ImageLayout(op);
            targetLayout.unsetValid(512);
            targetLayout.unsetValid(256);
            Rectangle dstBounds = op.getBounds();
            PlanarImage roiImage = null;
            if (sx == 1.0f && sy == 1.0f && Math.abs(tx - (float)((int)tx)) < 0.01f && Math.abs(ty - (float)((int)ty)) < 0.01f) {
                roiImage = new TranslateIntOpImage(srcROI.getAsImage(), null, (int)tx, (int)ty);
            } else if (interp instanceof InterpolationBilinear || interp instanceof javax.media.jai.InterpolationBilinear || interp instanceof InterpolationBicubic || interp instanceof javax.media.jai.InterpolationBicubic) {
                ImageLayout2 layout = new ImageLayout2();
                int minx = (int)srcBounds.getMinX();
                int miny = (int)srcBounds.getMinY();
                int w = (int)srcBounds.getWidth();
                int h = (int)srcBounds.getHeight();
                layout.setMinX(minx);
                layout.setMinY(miny);
                layout.setWidth(w);
                layout.setHeight(h);
                RenderingHints hints = new RenderingHints(Collections.emptyMap());
                hints.putAll((Map<?, ?>)op.getRenderingHints());
                hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
                RenderedOp constantImage = ConstantDescriptor.create(new Float(w), new Float(h), new Byte[]{(byte)-1}, hints);
                BorderExtender extender = BorderExtender.createInstance(1);
                RenderingHints scalingHints = new RenderingHints(Collections.emptyMap());
                scalingHints.putAll((Map<?, ?>)op.getRenderingHints());
                scalingHints.put(JAI.KEY_IMAGE_LAYOUT, targetLayout);
                scalingHints.put(JAI.KEY_BORDER_EXTENDER, extender);
                boolean isBilinear = interp instanceof InterpolationBilinear || interp instanceof javax.media.jai.InterpolationBilinear;
                Interpolation interpParam = isBilinear ? new InterpolationBilinear(interp.getSubsampleBitsH(), null, false, 0.0, ((PlanarImage)constantImage).getSampleModel().getDataType()) : new InterpolationBicubic(interp.getSubsampleBitsH(), null, false, 0.0, ((PlanarImage)constantImage).getSampleModel().getDataType(), false, 8);
                ParameterBlock paramBlock = new ParameterBlock();
                paramBlock.setSource(constantImage, 0);
                paramBlock.add(Float.valueOf(sx));
                paramBlock.add(Float.valueOf(sy));
                paramBlock.add(Float.valueOf(tx));
                paramBlock.add(Float.valueOf(ty));
                paramBlock.add(interpParam);
                if (srcROI instanceof ROIGeometry) {
                    ROIGeometry roiGeom = (ROIGeometry)srcROI;
                    Geometry geom = roiGeom.getAsGeometry();
                    if (geom != null && !geom.isEmpty()) {
                        paramBlock.add(srcROI);
                    }
                } else {
                    paramBlock.add(srcROI);
                }
                roiImage = JAI.create("Scale", paramBlock, scalingHints);
            } else {
                RenderingHints scalingHints = new RenderingHints(Collections.emptyMap());
                scalingHints.putAll((Map<?, ?>)op.getRenderingHints());
                scalingHints.put(JAI.KEY_IMAGE_LAYOUT, targetLayout);
                PlanarImage roiMod = srcROI.getAsImage();
                ParameterBlock paramBlock = new ParameterBlock();
                paramBlock.setSource(roiMod, 0);
                paramBlock.add(Float.valueOf(sx));
                paramBlock.add(Float.valueOf(sy));
                paramBlock.add(Float.valueOf(tx));
                paramBlock.add(Float.valueOf(ty));
                if (interp != null) {
                    if (interp instanceof InterpolationBicubic || interp instanceof javax.media.jai.InterpolationBicubic) {
                        InterpolationBilinear interpBilinear = new InterpolationBilinear(interp.getSubsampleBitsH(), null, false, 0.0, roiMod.getSampleModel().getDataType());
                        paramBlock.add(interpBilinear);
                    } else {
                        paramBlock.add(interp);
                    }
                }
                roiImage = JAI.create("Scale", paramBlock, scalingHints);
            }
            ROI dstROI = new ROI(roiImage, 1);
            if (!dstBounds.contains(dstROI.getBounds())) {
                dstROI = dstROI.intersect(new ROIShape(dstBounds));
            }
            return dstROI;
        }
        return Image.UndefinedProperty;
    }
}

