/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.buildings_tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public final class ToolSettings {
    public static final BooleanProperty PROP_USE_ADDR_NODE = new BooleanProperty("buildings_tools.addrNode", false);
    private static Shape shape = ToolSettings.loadShape();
    private static double width;
    private static double lenstep;
    private static boolean useAddr;
    private static final Map<String, String> TAGS;

    private ToolSettings() {
    }

    public static Shape getShape() {
        ToolSettings.loadShape();
        return shape;
    }

    public static void setAddrDialog(boolean useAddr) {
        ToolSettings.useAddr = useAddr;
    }

    public static void setSizes(double newwidth, double newlenstep) {
        width = newwidth;
        lenstep = newlenstep;
    }

    public static double getWidth() {
        return width;
    }

    public static double getLenStep() {
        return lenstep;
    }

    public static boolean isUsingAddr() {
        return useAddr;
    }

    public static Map<String, String> getTags() {
        ToolSettings.loadTags();
        return Collections.unmodifiableMap(TAGS);
    }

    public static void saveTags(Map<String, String> tags) {
        TAGS.clear();
        TAGS.putAll(tags);
        ArrayList<String> values = new ArrayList<String>(TAGS.size() * 2);
        for (Map.Entry<String, String> entry : TAGS.entrySet()) {
            values.add(entry.getKey());
            values.add(entry.getValue());
        }
        Config.getPref().putList("buildings_tools.tags", values);
    }

    private static void loadTags() {
        TAGS.clear();
        List values = Config.getPref().getList("buildings_tools.tags", Arrays.asList("building", "yes"));
        try {
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                TAGS.put((String)iterator.next(), (String)iterator.next());
            }
        }
        catch (NoSuchElementException e) {
            Logging.warn((Throwable)e);
        }
    }

    public static void saveShape(Shape shape) {
        Config.getPref().put("buildings_tool.shape", shape.name());
    }

    private static Shape loadShape() {
        String shape = Config.getPref().get("buildings_tool.shape");
        if (Shape.CIRCLE.name().equals(shape)) {
            ToolSettings.shape = Shape.CIRCLE;
            return Shape.CIRCLE;
        }
        ToolSettings.shape = Shape.RECTANGLE;
        return Shape.RECTANGLE;
    }

    public static void setBBMode(boolean bbmode) {
        Config.getPref().putBoolean("buildings_tools.bbmode", bbmode);
    }

    public static boolean isBBMode() {
        return Config.getPref().getBoolean("buildings_tools.bbmode", false);
    }

    public static void setSoftCursor(boolean softCursor) {
        Config.getPref().putBoolean("buildings_tools.softcursor", softCursor);
    }

    public static boolean isSoftCursor() {
        return Config.getPref().getBoolean("buildings_tools.softcursor", false);
    }

    public static boolean isAutoSelect() {
        return Config.getPref().getBoolean("buildings_tools.autoselect", false);
    }

    public static void setAutoSelect(boolean autoSelect) {
        Config.getPref().putBoolean("buildings_tools.autoselect", autoSelect);
    }

    public static boolean isAutoSelectReplaceSelection() {
        return Config.getPref().getBoolean("buildings_tools.autoselect_replace_selection", false);
    }

    public static void setAutoSelectReplaceSelection(boolean autoSelectReplace) {
        Config.getPref().putBoolean("buildings_tools.autoselect_replace_selection", autoSelectReplace);
    }

    public static boolean isTogglingBuildingTypeOnRepeatedKeyPress() {
        return Config.getPref().getBoolean("buildings_tools.toggle_building_type", false);
    }

    public static void setTogglingBuildingTypeOnRepeatedKeyPress(boolean toggle) {
        Config.getPref().putBoolean("buildings_tools.toggle_building_type", toggle);
    }

    public static boolean isNoClickAndDrag() {
        return Config.getPref().getBoolean("buildings_tools.noclickdrag", false);
    }

    public static void setNoClickAndDrag(boolean noClickDrag) {
        Config.getPref().putBoolean("buildings_tools.noclickdrag", noClickDrag);
    }

    static {
        TAGS = new HashMap<String, String>();
    }

    public static enum Shape {
        CIRCLE,
        RECTANGLE;

    }
}

